/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.exception;

public class RegularExpressionException
extends IllegalArgumentException {
    private String desc;
    private String pattern;
    private int index;
    private int location;

    public RegularExpressionException(String mes, int location) {
        super(mes);
        this.location = location;
    }

    public int getLocation() {
        return this.location;
    }

    public RegularExpressionException(String desc, String regex, int index) {
        this.desc = desc;
        this.pattern = regex;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getMessage() {
        if (this.pattern != null || this.desc != null) {
            String nl = System.getProperty("line.separator");
            StringBuffer sb = new StringBuffer();
            sb.append(this.desc);
            if (this.index >= 0) {
                sb.append(" near index ");
                sb.append(this.index);
            }
            sb.append(nl);
            sb.append(this.pattern);
            if (this.index >= 0) {
                sb.append(nl);
                int i = 0;
                while (i < this.index) {
                    sb.append(' ');
                    ++i;
                }
                sb.append('^');
            }
            return sb.toString();
        }
        return super.getMessage();
    }
}

