/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.Facet;
import com.sap.engine.lib.schema.components.FundamentalFacets;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.SchemaStructuresFactory;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.FacetImpl;
import com.sap.engine.lib.schema.components.impl.structures.TypeDefinitionBaseImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleTypeDefinitionImpl
extends TypeDefinitionBaseImpl
implements SimpleTypeDefinition {
    protected static final int ATOMIC = 1;
    protected static final int LIST = 2;
    protected static final int UNION = 3;
    protected static final int UNKNOWN = 0;
    protected int variety;
    protected SimpleTypeDefinitionImpl primitiveTypeDefinition;
    protected SimpleTypeDefinitionImpl itemTypeDefinition;
    protected Vector memberTypeDefsCollector = new Vector();
    protected Vector facetsCollector = new Vector();
    protected FundamentalFacets fundamentalFacets;
    protected boolean isPrimitive;
    protected boolean isFinalList;
    protected boolean isFinalUnion;
    protected String whiteSpaceNormalizationValue;

    public SimpleTypeDefinitionImpl() {
        this(null);
    }

    public SimpleTypeDefinitionImpl(BaseInfo baseInfo) {
        this(null, baseInfo);
    }

    public SimpleTypeDefinitionImpl(Node associatedNode, BaseInfo baseInfo) {
        this(associatedNode, baseInfo, false);
    }

    public SimpleTypeDefinitionImpl(Node associatedNode, BaseInfo baseInfo, boolean isTopLevel) {
        super(associatedNode, baseInfo, isTopLevel);
    }

    public String getWhiteSpaceNormalizationValue() {
        return this.whiteSpaceNormalizationValue;
    }

    public int getTypeOfComponent() {
        return 2;
    }

    public SimpleTypeDefinition getBaseTypeDefinitionSimple() {
        return (SimpleTypeDefinition)((Object)this.baseTypeDefinition);
    }

    public boolean isFinalList() {
        return this.isFinalList;
    }

    public boolean isFinalUnion() {
        return this.isFinalUnion;
    }

    public boolean isVarietyAtomic() {
        return this.variety == 1;
    }

    public boolean isVarietyList() {
        return this.variety == 2;
    }

    public boolean isVarietyUnion() {
        return this.variety == 3;
    }

    public SimpleTypeDefinition getPrimitiveTypeDefinition() {
        return this.primitiveTypeDefinition;
    }

    public SimpleTypeDefinition getItemTypeDefinition() {
        return this.itemTypeDefinition;
    }

    public void getMemberTypeDefinitions(Vector collector) {
        Tools.removeFromVectorToVector(this.memberTypeDefsCollector, collector);
    }

    public void getFacets(Vector collector) {
        Tools.removeFromVectorToVector(this.facetsCollector, collector);
    }

    public Facet[] getFacetsArray() {
        Object[] result = new Facet[this.facetsCollector.size()];
        this.facetsCollector.copyInto(result);
        return result;
    }

    public FundamentalFacets getFundamentalFacets() {
        return this.fundamentalFacets;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean match(Base simpleTypeDef) {
        if (!super.match(simpleTypeDef)) {
            return false;
        }
        SimpleTypeDefinitionImpl targetSimpleTypeDef = (SimpleTypeDefinitionImpl)simpleTypeDef;
        if (this.isBuiltIn) {
            return targetSimpleTypeDef.isBuiltIn;
        }
        return Tools.compareUnorderdSetsOfBases(this.facetsCollector, targetSimpleTypeDef.facetsCollector) && this.isFinalExtension == targetSimpleTypeDef.isFinalExtension && this.isFinalRestriction == targetSimpleTypeDef.isFinalRestriction && this.isFinalList == targetSimpleTypeDef.isFinalList && this.isFinalUnion == targetSimpleTypeDef.isFinalUnion && this.variety == targetSimpleTypeDef.variety && Tools.compareBases(this.primitiveTypeDefinition, targetSimpleTypeDef.primitiveTypeDefinition) && Tools.compareBases(this.itemTypeDefinition, targetSimpleTypeDef.itemTypeDefinition) && Tools.compareUnorderdSetsOfBases(this.memberTypeDefsCollector, targetSimpleTypeDef.memberTypeDefsCollector);
    }

    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.id = this.loadAttribsCollector.getProperty("id");
            String finalAttribValue = this.loadAttribsCollector.getProperty("final");
            if (finalAttribValue != null) {
                if (finalAttribValue.equals("#all")) {
                    this.isFinalExtension = true;
                    this.isFinalRestriction = true;
                    this.isFinalList = true;
                    this.isFinalUnion = true;
                } else if (finalAttribValue.equals("list")) {
                    this.isFinalList = true;
                } else if (finalAttribValue.equals("union")) {
                    this.isFinalUnion = true;
                } else if (finalAttribValue.equals("restriction")) {
                    this.isFinalRestriction = true;
                }
            } else {
                this.isFinalExtension = this.baseInfo.isFinalExtension();
                this.isFinalRestriction = this.baseInfo.isFinalRestriction();
            }
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("restriction")) {
                        this.processRestriction(node);
                    } else if (nodeLocalName.equals("annotation")) {
                        this.annotation = SchemaStructuresFactory.createAnnotation(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(this.annotation);
                    } else if (nodeLocalName.equals("list")) {
                        this.processList(node);
                    } else if (nodeLocalName.equals("union")) {
                        this.processUnion(node);
                    }
                }
                ++i;
            }
            this.baseInfo.getSchema().allComponentsCollector.add(this);
        }
    }

    private void processRestriction(Node node) throws SchemaComponentException {
        NamedNodeMap attribs = node.getAttributes();
        int i = 0;
        while (i < attribs.getLength()) {
            Node attrib = attribs.item(i);
            String attribName = attrib.getLocalName();
            String uri = attrib.getNamespaceURI();
            String value = attrib.getNodeValue();
            if ((uri == null || uri.equals("")) && attribName.equals("base")) {
                this.initBase((TypeDefinitionBaseImpl)this.getTopLevelBase(node, value, 16));
            }
            ++i;
        }
        NodeList childNodes = node.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            Node childNode = childNodes.item(j);
            if (childNode.getNodeType() == 1) {
                String uri = childNode.getNamespaceURI();
                String elemName = childNode.getLocalName();
                if (uri.equals("http://www.w3.org/2001/XMLSchema") && !elemName.equals("annotation")) {
                    if (elemName.equals("simpleType")) {
                        if (this.baseTypeDefinition != null) {
                            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of simple type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <restriction> alternative is chosen, either it must have a base [attribute] or a <simpleType> among its [children], but not both.");
                        }
                        this.initBase(SchemaStructuresFactory.createSimpleTypeDefinition(childNode, this.baseInfo));
                    } else if (elemName.equals("minExclusive") || elemName.equals("minInclusive") || elemName.equals("maxExclusive") || elemName.equals("maxInclusive") || elemName.equals("totalDigits") || elemName.equals("fractionDigits") || elemName.equals("length") || elemName.equals("minLength") || elemName.equals("maxLength") || elemName.equals("enumeration") || elemName.equals("whiteSpace") || elemName.equals("pattern")) {
                        FacetImpl restrictedFacet = SchemaStructuresFactory.createFacet(childNode, this.baseInfo);
                        SchemaStructuresFactory.loadBase(restrictedFacet);
                        this.addRestrictedFacet(restrictedFacet);
                    }
                }
            }
            ++j;
        }
    }

    private void initBase(TypeDefinitionBaseImpl typeDefBase) throws SchemaComponentException {
        if (!(typeDefBase instanceof SimpleTypeDefinitionImpl)) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of simple type " + DOM.toXPath(this.associatedNode) + " is not corect. The {base type definition} must be a simple type definition.");
        }
        this.baseTypeDefinition = typeDefBase;
        SchemaStructuresFactory.loadBase(this.baseTypeDefinition);
        SimpleTypeDefinitionImpl baseTypeDef = (SimpleTypeDefinitionImpl)this.baseTypeDefinition;
        this.facetsCollector.addAll(baseTypeDef.facetsCollector);
        this.fundamentalFacets = baseTypeDef.fundamentalFacets;
        this.variety = baseTypeDef.variety;
        this.whiteSpaceNormalizationValue = baseTypeDef.whiteSpaceNormalizationValue;
        if (baseTypeDef.isFinalRestriction) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. The {final} of the {base type definition} must not contain restriction.");
        }
        if (this.variety == 1) {
            this.primitiveTypeDefinition = baseTypeDef.primitiveTypeDefinition;
        } else if (this.variety == 2) {
            if (baseTypeDef.isFinalList) {
                throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. If the {variety} is 'list', then the {final} of the {base type definition} must not contain 'list'.");
            }
            this.itemTypeDefinition = baseTypeDef.itemTypeDefinition;
        } else {
            if (baseTypeDef.isFinalUnion) {
                throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. If the {variety} is 'union', then The {final} of the {base type definition} must not contain 'union'.");
            }
            this.memberTypeDefsCollector.addAll(baseTypeDef.memberTypeDefsCollector);
        }
    }

    private void processList(Node node) throws SchemaComponentException {
        NamedNodeMap attribs = node.getAttributes();
        int i = 0;
        while (i < attribs.getLength()) {
            Node attrib = attribs.item(i);
            String attrName = attrib.getLocalName();
            String uri = attrib.getNamespaceURI();
            String value = attrib.getNodeValue();
            if ((uri == null || uri.equals("")) && attrName.equals("itemType")) {
                this.initItemTypeDefinition((TypeDefinitionBaseImpl)this.getTopLevelBase(node, value, 16));
            }
            ++i;
        }
        NodeList childNodes = node.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            Node childNode = childNodes.item(j);
            if (childNode.getNodeType() == 1) {
                String uri = childNode.getNamespaceURI();
                String elemName = childNode.getLocalName();
                if (uri.equals("http://www.w3.org/2001/XMLSchema") && !elemName.equals("annotation") && elemName.equals("simpleType")) {
                    if (this.itemTypeDefinition != null) {
                        throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of simple type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <list> alternative is chosen, either it must have an itemType [attribute] or a <simpleType> among its [children], but not both.");
                    }
                    this.initItemTypeDefinition(SchemaStructuresFactory.createSimpleTypeDefinition(childNode, this.baseInfo));
                }
            }
            ++j;
        }
        this.whiteSpaceNormalizationValue = "collapse";
        this.baseTypeDefinition = (SimpleTypeDefinitionImpl)this.baseInfo.getSchema().getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "anySimpleType");
        this.variety = 2;
    }

    private void processUnion(Node node) throws SchemaComponentException {
        NamedNodeMap attribs = node.getAttributes();
        int i = 0;
        while (i < attribs.getLength()) {
            Node attrib = attribs.item(i);
            String attribName = attrib.getLocalName();
            String uri = attrib.getNamespaceURI();
            String value = attrib.getNodeValue();
            if ((uri == null || uri.equals("")) && attribName.equals("memberTypes")) {
                StringTokenizer tokenizer = new StringTokenizer(value);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    TypeDefinitionBaseImpl typeDefBase = (TypeDefinitionBaseImpl)this.getTopLevelBase(node, token, 16);
                    this.initMemeberTypeDefinition(typeDefBase);
                }
            }
            ++i;
        }
        NodeList childNodes = node.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            Node childNode = childNodes.item(j);
            if (childNode.getNodeType() == 1) {
                String uri = childNode.getNamespaceURI();
                String elemName = childNode.getLocalName();
                if (uri.equals("http://www.w3.org/2001/XMLSchema") && !elemName.equals("annotation") && elemName.equals("simpleType")) {
                    this.initMemeberTypeDefinition(SchemaStructuresFactory.createSimpleTypeDefinition(childNode, this.baseInfo));
                }
            }
            ++j;
        }
        this.baseTypeDefinition = (SimpleTypeDefinitionImpl)this.baseInfo.getSchema().getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "anySimpleType");
        this.variety = 3;
    }

    private void initItemTypeDefinition(TypeDefinitionBaseImpl itemTypeDef) throws SchemaComponentException {
        if (!(itemTypeDef instanceof SimpleTypeDefinitionImpl)) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of simple type " + DOM.toXPath(this.associatedNode) + " is not correct. The item type definition must be a simple type definition.");
        }
        this.itemTypeDefinition = (SimpleTypeDefinitionImpl)itemTypeDef;
        SchemaStructuresFactory.loadBase(this.itemTypeDefinition);
        if (this.itemTypeDefinition.isFinalList) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. The {item type definition} must not have {final} property set to 'list'.");
        }
        if (this.itemTypeDefinition.variety == 2) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. The {item type definition} must have a {variety} of atomic or union.");
        }
        if (this.itemTypeDefinition.variety == 3) {
            int i = 0;
            while (i < this.itemTypeDefinition.memberTypeDefsCollector.size()) {
                SimpleTypeDefinitionImpl memberTypeDef = (SimpleTypeDefinitionImpl)this.itemTypeDefinition.memberTypeDefsCollector.get(i);
                if (memberTypeDef.variety != 1) {
                    throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. The {item type definition} must have a {variety} of atomic or union(in which case all the {member type definitions} must be atomic).");
                }
                ++i;
            }
        }
    }

    private void initMemeberTypeDefinition(TypeDefinitionBaseImpl memberTypeDef) throws SchemaComponentException {
        if (!(memberTypeDef instanceof SimpleTypeDefinitionImpl)) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of simple type " + DOM.toXPath(this.associatedNode) + " is not correct. Each member type definition must be a simple type definition.");
        }
        SimpleTypeDefinitionImpl memberSimpleTypeDef = (SimpleTypeDefinitionImpl)memberTypeDef;
        SchemaStructuresFactory.loadBase(memberSimpleTypeDef);
        if (memberSimpleTypeDef.variety == 3) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. If the {variety} is union, then the {member type definitions} must all have {variety} of atomic or list.");
        }
        if (memberSimpleTypeDef.isFinalUnion) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. If the {variety} is union, then any of the {member type definitions} must not have {final} set to 'union'.");
        }
        this.memberTypeDefsCollector.add(memberTypeDef);
    }

    public boolean isDerivedFrom(TypeDefinitionBase typeDefinition, boolean disallowedRestriction, boolean disallowedExtension) {
        TypeDefinitionBaseImpl typeDefBase = (TypeDefinitionBaseImpl)typeDefinition;
        if (typeDefBase == null) {
            return false;
        }
        if (typeDefBase.isUrType) {
            return true;
        }
        if (this == typeDefBase || this.match(typeDefBase)) {
            return true;
        }
        if (disallowedRestriction) {
            return false;
        }
        if (!this.baseTypeDefinition.isUrType) {
            return this.baseTypeDefinition.isDerivedFrom(typeDefBase, disallowedRestriction, disallowedExtension);
        }
        if (typeDefBase instanceof SimpleTypeDefinitionImpl) {
            SimpleTypeDefinitionImpl simpleTypeDef = (SimpleTypeDefinitionImpl)typeDefBase;
            if (simpleTypeDef.variety == 3) {
                int i = 0;
                while (i < simpleTypeDef.memberTypeDefsCollector.size()) {
                    SimpleTypeDefinitionImpl memberTypeDef = (SimpleTypeDefinitionImpl)simpleTypeDef.memberTypeDefsCollector.get(i);
                    if (this.isDerivedFrom(memberTypeDef, disallowedRestriction, disallowedExtension)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    protected void addRestrictedFacet(FacetImpl facet) throws SchemaComponentException {
        if (!(this.variety != 2 || facet.facetName.equals("length") || facet.facetName.equals("minLength") || facet.facetName.equals("maxLength") || facet.facetName.equals("pattern") || facet.facetName.equals("enumeration"))) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. If the {variety} is list, then Only length, minLength, maxLength, pattern and enumeration facet components are allowed among the {facets}.");
        }
        if (this.variety == 3 && !facet.facetName.equals("pattern") && !facet.facetName.equals("enumeration")) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. If the {variety} is union, then Only pattern and enumeration facet components are allowed among the {facets}.");
        }
        if (facet.facetName.equals("pattern") || facet.facetName.equals("enumeration")) {
            boolean isIncluded = false;
            int i = 0;
            while (i < this.facetsCollector.size()) {
                FacetImpl includedFacet = (FacetImpl)this.facetsCollector.get(i);
                if (includedFacet.valueString.equals(facet.valueString)) {
                    isIncluded = true;
                    break;
                }
                ++i;
            }
            if (!isIncluded) {
                this.facetsCollector.add(facet);
            }
        } else {
            if (facet.facetName.equals("whiteSpace")) {
                this.whiteSpaceNormalizationValue = facet.valueString;
            }
            boolean isIncluded = false;
            int i = 0;
            while (i < this.facetsCollector.size()) {
                FacetImpl includedFacet = (FacetImpl)this.facetsCollector.get(i);
                if (includedFacet.facetName.equals(facet.facetName)) {
                    this.facetsCollector.set(i, facet);
                    isIncluded = true;
                    break;
                }
                ++i;
            }
            if (!isIncluded) {
                this.facetsCollector.add(facet);
            }
        }
    }

    public BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        SimpleTypeDefinitionImpl result = (SimpleTypeDefinitionImpl)super.initializeBase(base, clonedCollector);
        result.variety = this.variety;
        result.primitiveTypeDefinition = this.primitiveTypeDefinition;
        if (this.itemTypeDefinition != null) {
            result.itemTypeDefinition = this.itemTypeDefinition.isBuiltIn ? this.itemTypeDefinition : (SimpleTypeDefinitionImpl)this.itemTypeDefinition.clone(clonedCollector);
        }
        Tools.cloneVectorWithBases(this.memberTypeDefsCollector, result.memberTypeDefsCollector, clonedCollector);
        Tools.cloneVectorWithBases(this.facetsCollector, result.facetsCollector, clonedCollector);
        result.fundamentalFacets = this.fundamentalFacets;
        result.isPrimitive = this.isPrimitive;
        result.isFinalList = this.isFinalList;
        result.isFinalUnion = this.isFinalUnion;
        result.whiteSpaceNormalizationValue = this.whiteSpaceNormalizationValue;
        return result;
    }
}

