/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.QualifiedBase;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.structures.AttributeDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.ElementDeclarationImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.exception.SchemaRuntimeException;
import com.sap.engine.lib.schema.util.LexicalParser;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import org.w3c.dom.Node;

public abstract class QualifiedBaseImpl
extends BaseImpl
implements QualifiedBase {
    protected String name;
    protected String targetNamespace;
    protected boolean isTopLevel;
    protected String qualifiedKey;

    public QualifiedBaseImpl() {
        this(null, null, false);
    }

    public QualifiedBaseImpl(boolean isTopLevel) {
        this(null, null, isTopLevel);
    }

    public QualifiedBaseImpl(Node associatedNode, BaseInfo baseInfo) {
        this(associatedNode, baseInfo, false);
    }

    public QualifiedBaseImpl(Node associatedNode, BaseInfo baseInfo, boolean isTopLevel) {
        super(associatedNode, baseInfo);
        this.isTopLevel = isTopLevel;
        if (baseInfo != null) {
            this.targetNamespace = !isTopLevel && (this instanceof ElementDeclarationImpl && !baseInfo.elemsFormDefaultIsQualified() || this instanceof AttributeDeclarationImpl && !baseInfo.attribsFormDefaultIsQualified()) ? "" : baseInfo.getTargetNamespace();
            String formValue = this.loadAttribsCollector.getProperty("form");
            if (formValue != null) {
                this.targetNamespace = formValue.equals("qualified") ? baseInfo.getTargetNamespace() : "";
            }
            this.name = this.loadAttribsCollector.getProperty("name");
            if (this.name == null) {
                if (isTopLevel) {
                    throw new SchemaRuntimeException("[location : '" + baseInfo.getLocation() + "'] ERROR : Definition of qualified base " + DOM.toXPath(associatedNode) + " is not correct. The value of {name} property must not be absent.");
                }
                this.name = "";
            } else if (LexicalParser.parseNCName(this.name) == null) {
                throw new SchemaRuntimeException("[location : '" + baseInfo.getLocation() + "'] ERROR : Definition of qualified base " + DOM.toXPath(associatedNode) + " is not correct. The value of {name} property is not a valid NCName.");
            }
            this.qualifiedKey = Tools.generateKey(this.targetNamespace, this.name);
        }
    }

    public final String getName() {
        return this.name;
    }

    public final String getTargetNamespace() {
        return this.targetNamespace;
    }

    public boolean isAnonymous() {
        return this.name.equals("");
    }

    public boolean match(Base qualifiedBase) {
        if (!super.match(qualifiedBase)) {
            return false;
        }
        QualifiedBaseImpl targetQualifiedBase = (QualifiedBaseImpl)qualifiedBase;
        return Tools.compareStringProps(this.name, targetQualifiedBase.name) && this.targetNamespace.equals(targetQualifiedBase.targetNamespace);
    }

    protected Base getTopLevelBase(Node node, String qName, int type) throws SchemaComponentException {
        return Tools.getTopLevelBase(this.baseInfo.getSchema(), this.baseInfo.getLoader(), node, qName, type, this.baseInfo.getLocation());
    }

    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        QualifiedBaseImpl result = (QualifiedBaseImpl)super.initializeBase(base, clonedCollector);
        result.name = this.name;
        result.isTopLevel = this.isTopLevel;
        result.targetNamespace = this.targetNamespace;
        result.qualifiedKey = this.qualifiedKey;
        return result;
    }

    public String getQualifiedKey() {
        return this.qualifiedKey;
    }

    public boolean isTopLevel() {
        return this.isTopLevel;
    }
}

