/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.NotationDeclaration;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.SchemaStructuresFactory;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.QualifiedBaseImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class NotationDeclarationImpl
extends QualifiedBaseImpl
implements NotationDeclaration {
    protected String systemIdentifier;
    protected String publicIdentifier;

    public NotationDeclarationImpl() {
        this(null, null);
    }

    public NotationDeclarationImpl(Node associatedNode, BaseInfo baseInfo) {
        super(associatedNode, baseInfo);
    }

    public String getSystemIdentifier() {
        return this.systemIdentifier;
    }

    public String getPublicIdentifier() {
        return this.publicIdentifier;
    }

    public int getTypeOfComponent() {
        return 14;
    }

    public boolean match(Base notationDeclr) {
        if (!super.match(notationDeclr)) {
            return false;
        }
        NotationDeclarationImpl targetNotaionDeclr = (NotationDeclarationImpl)notationDeclr;
        return Tools.compareStringProps(this.systemIdentifier, targetNotaionDeclr.systemIdentifier) && Tools.compareStringProps(this.publicIdentifier, targetNotaionDeclr.publicIdentifier);
    }

    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.id = this.loadAttribsCollector.getProperty("id");
            this.publicIdentifier = this.loadAttribsCollector.getProperty("public");
            this.systemIdentifier = this.loadAttribsCollector.getProperty("system");
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeLocalName;
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema") && (nodeLocalName = node.getLocalName()).equals("annotation")) {
                    this.annotation = SchemaStructuresFactory.createAnnotation(node, this.baseInfo);
                    SchemaStructuresFactory.loadBase(this.annotation);
                }
                ++i;
            }
        }
    }

    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        NotationDeclarationImpl result = (NotationDeclarationImpl)super.initializeBase(base, clonedCollector);
        result.systemIdentifier = this.systemIdentifier;
        result.publicIdentifier = this.publicIdentifier;
        return result;
    }
}

