/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.Annotation;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.structures.AnnotationImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class BaseImpl
implements Base {
    protected boolean isBuiltIn;
    protected Node associatedNode;
    protected AnnotationImpl annotation;
    protected String id;
    protected boolean isLoaded;
    protected boolean isLoading;
    protected BaseInfo baseInfo;
    protected Properties loadAttribsCollector;

    public BaseImpl() {
        this(null, null);
    }

    public BaseImpl(Node associatedNode, BaseInfo baseInfo) {
        this.associatedNode = associatedNode;
        this.baseInfo = baseInfo;
        this.loadAttribsCollector = new Properties();
        if (associatedNode != null) {
            NamedNodeMap namedNodeMap = associatedNode.getAttributes();
            int i = 0;
            while (i < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String attribUri = attr.getNamespaceURI();
                if (attribUri == null || attribUri.equals("")) {
                    ((Hashtable)this.loadAttribsCollector).put(attr.getLocalName(), attr.getValue());
                }
                ++i;
            }
        } else {
            this.isLoaded = true;
        }
    }

    public final String getNameOfComponent() {
        return Constants.NAMES_OF_COMPONENTS[this.getTypeOfComponent()];
    }

    public final Schema getOwnerSchema() {
        return this.baseInfo.getSchema();
    }

    public final Node getAssociatedDOMNode() {
        return this.associatedNode;
    }

    public final boolean isBuiltIn() {
        return this.isBuiltIn;
    }

    public final Annotation getAnnotation() {
        return this.annotation;
    }

    public String getId() {
        return this.id;
    }

    public boolean match(Base base) {
        BaseImpl targetBase = (BaseImpl)base;
        if (this.annotation == null ^ targetBase.annotation == null) {
            return false;
        }
        if (this.annotation != null) {
            return this.annotation.match(targetBase.annotation);
        }
        return true;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void setLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }

    public void destroy() {
        this.loadAttribsCollector = null;
    }

    public void load() throws SchemaComponentException {
    }

    public BaseImpl clone(Hashtable clonedCollector) {
        BaseImpl result;
        BaseImpl baseImpl = result = clonedCollector == null ? null : (BaseImpl)clonedCollector.get(this);
        if (result == null) {
            try {
                result = this.initializeBase((BaseImpl)this.getClass().newInstance(), clonedCollector);
                clonedCollector.put(this, result);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return result;
    }

    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        base.isBuiltIn = this.isBuiltIn;
        base.baseInfo = this.baseInfo;
        base.associatedNode = this.associatedNode;
        base.annotation = this.annotation;
        base.id = this.id;
        base.isLoaded = this.isLoaded;
        base.isLoading = this.isLoading;
        return base;
    }

    public BaseInfo getBaseinfo() {
        return this.baseInfo;
    }

    public abstract int getTypeOfComponent();
}

