/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.AttributeDeclaration;
import com.sap.engine.lib.schema.components.AttributeUse;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.FundamentalFacets;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.SchemaStructuresFactory;
import com.sap.engine.lib.schema.components.impl.ffacets.ValueComparator;
import com.sap.engine.lib.schema.components.impl.structures.AttributeDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SimpleTypeDefinitionImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import org.w3c.dom.Node;

public final class AttributeUseImpl
extends BaseImpl
implements AttributeUse {
    protected boolean isRequired;
    protected boolean isProhibited;
    protected AttributeDeclarationImpl attribDeclr;
    protected String valueConstrDefault;
    protected String valueConstrFixed;

    public AttributeUseImpl() {
        this(null, null);
    }

    public AttributeUseImpl(Node associatedNode, BaseInfo baseInfo) {
        super(associatedNode, baseInfo);
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isProhibited() {
        return this.isProhibited;
    }

    public AttributeDeclaration getAttributeDeclaration() {
        return this.attribDeclr;
    }

    public String getValueConstraintDefault() {
        return this.valueConstrDefault;
    }

    public String getValueConstraintFixed() {
        return this.valueConstrFixed;
    }

    public int getTypeOfComponent() {
        return 6;
    }

    public boolean match(Base attribUse) {
        if (!super.match(attribUse)) {
            return false;
        }
        AttributeUseImpl attribUseTarget = (AttributeUseImpl)attribUse;
        return this.isRequired == attribUseTarget.isRequired && this.isProhibited == attribUseTarget.isProhibited && this.attribDeclr.match(attribUseTarget.attribDeclr) && this.equalValueConstraints(attribUseTarget);
    }

    private boolean equalValueConstraints(AttributeUseImpl attribUse) {
        return Tools.compareStringProps(this.valueConstrDefault, attribUse.valueConstrDefault) && Tools.compareStringProps(this.valueConstrFixed, attribUse.valueConstrFixed);
    }

    public void load() throws SchemaComponentException {
        FundamentalFacets ffacets;
        this.valueConstrDefault = this.loadAttribsCollector.getProperty("default");
        this.valueConstrFixed = this.loadAttribsCollector.getProperty("fixed");
        if (this.valueConstrDefault != null && this.valueConstrFixed != null) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of attribute use " + DOM.toXPath(this.associatedNode) + " is not correct. 'Default' and 'fixed' must not both be present.");
        }
        String value = this.loadAttribsCollector.getProperty("use");
        if (value != null) {
            if (value.equals("prohibited")) {
                this.isProhibited = true;
            } else if (value.equals("required")) {
                this.isRequired = true;
            }
        }
        this.attribDeclr = SchemaStructuresFactory.createAttributeDeclaration(this.associatedNode, this.baseInfo);
        SchemaStructuresFactory.loadBase(this.attribDeclr);
        String attrValueConstrFixed = this.attribDeclr.fixedValue;
        if (this.valueConstrFixed != null && attrValueConstrFixed != null && ValueComparator.compare((ffacets = ((SimpleTypeDefinitionImpl)this.attribDeclr.typeDefinition).fundamentalFacets).parse(attrValueConstrFixed), ffacets.parse(this.valueConstrFixed)) != 1) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : If the {attribute declaration} has a fixed {value constraint}, then if the attribute use itself has a {value constraint}, it must also be fixed and its value must match that of the {attribute declaration}'s {value constraint}.");
        }
    }

    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        AttributeUseImpl result = (AttributeUseImpl)super.initializeBase(new AttributeUseImpl(), clonedCollector);
        result.isRequired = this.isRequired;
        result.isProhibited = this.isProhibited;
        result.attribDeclr = (AttributeDeclarationImpl)this.attribDeclr.clone(clonedCollector);
        result.valueConstrDefault = this.valueConstrDefault;
        result.valueConstrFixed = this.valueConstrFixed;
        return result;
    }
}

