/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl;

import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.LoaderImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeGroupDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.ComplexTypeDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.ElementDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.ModelGroupDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.NotationDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.QualifiedBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.SimpleTypeDefinitionImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaInfo
implements Constants {
    private Hashtable typeDefinitionsCollector;
    private Hashtable attributeDeclarationsCollector;
    private Hashtable elementDeclarationsCollector;
    private Hashtable attributeGroupDefinitionsCollector;
    private Hashtable modelGroupDefinitionsCollector;
    private Hashtable notationDeclarationsCollector;
    private Element schemaElement;
    private boolean collect;
    private BaseInfo baseInfo;
    private boolean isResolved;
    private String location;

    public SchemaInfo(Element schemaElement, SchemaImpl schema, LoaderImpl loader, String canonicalizedLocation, String location, boolean collect) {
        this.schemaElement = schemaElement;
        this.baseInfo = new BaseInfo();
        this.baseInfo.setSchema(schema);
        this.baseInfo.setLoader(loader);
        this.baseInfo.setLocation(canonicalizedLocation);
        this.typeDefinitionsCollector = new Hashtable();
        this.attributeDeclarationsCollector = new Hashtable();
        this.elementDeclarationsCollector = new Hashtable();
        this.attributeGroupDefinitionsCollector = new Hashtable();
        this.modelGroupDefinitionsCollector = new Hashtable();
        this.notationDeclarationsCollector = new Hashtable();
        this.collect = collect;
        this.location = location;
        this.baseInfo.setTargetNamespace("");
        NamedNodeMap namedNodeMap = schemaElement.getAttributes();
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            Node attrib = namedNodeMap.item(i);
            String attribUri = attrib.getNamespaceURI();
            String localName = attrib.getLocalName();
            String attribValue = attrib.getNodeValue();
            if (attribUri == null || attribUri.equals("")) {
                StringTokenizer tokenizer;
                if (localName.equals("attributeFormDefault")) {
                    this.baseInfo.setAttribsFormDefault(attribValue.equals("qualified"));
                } else if (localName.equals("elementFormDefault")) {
                    this.baseInfo.setElemsFormDefault(attribValue.equals("qualified"));
                } else if (localName.equals("targetNamespace")) {
                    this.baseInfo.setTargetNamespace(attribValue == null ? "" : attribValue);
                } else if (localName.equals("blockDefault")) {
                    if (attribValue.equals("#all")) {
                        this.baseInfo.setProhibitedSubstitution(true);
                        this.baseInfo.setProhibitedExtension(true);
                        this.baseInfo.setProhibitedRestriction(true);
                        this.baseInfo.setProhibitedList(true);
                        this.baseInfo.setProhibitedUnion(true);
                    } else {
                        tokenizer = new StringTokenizer(attribValue);
                        while (tokenizer.hasMoreTokens()) {
                            attribValue = tokenizer.nextToken();
                            if (attribValue.equals("substitution")) {
                                this.baseInfo.setProhibitedSubstitution(true);
                                continue;
                            }
                            if (attribValue.equals("extension")) {
                                this.baseInfo.setProhibitedExtension(true);
                                continue;
                            }
                            if (attribValue.equals("restriction")) {
                                this.baseInfo.setProhibitedRestriction(true);
                                continue;
                            }
                            if (attribValue.equals("list")) {
                                this.baseInfo.setProhibitedList(true);
                                continue;
                            }
                            if (!attribValue.equals("union")) continue;
                            this.baseInfo.setProhibitedUnion(true);
                        }
                    }
                } else if (localName.equals("finalDefault")) {
                    if (attribValue.equals("#all")) {
                        this.baseInfo.setFinalExtension(true);
                        this.baseInfo.setFinalRestriction(true);
                    } else {
                        tokenizer = new StringTokenizer(attribValue);
                        while (tokenizer.hasMoreTokens()) {
                            attribValue = tokenizer.nextToken();
                            if (attribValue.equals("extension")) {
                                this.baseInfo.setFinalExtension(true);
                                continue;
                            }
                            if (!attribValue.equals("restriction")) continue;
                            this.baseInfo.setFinalRestriction(true);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void resolve() throws SchemaComponentException {
        NodeList nodeList = this.schemaElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                String nodeUri = node.getNamespaceURI();
                String nodeLocalName = node.getLocalName();
                if (nodeUri != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    Attr locationAttrib;
                    if (nodeLocalName.equals("import")) {
                        Element importElement = (Element)node;
                        Attr targetNsAttrib = importElement.getAttributeNode("namespace");
                        String importedNamespace = targetNsAttrib == null ? null : targetNsAttrib.getValue();
                        Attr locationAttrib2 = importElement.getAttributeNode("schemaLocation");
                        if (locationAttrib2 != null) {
                            String importedLocation = locationAttrib2.getValue();
                            this.baseInfo.getLoader().importSchemaInfo(this.location, importedLocation, importedNamespace);
                        }
                    } else if (nodeLocalName.equals("include")) {
                        Element includeElement = (Element)node;
                        locationAttrib = includeElement.getAttributeNode("schemaLocation");
                        String includedLocation = locationAttrib == null ? null : locationAttrib.getValue();
                        this.baseInfo.getLoader().includeSchemaInfo(this.location, includedLocation, this.baseInfo.getTargetNamespace());
                    } else if (nodeLocalName.equals("redefine")) {
                        Element redefineElement = (Element)node;
                        locationAttrib = redefineElement.getAttributeNode("schemaLocation");
                        String redefinedLocation = locationAttrib == null ? null : locationAttrib.getValue();
                        this.baseInfo.getLoader().redefineSchemaInfo(this.location, redefinedLocation, this.baseInfo.getTargetNamespace());
                    } else if (nodeLocalName.equals("simpleType")) {
                        this.addComponent(new SimpleTypeDefinitionImpl(node, this.baseInfo, true), this.typeDefinitionsCollector, this.baseInfo.getSchema());
                    } else if (nodeLocalName.equals("complexType")) {
                        this.addComponent(new ComplexTypeDefinitionImpl(node, this.baseInfo, true), this.typeDefinitionsCollector, this.baseInfo.getSchema());
                    } else if (nodeLocalName.equals("group")) {
                        this.addComponent(new ModelGroupDefinitionImpl(node, this.baseInfo, true), this.modelGroupDefinitionsCollector, this.baseInfo.getSchema());
                    } else if (nodeLocalName.equals("attributeGroup")) {
                        this.addComponent(new AttributeGroupDefinitionImpl(node, this.baseInfo, true), this.attributeGroupDefinitionsCollector, this.baseInfo.getSchema());
                    } else if (nodeLocalName.equals("element")) {
                        this.addComponent(new ElementDeclarationImpl(node, this.baseInfo, true), this.elementDeclarationsCollector, this.baseInfo.getSchema());
                    } else if (nodeLocalName.equals("attribute")) {
                        this.addComponent(new AttributeDeclarationImpl(node, this.baseInfo, true), this.attributeDeclarationsCollector, this.baseInfo.getSchema());
                    } else if (nodeLocalName.equals("notation")) {
                        this.addComponent(new NotationDeclarationImpl(node, this.baseInfo), this.notationDeclarationsCollector, this.baseInfo.getSchema());
                    }
                }
            }
            ++i;
        }
        this.isResolved = true;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    private void addComponent(QualifiedBaseImpl qualifiedBase, Hashtable collector, SchemaImpl schema) throws SchemaComponentException {
        String key = qualifiedBase.getQualifiedKey();
        if (collector.containsKey(key)) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of top level element " + DOM.toXPath(qualifiedBase.getAssociatedDOMNode()) + " is not correct. Top level element with uri - " + qualifiedBase.getTargetNamespace() + " and name - " + qualifiedBase.getName() + " already is defined.");
        }
        if (this.collect) {
            collector.put(key, qualifiedBase);
        } else {
            collector.put(key, "");
            schema.addTopLevelComponent(qualifiedBase);
        }
    }

    public void transfer(String uri, String name, int type) {
        String key = Tools.generateKey(uri, name);
        QualifiedBaseImpl transferedQualifiedBase = null;
        switch (type) {
            case 4: {
                transferedQualifiedBase = (QualifiedBaseImpl)this.attributeDeclarationsCollector.get(key);
                break;
            }
            case 5: {
                transferedQualifiedBase = (QualifiedBaseImpl)this.attributeGroupDefinitionsCollector.get(key);
                break;
            }
            case 3: {
                transferedQualifiedBase = (QualifiedBaseImpl)this.elementDeclarationsCollector.get(key);
                break;
            }
            case 8: {
                transferedQualifiedBase = (QualifiedBaseImpl)this.modelGroupDefinitionsCollector.get(key);
                break;
            }
            case 14: {
                transferedQualifiedBase = (QualifiedBaseImpl)this.notationDeclarationsCollector.get(key);
                break;
            }
            case 16: {
                transferedQualifiedBase = (QualifiedBaseImpl)this.typeDefinitionsCollector.get(key);
                break;
            }
            case 1: {
                transferedQualifiedBase = (QualifiedBaseImpl)this.typeDefinitionsCollector.get(key);
                break;
            }
            case 2: {
                transferedQualifiedBase = (QualifiedBaseImpl)this.typeDefinitionsCollector.get(key);
            }
        }
        if (transferedQualifiedBase != null) {
            this.baseInfo.getSchema().addTopLevelComponent(transferedQualifiedBase);
        }
    }

    public BaseInfo getBaseInfo() {
        return this.baseInfo;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.baseInfo.setTargetNamespace(targetNamespace);
    }

    public String getLocation() {
        return this.location;
    }
}

