/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.canonicalizator;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.canonicalizator.CanonicalizationProcessor;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.impl.LoaderImpl;
import com.sap.engine.lib.schema.exception.CanonicalizationException;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.exception.SchemaException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.schema.validator.Validator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class Canonicalizator
implements Constants {
    private DocumentBuilder docBuilder;
    private LoaderImpl loader;
    private Validator validator;
    private boolean useExternalSchema;
    private EntityResolver resolver;

    public Canonicalizator() throws CanonicalizationException {
        try {
            this.useExternalSchema = true;
            DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
            factory.setNamespaceAware(true);
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            this.docBuilder = factory.newDocumentBuilder();
            this.loader = new LoaderImpl();
            this.validator = new Validator();
            this.validator.setCanonicalizationProcessing(true);
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage());
        }
    }

    public void setSchema(Schema schema) {
        this.validator.setExternalSchema(schema);
    }

    public void setSchema(String schemaLocation) throws SchemaComponentException {
        this.validator.setExternalSchema(this.loader.load(schemaLocation));
    }

    public void setSchema(String[] schemaLocations) throws SchemaComponentException {
        this.validator.setExternalSchema(this.loader.load(schemaLocations));
    }

    public void setSchema(Node schemaNode) throws SchemaComponentException {
        this.validator.setExternalSchema(this.loader.load(schemaNode));
    }

    public void setSchema(Node[] schemaNodes) throws SchemaComponentException {
        this.validator.setExternalSchema(this.loader.load(schemaNodes));
    }

    public void setSchema(StreamSource schemaSource) throws SchemaComponentException {
        this.validator.setExternalSchema(this.loader.load(schemaSource));
    }

    public void setSchema(StreamSource[] schemaSources) throws SchemaComponentException {
        this.validator.setExternalSchema(this.loader.load(schemaSources));
    }

    public void setSchema(InputStream schemaInput) throws SchemaComponentException {
        this.validator.setExternalSchema(this.loader.load(schemaInput));
    }

    public void setSchema(InputStream[] schemaInputs) throws SchemaComponentException {
        this.validator.setExternalSchema(this.loader.load(schemaInputs));
    }

    public void setSchema(InputSource schemaInput) throws SchemaComponentException {
        this.validator.setExternalSchema(this.loader.load(schemaInput));
    }

    public void setSchema(InputSource[] schemaInputs) throws SchemaComponentException {
        this.validator.setExternalSchema(this.loader.load(schemaInputs));
    }

    public void setSchema(File schemaFile) throws SchemaComponentException {
        this.validator.setExternalSchema(this.loader.load(schemaFile));
    }

    public void setSchema(File[] schemaFiles) throws SchemaComponentException {
        this.validator.setExternalSchema(this.loader.load(schemaFiles));
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.loader.setEntityResolver(resolver);
        this.validator.setEntityResolver(resolver);
        this.resolver = resolver;
    }

    public void setUseExternalSchema(boolean useExternalSchema) {
        this.useExternalSchema = useExternalSchema;
    }

    public void canonicalize(String inputXmlLocation, String outputXmlFile) throws CanonicalizationException {
        try {
            this.canonicalize(Tools.retrieveNode(this.docBuilder, Tools.retrieveInputSource(this.resolver, null, inputXmlLocation)), outputXmlFile);
        }
        catch (SchemaException schemaExc) {
            throw new CanonicalizationException(schemaExc.getMessage());
        }
    }

    public void canonicalize(String inputXmlLocation, OutputStream xmlOutput) throws CanonicalizationException {
        try {
            this.canonicalize(Tools.retrieveNode(this.docBuilder, Tools.retrieveInputSource(this.resolver, null, inputXmlLocation)), xmlOutput);
        }
        catch (SchemaException schemaExc) {
            throw new CanonicalizationException(schemaExc.getMessage());
        }
    }

    public void canonicalize(String inputXmlLocation, Writer xmlWriter) throws CanonicalizationException {
        try {
            this.canonicalize(Tools.retrieveNode(this.docBuilder, Tools.retrieveInputSource(this.resolver, null, inputXmlLocation)), xmlWriter);
        }
        catch (SchemaException schemaExc) {
            throw new CanonicalizationException(schemaExc.getMessage());
        }
    }

    public void canonicalize(Node inputXmlNode, String outputXmlFile) throws CanonicalizationException {
        this.canonicalize(Tools.retrieveDocElement(inputXmlNode), outputXmlFile);
    }

    public void canonicalize(Node inputXmlNode, OutputStream xmlOutput) throws CanonicalizationException {
        this.canonicalize(Tools.retrieveDocElement(inputXmlNode), xmlOutput);
    }

    public void canonicalize(Node inputXmlNode, Writer xmlWriter) throws CanonicalizationException {
        this.canonicalize(Tools.retrieveDocElement(inputXmlNode), xmlWriter);
    }

    private void canonicalize(Element inputXmlElement, String xmlOutputFile) throws CanonicalizationException {
        this.validate(inputXmlElement);
        FileOutputStream xmlOutput = null;
        try {
            xmlOutput = new FileOutputStream(xmlOutputFile);
        }
        catch (FileNotFoundException fNFExc) {
            throw new CanonicalizationException(xmlOutputFile);
        }
        CanonicalizationProcessor processor = new CanonicalizationProcessor(inputXmlElement, xmlOutput);
        processor.process();
    }

    private void canonicalize(Element inputXmlElement, OutputStream xmlOutput) throws CanonicalizationException {
        this.validate(inputXmlElement);
        CanonicalizationProcessor processor = new CanonicalizationProcessor(inputXmlElement, xmlOutput);
        processor.process();
    }

    private void canonicalize(Element inputXmlElement, Writer xmlWriter) throws CanonicalizationException {
        this.validate(inputXmlElement);
        CanonicalizationProcessor processor = new CanonicalizationProcessor(inputXmlElement, xmlWriter);
        processor.process();
    }

    private void validate(Element inputXmlElement) throws CanonicalizationException {
        if (!this.useExternalSchema || this.validator.getExternalSchema() == null) {
            String schemaLocationAttr = inputXmlElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            if (schemaLocationAttr != null) {
                StringTokenizer tokenizer = new StringTokenizer(schemaLocationAttr);
                if (tokenizer.countTokens() % 2 != 0) {
                    throw new CanonicalizationException("The value of attribute {http://www.w3.org/2001/XMLSchema-instance}:schemaLocation is not correct. It has to contain taget namespaces associated with schema locations.");
                }
                int length = tokenizer.countTokens() / 2;
                String[] targetNamespaces = new String[length];
                String[] schemaLocations = new String[length];
                int index = 0;
                while (tokenizer.hasMoreTokens()) {
                    targetNamespaces[index] = tokenizer.nextToken();
                    schemaLocations[index++] = tokenizer.nextToken();
                }
                try {
                    this.validator.setExternalSchema(this.loader.load(targetNamespaces, schemaLocations));
                }
                catch (SchemaComponentException schemaCompExc) {
                    throw new CanonicalizationException(schemaCompExc.getMessage());
                }
            }
            String noNamespaceSchemaLocation = inputXmlElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
            if (noNamespaceSchemaLocation == null) {
                throw new CanonicalizationException("An external schema has to be set.");
            }
            try {
                this.validator.setExternalSchema(this.loader.load(noNamespaceSchemaLocation));
            }
            catch (SchemaComponentException schemaCompExc) {
                throw new CanonicalizationException(schemaCompExc.getMessage());
            }
        }
        try {
            if (!this.validator.validate(inputXmlElement)) {
                throw new CanonicalizationException(this.validator.getErrorsRepresentation());
            }
        }
        catch (SchemaException schemaExc) {
            throw new CanonicalizationException(schemaExc.getMessage());
        }
    }

    public void canonicalize(StreamSource inputXmlSource, String outputXmlFile) throws CanonicalizationException {
        try {
            this.canonicalize(Tools.retrieveNode(this.docBuilder, Tools.createInputSource(inputXmlSource)), outputXmlFile);
        }
        catch (SchemaException schemaExc) {
            throw new CanonicalizationException(schemaExc.getMessage());
        }
    }

    public void canonicalize(StreamSource inputXmlSource, OutputStream xmlOutput) throws CanonicalizationException {
        try {
            this.canonicalize(Tools.retrieveNode(this.docBuilder, Tools.createInputSource(inputXmlSource)), xmlOutput);
        }
        catch (SchemaException schemaExc) {
            throw new CanonicalizationException(schemaExc.getMessage());
        }
    }

    public void canonicalize(StreamSource inputXmlSource, Writer xmlWriter) throws CanonicalizationException {
        try {
            this.canonicalize(Tools.retrieveNode(this.docBuilder, Tools.createInputSource(inputXmlSource)), xmlWriter);
        }
        catch (SchemaException schemaExc) {
            throw new CanonicalizationException(schemaExc.getMessage());
        }
    }

    public void canonicalize(InputStream inputXmlInput, String outputXmlFile) throws CanonicalizationException {
        try {
            this.canonicalize(Tools.retrieveNode(this.docBuilder, new InputSource(inputXmlInput)), outputXmlFile);
        }
        catch (SchemaException schemaExc) {
            throw new CanonicalizationException(schemaExc.getMessage());
        }
    }

    public void canonicalize(InputStream inputXmlInput, OutputStream xmlOutput) throws CanonicalizationException {
        try {
            this.canonicalize(Tools.retrieveNode(this.docBuilder, new InputSource(inputXmlInput)), xmlOutput);
        }
        catch (SchemaException schemaExc) {
            throw new CanonicalizationException(schemaExc.getMessage());
        }
    }

    public void canonicalize(InputStream inputXmlInput, Writer xmlWriter) throws CanonicalizationException {
        try {
            this.canonicalize(Tools.retrieveNode(this.docBuilder, new InputSource(inputXmlInput)), xmlWriter);
        }
        catch (SchemaException schemaExc) {
            throw new CanonicalizationException(schemaExc.getMessage());
        }
    }

    public void canonicalize(InputSource inputXmlSource, String outputXmlFile) throws CanonicalizationException {
        try {
            this.canonicalize(Tools.retrieveNode(this.docBuilder, inputXmlSource), outputXmlFile);
        }
        catch (SchemaException schemaExc) {
            throw new CanonicalizationException(schemaExc.getMessage());
        }
    }

    public void canonicalize(InputSource inputXmlSource, OutputStream xmlOutput) throws CanonicalizationException {
        try {
            this.canonicalize(Tools.retrieveNode(this.docBuilder, inputXmlSource), xmlOutput);
        }
        catch (SchemaException schemaExc) {
            throw new CanonicalizationException(schemaExc.getMessage());
        }
    }

    public void canonicalize(InputSource inputXmlSource, Writer xmlWriter) throws CanonicalizationException {
        try {
            this.canonicalize(Tools.retrieveNode(this.docBuilder, inputXmlSource), xmlWriter);
        }
        catch (SchemaException schemaExc) {
            throw new CanonicalizationException(schemaExc.getMessage());
        }
    }
}

