/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.jaxp;

import com.sap.engine.lib.jaxp.InstanceManager;
import com.sap.engine.lib.jaxp.ParserAttributes;
import com.sap.engine.lib.jaxp.TransformerImpl;
import com.sap.engine.lib.xml.parser.DOMParser;
import com.sap.engine.lib.xml.parser.SAXParser;
import com.sap.engine.lib.xml.util.SAXToDOMHandler;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLOutputNode;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class TemplatesImpl
implements Templates {
    static ResourceBundle res = ResourceBundle.getBundle("com.sap.engine.lib.jaxp.Res", new Locale("", ""));
    private XSLStylesheet sheet;
    private Properties outputProperties;
    private Properties explProperties;
    private Properties templProperties;
    private DOMSource stylesheetDomSource;
    private URIResolver stylesheetUriResolver;
    private ClassLoader extensionClassLoader;
    private Stack tStack;
    private TransformerImpl cachedTransformer;
    private boolean bTransformerReuse;
    private EntityResolver entityResolver;
    private ParserAttributes attributes;

    protected void setExtensionClassLoader(ClassLoader extensionClassLoader) {
        this.extensionClassLoader = extensionClassLoader;
    }

    protected TemplatesImpl(Source source, URIResolver uriResolver, EntityResolver entityResolver, ParserAttributes attributes) throws TransformerConfigurationException {
        block23: {
            this.outputProperties = new Properties(TransformerImpl.DEFAULT_OUTPUT_PROPERTIES);
            this.explProperties = new Properties();
            this.templProperties = new Properties();
            this.stylesheetDomSource = null;
            this.stylesheetUriResolver = null;
            this.extensionClassLoader = null;
            this.tStack = null;
            this.cachedTransformer = null;
            this.bTransformerReuse = false;
            if (source == null) {
                throw new IllegalArgumentException(res.getString("XSL_Source_is_null_"));
            }
            try {
                this.stylesheetUriResolver = uriResolver;
                this.entityResolver = entityResolver;
                this.attributes = attributes;
                if (source instanceof DOMSource) {
                    this.stylesheetDomSource = new DOMSource(((DOMSource)source).getNode(), source.getSystemId());
                    break block23;
                }
                if (source instanceof SAXSource) {
                    InputSource inputSource;
                    SAXSource s = (SAXSource)source;
                    XMLReader xmlReader = s.getXMLReader();
                    if (xmlReader == null) {
                        xmlReader = new SAXParser();
                    }
                    if ((inputSource = s.getInputSource()) == null) {
                        throw new TransformerException(res.getString("SAXSource_whose"));
                    }
                    SAXToDOMHandler handler = new SAXToDOMHandler();
                    xmlReader.setContentHandler(handler);
                    xmlReader.setDTDHandler(handler);
                    xmlReader.setEntityResolver(handler);
                    xmlReader.setErrorHandler(handler);
                    xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
                    xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                    xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
                    xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                    xmlReader.parse(inputSource);
                    this.stylesheetDomSource = new DOMSource(handler.getRoot(), s.getSystemId());
                    break block23;
                }
                if (source instanceof StreamSource) {
                    InputSource inputSource;
                    InputStream inputStream = ((StreamSource)source).getInputStream();
                    Reader reader = ((StreamSource)source).getReader();
                    String id = ((StreamSource)source).getSystemId();
                    boolean hasId = false;
                    if (inputStream != null) {
                        inputSource = new InputSource(inputStream);
                    } else if (reader != null) {
                        inputSource = new InputSource(reader);
                    } else if (id != null) {
                        inputSource = new InputSource(id);
                        hasId = true;
                    } else {
                        throw new TransformerException(res.getString("StreamSource_whose"));
                    }
                    DOMParser domParser = new DOMParser();
                    domParser.setFeature("http://inqmy.org/dom/features/trim-white-spaces", false);
                    domParser.setFeature("http://xml.org/sax/features/namespaces", true);
                    domParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                    domParser.setAttributes(attributes);
                    domParser.setEntityResolver(entityResolver);
                    Document document = domParser.parse(inputSource);
                    this.stylesheetDomSource = new DOMSource(document, source.getSystemId());
                    break block23;
                }
                throw new TransformerException(res.getString("Only_output_to"));
            }
            catch (XSLException e) {
                throw new TransformerConfigurationException("Could not load stylesheet. " + e, e);
            }
            catch (Exception e) {
                throw new TransformerConfigurationException("Could not load stylesheet. " + e, e);
            }
        }
        if (this.stylesheetDomSource != null && this.sheet == null) {
            NodeList nl = ((Document)this.stylesheetDomSource.getNode()).getElementsByTagNameNS("http://www.w3.org/1999/XSL/Transform", "output");
            String localName = ((Document)this.stylesheetDomSource.getNode()).getDocumentElement().getLocalName();
            if (nl.getLength() > 0) {
                String methodValue = ((Element)nl.item(0)).getAttribute("method");
                if (methodValue.equals("html")) {
                    this.setNonNullOutputProperty(this.explProperties, "media-type", "text/html");
                    this.setNonNullOutputProperty(this.explProperties, "version", "4.0");
                    this.setNonNullOutputProperty(this.explProperties, "indent", "yes");
                } else if (methodValue.equals("text")) {
                    this.setNonNullOutputProperty(this.explProperties, "media-type", "text/plain");
                }
                if (!"".equals(((Element)nl.item(0)).getAttribute("method"))) {
                    this.setNonNullOutputProperty(this.explProperties, "method", ((Element)nl.item(0)).getAttribute("method"));
                }
            } else if (localName.equalsIgnoreCase("html")) {
                this.setNonNullOutputProperty(this.explProperties, "method", "html");
                this.setNonNullOutputProperty(this.explProperties, "media-type", "text/html");
                this.setNonNullOutputProperty(this.explProperties, "version", "4.0");
                this.setNonNullOutputProperty(this.explProperties, "indent", "yes");
            }
        }
        this.outputProperties = this.mergeProperties();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Transformer newTransformer() throws TransformerConfigurationException {
        TransformerImpl transformerImpl;
        block8: {
            TransformerImpl transformerImpl2;
            block7: {
                try {
                    try {
                        if (this.bTransformerReuse && !this.tStack.empty()) {
                            Transformer transformer = (Transformer)this.tStack.pop();
                            Object var3_5 = null;
                            this.sheet = null;
                            return transformer;
                        }
                        this.sheet = InstanceManager.getXSLStylesheet();
                        this.sheet.setExtClassLoader(this.extensionClassLoader);
                        this.sheet.init(this.stylesheetDomSource, this.stylesheetUriResolver, 0);
                        this.setStylesheetOutputProperties(this.sheet.getOutputProperties());
                        this.outputProperties = this.mergeProperties();
                        if (!this.sheet.isIndentAllowed()) {
                            this.outputProperties.setProperty("indent", "no");
                        }
                        if (this.bTransformerReuse) {
                            this.cachedTransformer = new TransformerImpl(this.sheet, this.getOutputProperties(), this.stylesheetUriResolver, this.entityResolver, this.attributes);
                            this.cachedTransformer.setPool(this.tStack);
                            transformerImpl2 = this.cachedTransformer;
                            break block7;
                        }
                        transformerImpl = new TransformerImpl(this.sheet, this.getOutputProperties(), this.stylesheetUriResolver, this.entityResolver, this.attributes);
                        break block8;
                    }
                    catch (XSLException e) {
                        throw new TransformerConfigurationException("Could not load stylesheet." + e, e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_8 = null;
                    this.sheet = null;
                    throw throwable;
                }
            }
            Object var3_6 = null;
            this.sheet = null;
            return transformerImpl2;
        }
        Object var3_7 = null;
        this.sheet = null;
        return transformerImpl;
    }

    public synchronized Properties getOutputProperties() {
        return (Properties)((Hashtable)this.outputProperties).clone();
    }

    private void setStylesheetOutputProperties(XSLOutputNode o) {
        ((Hashtable)this.outputProperties).clear();
        if (o == null) {
            return;
        }
        this.setNonNullOutputProperty(this.templProperties, "cdata-section-elements", o.getCdataSectionElements());
        this.setNonNullOutputProperty(this.templProperties, "doctype-public", o.getDoctypePublic());
        this.setNonNullOutputProperty(this.templProperties, "doctype-system", o.getDoctypeSystem());
        this.setNonNullOutputProperty(this.templProperties, "encoding", o.getEncoding());
        this.setNonNullOutputProperty(this.templProperties, "indent", o.getIndent());
        this.setNonNullOutputProperty(this.templProperties, "media-type", o.getMediaType());
        this.setNonNullOutputProperty(this.templProperties, "method", o.getMethod());
        this.setNonNullOutputProperty(this.templProperties, "omit-xml-declaration", o.getOmitXmlDeclaration());
        this.setNonNullOutputProperty(this.templProperties, "standalone", o.getStandalone());
        this.setNonNullOutputProperty(this.templProperties, "version", o.getVersion());
        this.outputProperties = this.mergeProperties();
        if (((Hashtable)this.outputProperties).get("method").equals("html")) {
            this.explProperties.setProperty("media-type", "text/html");
            this.explProperties.setProperty("version", "4.0");
            this.explProperties.setProperty("indent", "yes");
        } else if (((Hashtable)this.outputProperties).get("method").equals("text")) {
            this.explProperties.setProperty("media-type", "text/plain");
        } else if (((Hashtable)this.outputProperties).get("method").equals("xml")) {
            this.explProperties.setProperty("media-type", "text/xml");
        }
        this.outputProperties = this.mergeProperties();
    }

    private void setNonNullOutputProperty(Properties p, String key, String value) {
        if (value != null && value.length() > 0) {
            p.setProperty(key, value);
        }
    }

    public void setTransformerReuse(boolean value) {
        this.bTransformerReuse = value;
        value = this.tStack == null;
        if (value) {
            this.tStack = new Stack();
        }
    }

    private Properties mergeProperties() {
        Object next;
        Properties p = (Properties)((Hashtable)TransformerImpl.DEFAULT_OUTPUT_PROPERTIES).clone();
        Enumeration e = ((Hashtable)this.templProperties).keys();
        while (e.hasMoreElements()) {
            next = e.nextElement();
            p.setProperty((String)next, this.templProperties.getProperty((String)next));
        }
        e = ((Hashtable)this.explProperties).keys();
        while (e.hasMoreElements()) {
            next = e.nextElement();
            ((Hashtable)p).put((String)next, this.explProperties.getProperty((String)next));
        }
        return p;
    }

    public void setAttribute(String key, Object value) throws Exception {
        this.attributes.set(key, value);
    }

    public Object getAttribute(String key, boolean value) throws Exception {
        return this.attributes.get(key);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }
}

