/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.jaxp;

import com.sap.engine.lib.xml.parser.Features;
import com.sap.engine.lib.xml.parser.JAXPProperties;
import java.util.Vector;

public class ParserAttributes {
    private Vector attributeNames = new Vector();
    private Vector attributeValues = new Vector();

    protected ParserAttributes() {
    }

    public void set(String name, Object value) {
        this.expectAttributeName(name);
        if (this.attributeNames.size() == 0) {
            this.attributeNames.add(name);
            this.attributeValues.add(value);
        }
        int index = 0;
        while (!this.attributeNames.get(index).equals(name) && ++index < this.attributeNames.size()) {
        }
        if (index >= this.attributeNames.size()) {
            this.attributeNames.add(name);
            this.attributeValues.add(value);
        } else {
            this.attributeValues.set(index, value);
        }
    }

    private void expectAttributeName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null.");
        }
        if (!Features.SUPPORTED.contains(name) && !JAXPProperties.SUPPORTED.contains(name)) {
            throw new IllegalArgumentException("Attribute '" + name + "' is not supported");
        }
    }

    public Object get(String name) {
        this.expectAttributeName(name);
        if (this.attributeNames.size() == 0) {
            return null;
        }
        int index = 0;
        while (!this.attributeNames.get(index).equals(name) && ++index < this.attributeNames.size()) {
        }
        if (index >= this.attributeNames.size()) {
            return null;
        }
        return this.attributeValues.get(index);
    }

    public Object get(int index) {
        return this.attributeValues.get(index);
    }

    public String getName(int index) {
        return (String)this.attributeNames.get(index);
    }

    public int size() {
        return this.attributeNames.size();
    }

    public static void main(String[] args) throws Exception {
        ParserAttributes attributes = new ParserAttributes();
        System.out.println("value : " + attributes.get("name") + " null expected");
        attributes.set("name1", "value1");
        attributes.set("name2", "value2");
        attributes.set("name3", "value3");
        System.out.println("value : " + attributes.get("name1") + " value1 expected");
        System.out.println("value : " + attributes.get("name2") + " value2 expected");
        System.out.println("value : " + attributes.get("name3") + " value3 expected");
        System.out.println("value : " + attributes.get("name4") + " null expected");
        attributes.set("name2", "value2.1");
        System.out.println("value : " + attributes.get("name2") + " value2.1 expected");
        attributes.set("name2", null);
        System.out.println("value : " + attributes.get("name2") + " null expected");
    }
}

