/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xsl.xslt.output;

import com.inqmy.lib.xml.parser.handlers.EncodingHandler;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import com.inqmy.lib.xml.parser.helpers.Encoding;
import com.inqmy.lib.xsl.xpath.StaticInteger;
import com.inqmy.lib.xsl.xslt.output.DocHandlerSerializer;
import com.inqmy.lib.xsl.xslt.output.OutputException;
import com.inqmy.lib.xsl.xslt.output.OutputIOException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

final class Encoder {
    protected DocHandlerSerializer owner = null;
    protected static final String LINE_SEPARATOR = "\n";
    protected Writer writer = null;
    protected OutputStream stream = null;
    protected static final String CDATA_BEGIN = "<![CDATA[";
    protected static final String CDATA_END = "]]>";
    protected static final String CDATA_END_BEGIN = "]]><![CDATA[";
    protected boolean escapingDisabled = false;
    private char[] ca1 = new char[1];
    private byte[] bufwritebyte = new byte[2000];
    private char[] bufwritechar = new char[2000];
    private byte[] convarr = new byte[10];
    private int bufwriteidx = 0;
    private EncodingHandler encodingHandler = new EncodingHandler();
    private Encoding encoding = this.encodingHandler.getEncoding(new CharArray("utf-8"));
    private CharArray chTempOutRef = new CharArray();

    protected Encoder() {
    }

    private void init() {
        Object writer = null;
        Object var2_2 = null;
    }

    protected void init(Writer writer, String enc) throws OutputException {
        this.init();
        this.bufwriteidx = 0;
        this.setWriter(writer);
        this.encoding = this.encodingHandler.getEncoding(new CharArray(enc));
        if (this.encoding == null) {
            this.encoding = this.encodingHandler.getEncoding(EncodingHandler.UTF8);
        }
    }

    protected void init(OutputStream outputStream, String enc) throws OutputException {
        this.init();
        this.bufwriteidx = 0;
        this.stream = outputStream;
        this.encoding = this.encodingHandler.getEncoding(new CharArray(enc));
        if (this.encoding == null) {
            this.encoding = this.encodingHandler.getEncoding(EncodingHandler.UTF8);
        }
    }

    protected void setWriter(Writer writer) {
        this.writer = writer;
    }

    protected String getEncodingName() {
        return this.encoding.getName().toString();
    }

    private void bufferWrite(int b) throws IOException {
        if (this.bufwriteidx == this.bufwritebyte.length) {
            if (this.stream != null) {
                this.stream.write(this.bufwritebyte);
            } else {
                this.writer.write(this.bufwritechar);
            }
            this.bufwriteidx = 0;
        }
        if (this.stream != null) {
            this.bufwritebyte[this.bufwriteidx++] = (byte)b;
        } else {
            this.bufwritechar[this.bufwriteidx++] = (char)b;
        }
    }

    protected Encoder out(char ch) throws OutputException {
        this.makeDefaultEncodingCheck(ch);
        return this;
    }

    protected Encoder enableOutputEscaping() {
        this.escapingDisabled = false;
        return this;
    }

    protected Encoder disableOutputEscaping() {
        this.escapingDisabled = true;
        return this;
    }

    protected Encoder out(char[] ch, int start, int length) throws OutputException {
        int i = 0;
        while (i < length) {
            this.makeDefaultEncodingCheck(ch[start + i]);
            ++i;
        }
        return this;
    }

    protected Encoder out(String s) throws OutputException {
        int i = 0;
        int l = s.length();
        while (i < l) {
            this.makeDefaultEncodingCheck(s.charAt(i));
            ++i;
        }
        return this;
    }

    private void makeDefaultEncodingCheck(char ch) throws OutputException {
        block9: {
            try {
                if ((ch < '\u0000' || ch > '\u007f') && this.stream != null) {
                    int len = this.encoding.reverseEncode(this.convarr, ch);
                    if (len == -1) {
                        this.outCharRefDec(ch);
                        break block9;
                    }
                    switch (len) {
                        case 1: {
                            this.bufferWrite(this.convarr[0]);
                            break;
                        }
                        case 2: {
                            this.bufferWrite(this.convarr[0]);
                            this.bufferWrite(this.convarr[1]);
                            break;
                        }
                        default: {
                            int i = 0;
                            while (i < len) {
                                this.bufferWrite(this.convarr[i]);
                                ++i;
                            }
                            break block9;
                        }
                    }
                    break block9;
                }
                this.bufferWrite(ch);
            }
            catch (IOException e) {
                throw new OutputException(e);
            }
        }
    }

    protected Encoder outEscaped(char ch) throws OutputException {
        if (this.escapingDisabled) {
            this.makeDefaultEncodingCheck(ch);
            return this;
        }
        switch (ch) {
            case '\r': {
                this.out("&#xD;");
                break;
            }
            case '&': {
                this.out("&amp;");
                break;
            }
            case '<': {
                this.out("&lt;");
                break;
            }
            case '>': {
                this.out("&gt;");
                break;
            }
            default: {
                this.makeDefaultEncodingCheck(ch);
            }
        }
        return this;
    }

    protected Encoder outAttribute(CharArray ca, char delimiter) throws OutputException {
        char[] data = ca.getData();
        int offset = ca.getOffset();
        int end = offset + ca.length();
        int i = offset;
        while (i < end) {
            char ch = data[i];
            if (this.escapingDisabled) {
                this.makeDefaultEncodingCheck(ch);
                return this;
            }
            switch (ch) {
                case '\'': {
                    if (delimiter == '\'') {
                        this.out("&apos;");
                        break;
                    }
                    this.out('\'');
                    break;
                }
                case '\"': {
                    if (delimiter == '\"') {
                        this.out("&quot;");
                        break;
                    }
                    this.out('\"');
                    break;
                }
                case '&': {
                    this.out("&amp;");
                    break;
                }
                case '<': {
                    this.out("&lt;");
                    break;
                }
                case '>': {
                    this.out(">");
                    break;
                }
                case '\t': {
                    this.out("&#x9;");
                    break;
                }
                case '\n': {
                    this.out("&#xA;");
                    break;
                }
                case '\r': {
                    this.out("&#xD;");
                    break;
                }
                default: {
                    this.makeDefaultEncodingCheck(ch);
                }
            }
            ++i;
        }
        return this;
    }

    protected Encoder outEscaped(char[] ch, int start, int length) throws OutputException {
        if (this.escapingDisabled) {
            return this.out(ch, start, length);
        }
        int end = start + length;
        int i = start;
        while (i < end) {
            this.outEscaped(ch[i]);
            ++i;
        }
        return this;
    }

    protected Encoder outEscaped(String s) throws OutputException {
        if (this.escapingDisabled) {
            return this.out(s);
        }
        int i = 0;
        while (i < s.length()) {
            this.outEscaped(s.charAt(i));
            ++i;
        }
        return this;
    }

    protected Encoder out(CharArray ca) throws OutputException {
        return this.out(ca.getData(), ca.getOffset(), ca.length());
    }

    protected Encoder outEscaped(CharArray ca) throws OutputException {
        return this.outEscaped(ca.getData(), ca.getOffset(), ca.length());
    }

    protected Encoder outCDATA(char[] ch, int start, int length) throws OutputException {
        this.out(CDATA_BEGIN);
        if (length < 3) {
            this.out(ch, start, length);
        } else {
            char prev2 = ch[start];
            char prev = ch[start + 1];
            this.out(prev2);
            this.out(prev);
            int end = start + length;
            int i = start + 2;
            while (i < end) {
                char curr = ch[i];
                if (prev2 == ']' && prev == ']' && curr == '>') {
                    this.out(CDATA_END_BEGIN);
                }
                this.out(curr);
                prev2 = prev;
                prev = curr;
                ++i;
            }
        }
        this.out(CDATA_END);
        return this;
    }

    protected Encoder outln() throws OutputException {
        return this.out(LINE_SEPARATOR);
    }

    protected Encoder outSpace(int x) throws OutputException {
        int i = 0;
        while (i < x) {
            this.out(' ');
            ++i;
        }
        return this;
    }

    protected Encoder outCharRefHex(char ch) throws OutputException {
        return this.out("&#x").out(Integer.toHexString(ch)).out(';');
    }

    protected Encoder outCharRefDec(char ch) throws OutputException {
        return this.out("&#").out(StaticInteger.intToCharArray(ch, this.chTempOutRef)).out(';');
    }

    protected Encoder outHTMLAttribute(CharArray s, boolean uriflag) throws OutputException {
        char[] data = s.getData();
        int size = s.length();
        int off = s.getOffset();
        int totsize = size + off;
        int i = off;
        while (i < totsize) {
            boolean showEscaped = true;
            if (data[i] == '<') {
                showEscaped = false;
            }
            if (i + 1 < totsize && data[i] == '&' && data[i + 1] == '{') {
                showEscaped = false;
            }
            if (showEscaped) {
                if (uriflag && data[i] > '\u0080') {
                    this.outCharRefHex(data[i]);
                } else if (uriflag && data[i] == ' ') {
                    this.out("%20");
                } else {
                    this.outEscaped(data[i]);
                }
            } else {
                this.out(data[i]);
            }
            ++i;
        }
        return this;
    }

    protected Encoder flush() throws OutputIOException {
        try {
            if (this.stream != null) {
                this.stream.write(this.bufwritebyte, 0, this.bufwriteidx);
            } else {
                this.writer.write(this.bufwritechar, 0, this.bufwriteidx);
                this.writer.flush();
            }
            this.bufwriteidx = 0;
        }
        catch (IOException e) {
            throw new OutputIOException(e);
        }
        return this;
    }

    protected void close() throws OutputIOException {
        try {
            if (this.stream != null) {
                this.stream.close();
            } else if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new OutputIOException(e);
        }
    }

    protected void setOwner(DocHandlerSerializer owner) {
        this.owner = owner;
    }

    protected DocHandlerSerializer getOwner() {
        return this.owner;
    }

    protected boolean isEscapingEnabled() {
        return !this.escapingDisabled;
    }

    protected void setEscaping(boolean b) {
        this.escapingDisabled = !b;
    }
}

