/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xsl.xslt.output;

import com.inqmy.lib.xml.parser.DocHandler;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import com.inqmy.lib.xml.parser.helpers.Entity;
import com.inqmy.lib.xml.parser.helpers.Reference;
import com.inqmy.lib.xsl.xslt.output.Encoder;
import com.inqmy.lib.xsl.xslt.output.Indenter;
import com.inqmy.lib.xsl.xslt.output.InstanceHolder;
import com.inqmy.lib.xsl.xslt.output.Method;
import com.inqmy.lib.xsl.xslt.output.MethodXML;
import com.inqmy.lib.xsl.xslt.output.Options;
import com.inqmy.lib.xsl.xslt.output.OutputException;
import com.inqmy.lib.xsl.xslt.output.OutputIllegalOptionException;
import com.inqmy.lib.xsl.xslt.output.Tools;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.Properties;
import org.xml.sax.SAXException;

public class DocHandlerSerializer
implements DocHandler {
    private InstanceHolder holder = new InstanceHolder();
    private Method method = this.holder.getMethodXML();
    private Encoder encoder = new Encoder();
    private Indenter indenter = this.holder.getIndenterEmpty();
    private HashSet cDataSectionElements = new HashSet();
    private Properties outputProperties = null;
    private HashSet options = new HashSet();
    private boolean firstElementReached = false;
    private boolean bMustCloseOnEnd = false;
    private boolean escapingSaver;
    private boolean ignoreComments = false;

    public DocHandlerSerializer() {
        this.options.addAll(Options.DEFAULT);
        this.encoder.setOwner(this);
        this.method.setOwner(this);
        this.bMustCloseOnEnd = false;
    }

    public void setIgnoreComments(boolean status) {
        this.ignoreComments = status;
    }

    public DocHandlerSerializer(Writer writer, Properties outputProperties) throws OutputException {
        this();
        this.setOutputProperties(outputProperties);
        this.setWriter(writer);
    }

    public DocHandlerSerializer(OutputStream outputStream, Properties outputProperties) throws OutputException {
        this();
        this.setOutputProperties(outputProperties);
        this.setOutputStream(outputStream);
    }

    public void setOutputProperties(Properties x) {
        this.outputProperties = x;
    }

    public void setOutputStream(OutputStream outputStream) throws OutputException {
        this.encoder.init(outputStream, this.outputProperties.getProperty("encoding"));
    }

    public void setWriter(Writer writer) throws OutputException {
        this.encoder.init(writer, this.outputProperties.getProperty("encoding"));
    }

    public void startDocument() throws SAXException {
        this.firstElementReached = false;
        String s = this.outputProperties.getProperty("indent");
        this.indenter = Tools.isYes(s) ? this.holder.getIndenterImpl() : this.holder.getIndenterEmpty();
        this.indenter.setOwner(this);
    }

    private void startDocument_internal(String rootElementLocalName) throws SAXException {
        Tools.parseNMTOKENS(this.outputProperties.getProperty("cdata-section-elements"), this.cDataSectionElements);
        String s = this.outputProperties.getProperty("method");
        this.method = Tools.notEmpty(s) ? ((s = s.trim()).equalsIgnoreCase("html") ? this.holder.getMethodHTML() : (s.equalsIgnoreCase("text") ? this.holder.getMethodText() : (s.equalsIgnoreCase("dump") ? this.holder.getMethodDump() : this.holder.getMethodXML()))) : (rootElementLocalName.equalsIgnoreCase("html") ? this.holder.getMethodHTML() : this.holder.getMethodXML());
        this.method.setOwner(this);
        this.encoder.setOwner(this);
        this.options.clear();
        String omit = this.outputProperties.getProperty("omit-xml-declaration");
        String version = this.outputProperties.getProperty("version");
        String encoding = this.encoder.getEncodingName();
        String standalone = this.outputProperties.getProperty("standalone");
        this.indenter.startDocument(omit, version, encoding, standalone);
        String doctypePublic = this.outputProperties.getProperty("doctype-public");
        String doctypeSystem = this.outputProperties.getProperty("doctype-system");
        if ((Tools.notEmpty(doctypePublic) || Tools.notEmpty(doctypeSystem)) && this.method instanceof MethodXML) {
            if (Tools.notEmpty(doctypePublic) && !Tools.notEmpty(doctypeSystem)) {
                throw new OutputException("Illegal output XSLT properties for doctype : public id is specified, but system id is not.");
            }
            this.indenter.startDTD(rootElementLocalName, doctypePublic, doctypeSystem);
            this.indenter.endDTD();
        }
    }

    public void endDocument() throws SAXException {
        this.indenter.endDocument();
        this.encoder.flush();
        if (this.bMustCloseOnEnd) {
            this.encoder.close();
        }
    }

    private void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.firstElementReached) {
            this.firstElementReached = true;
            this.startDocument_internal("");
        }
        this.indenter.characters(ch, start, length);
    }

    private void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.options.contains("http://inqmy.com/output/print-ignorable-whitespace")) {
            this.characters(ch, start, length);
        }
    }

    public void startPrefixMapping(CharArray prefix, CharArray uri) {
    }

    public void endPrefixMapping(CharArray prefix) {
    }

    private void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.firstElementReached) {
            this.firstElementReached = true;
            this.startDocument_internal("");
        }
        this.indenter.comment(ch, start, length);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.method.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        this.method.endDTD();
    }

    public void onXMLDecl(String version, String encoding, String ssdecl) {
    }

    public void startElementStart(CharArray uri, CharArray localName, CharArray qName) throws Exception {
        if (!this.firstElementReached) {
            this.firstElementReached = true;
            this.startDocument_internal(localName.getString());
        }
        this.indenter.startElement0(uri, localName, qName);
    }

    public void addAttribute(CharArray uri, CharArray prefix, CharArray localName, CharArray qname, String type, CharArray value) throws Exception {
        this.indenter.attribute(uri, localName, qname, value);
    }

    public void startElementEnd(boolean b) throws Exception {
        this.indenter.startElement1(b);
    }

    public void endElement(CharArray uri, CharArray localName, CharArray qName, boolean b) throws Exception {
        this.indenter.endElement(uri, localName, qName, b);
    }

    public void charData(CharArray carr, boolean disableOutputEscaping) throws Exception {
        this.characters(carr.getData(), carr.getOffset(), carr.length());
    }

    public void onPI(CharArray target, CharArray data) throws Exception {
        if (!this.firstElementReached) {
            this.firstElementReached = true;
            this.startDocument_internal("");
        }
        if (target.equals("javax.xml.transform.disable-output-escaping")) {
            this.encoder.disableOutputEscaping();
            return;
        }
        if (target.equals("javax.xml.transform.enable-output-escaping")) {
            this.encoder.enableOutputEscaping();
            return;
        }
        this.indenter.processingInstruction(target, data);
    }

    public void onComment(CharArray text) throws Exception {
        if (!this.ignoreComments) {
            this.comment(text.getData(), text.getOffset(), text.length());
        }
    }

    public void onCDSect(CharArray text) throws Exception {
        this.indenter.startCDATA();
        this.encoder.disableOutputEscaping();
        this.indenter.characters(text.getData(), text.getOffset(), text.length());
        this.encoder.enableOutputEscaping();
        this.indenter.endCDATA();
    }

    public void onDTDElement(CharArray name, CharArray model) throws Exception {
    }

    public void onDTDAttListStart(CharArray name) throws Exception {
    }

    public void onDTDAttListItem(CharArray name, CharArray attname, String type, String defDecl, CharArray vAttValue, String note) throws Exception {
    }

    public void onDTDAttListEnd() throws Exception {
    }

    public void onDTDEntity(Entity entity) throws Exception {
        this.method.onDTDEntity(entity);
    }

    public void onDTDNotation(CharArray name, CharArray pub, CharArray sys) throws Exception {
    }

    public void startDTD(CharArray name, CharArray pub, CharArray sys) throws Exception {
        this.method.startDTD(name.toString(), pub.toString(), sys.toString());
    }

    public void onContentReference(Reference ref) throws Exception {
    }

    public void setOption(String name, boolean value) throws OutputException {
        if (name == null) {
            throw new OutputIllegalOptionException("The name of the option is null.");
        }
        if (!Options.ALLOWED.contains(name)) {
            throw new OutputIllegalOptionException("Option '" + name + "' not recognized");
        }
        if (value) {
            this.options.add(name);
        } else {
            this.options.remove(name);
        }
    }

    public boolean getOption(String name) throws OutputException {
        if (name == null) {
            throw new OutputIllegalOptionException("The name of the option is null.");
        }
        if (!Options.ALLOWED.contains(name)) {
            throw new OutputIllegalOptionException("Option '" + name + "' not recognized");
        }
        return this.options.contains(name);
    }

    Encoder getEncoder() {
        return this.encoder;
    }

    Indenter getIndenter() {
        return this.indenter;
    }

    Method getMethod() {
        return this.method;
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    HashSet getCDataSectionElements() {
        return this.cDataSectionElements;
    }

    public void onWarning(String warning) throws Exception {
    }

    public void setCloseOnEnd(boolean value) {
        this.bMustCloseOnEnd = value;
    }

    public void onStartContentEntity(CharArray name, boolean isExpandingReferences) throws OutputException {
        this.escapingSaver = this.encoder.isEscapingEnabled();
        this.encoder.disableOutputEscaping();
        this.indenter.startContentReference(name);
    }

    public void onEndContentEntity(CharArray name) throws OutputException {
        this.indenter.endContentReference(name);
        this.encoder.setEscaping(this.escapingSaver);
    }

    public void onCustomEvent(int eventId, Object obj) throws Exception {
    }
}

