/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xsl.xslt;

import com.inqmy.lib.xsl.xpath.ETLocationStep;
import com.inqmy.lib.xsl.xpath.ETObject;
import com.inqmy.lib.xsl.xslt.XSLException;
import com.inqmy.lib.xsl.xslt.XSLTemplate;

public class XSLTemplateHeader
implements Comparable {
    public String sMode;
    public String sName;
    public boolean bIsDefault;
    public XSLTemplate template;
    public double priority;
    public int importPrecedence;
    public ETObject match;
    public boolean bMatchable;
    public int position = -1;

    public XSLTemplateHeader(ETObject etobj, XSLTemplate templ, int pos) {
        this.template = templ;
        this.match = etobj;
        this.bIsDefault = templ.def;
        this.sMode = templ.mode;
        if (this.sMode == null) {
            this.sMode = "";
        }
        this.importPrecedence = templ.importPrecedence;
        this.priority = templ.priority;
        this.position = pos;
        this.sName = templ.name;
        if (!templ.bSpecifiedPriority) {
            if (this.match.et instanceof ETLocationStep) {
                ETLocationStep loc = (ETLocationStep)this.match.et;
                this.priority = loc.getNodeTest().localname.equals("*") ? -0.25 : (loc.getNodeTest().localname.equals("node()") || loc.getNodeTest().localname.equals("text()") || loc.getNodeTest().localname.equals("comment()") ? -0.5 : 0.0);
            } else {
                this.priority = 0.5;
            }
        }
        this.bMatchable = this.match.squery != null && this.match.squery.length() != 0;
    }

    public void setPriority(String p) throws XSLException {
        if (p != null && p.length() > 0) {
            this.priority = this.template.owner.staticDouble.stringToDouble(p);
        } else if (this.match.et instanceof ETLocationStep) {
            ETLocationStep loc = (ETLocationStep)this.match.et;
            this.priority = loc.getNodeTest().localname.equals("*") ? -0.25 : (loc.getNodeTest().localname.equals("node()") || loc.getNodeTest().localname.equals("text()") || loc.getNodeTest().localname.equals("comment()") ? -0.5 : 0.0);
        } else {
            this.priority = 0.5;
        }
    }

    public int compareTo(Object o) {
        XSLTemplateHeader t = (XSLTemplateHeader)o;
        if (this.importPrecedence != t.importPrecedence) {
            if (this.importPrecedence < t.importPrecedence) {
                return -1;
            }
            return 1;
        }
        if (this.priority != t.priority) {
            if (this.priority < t.priority) {
                return -1;
            }
            return 1;
        }
        return this.position - t.position;
    }

    public String toString() {
        return "#XSLTemplateHeader: match=" + this.match.squery + " name=" + this.sName + " prior= " + this.priority;
    }
}

