/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xsl.xslt;

import com.inqmy.lib.xml.parser.DocHandler;
import com.inqmy.lib.xml.parser.URLLoader;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import com.inqmy.lib.xsl.xpath.XPathContext;
import com.inqmy.lib.xsl.xpath.XPathException;
import com.inqmy.lib.xsl.xslt.AttributeValueTemplateHandler;
import com.inqmy.lib.xsl.xslt.XSLContentNode;
import com.inqmy.lib.xsl.xslt.XSLException;
import com.inqmy.lib.xsl.xslt.XSLNode;
import com.inqmy.lib.xsl.xslt.XSLOutputNode;
import com.inqmy.lib.xsl.xslt.XSLStylesheet;
import com.inqmy.lib.xsl.xslt.output.DocHandlerSerializer;
import com.inqmy.lib.xsl.xslt.output.OutputException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class XSLDocument
extends XSLContentNode {
    private String method = null;
    private String version = null;
    private String encoding = null;
    private String omitXmlDeclaration = null;
    private String standalone = null;
    private String doctypePublic = null;
    private String doctypeSystem = null;
    private String cdataSectionElements = null;
    private String indent = null;
    private String mediaType = null;
    private String href = null;
    private Properties prop = null;
    private AttributeValueTemplateHandler hrefTemplate = new AttributeValueTemplateHandler();
    private CharArray instHref = new CharArray();

    public String[] getRequiredParams() {
        return new String[]{"href"};
    }

    public String[] getOptionalParams() {
        return new String[]{"method", "version", "indent", "encoding", "standalone"};
    }

    public XSLDocument(XSLStylesheet owner, XSLNode parent, Element el) throws XSLException {
        super(owner, parent, el);
        this.init(el, parent);
    }

    public void init(Element el, XSLNode parent) throws XSLException {
        this.prop = new Properties();
        if (el.hasAttribute("method")) {
            this.method = el.getAttribute("method");
            this.prop.setProperty("method", this.method);
        }
        if (el.hasAttribute("version")) {
            this.version = el.getAttribute("version");
            this.prop.setProperty("version", this.version);
        }
        if (el.hasAttribute("encoding")) {
            this.encoding = el.getAttribute("encoding");
            this.prop.setProperty("encoding", this.encoding);
        }
        if (el.hasAttribute("standalone")) {
            this.standalone = el.getAttribute("standalone");
            this.prop.setProperty("standalone", this.standalone);
        }
        if (el.hasAttribute("ident")) {
            this.indent = el.getAttribute("indent");
            this.prop.setProperty("indent", this.indent);
        }
        if (!el.hasAttribute("href")) {
            throw new XSLException("Attribute href is obligatory for an xsl:document !");
        }
        this.href = el.getAttribute("href");
    }

    private void fillBlanksFromParent(XSLDocument par) {
        if (this.method == null) {
            this.method = par.getMethod();
        }
        if (this.version == null) {
            this.version = par.getVersion();
        }
        if (this.encoding == null) {
            this.encoding = par.getEncoding();
        }
        if (this.standalone == null) {
            this.standalone = par.getStandalone();
        }
        if (this.indent == null) {
            this.indent = par.getIndent();
        }
        this.cdataSectionElements = par.getCdataSectionElements();
        this.doctypeSystem = par.getDoctypeSystem();
        this.doctypePublic = par.getDoctypePublic();
        this.mediaType = par.getMediaType();
        this.omitXmlDeclaration = par.getOmitXmlDeclaration();
    }

    private void fillBlanksFromParent(XSLOutputNode par) throws XSLException {
        if (this.method == null) {
            this.method = par.getMethod();
        }
        if (this.version == null) {
            this.version = par.getVersion();
        }
        if (this.encoding == null) {
            this.encoding = par.getEncoding();
        }
        if (this.standalone == null) {
            this.standalone = par.getStandalone();
        }
        if (this.indent == null) {
            this.indent = par.getIndent();
        }
        if (this.indent == null) {
            this.cdataSectionElements = par.getCdataSectionElements();
        }
        if (this.doctypeSystem == null) {
            this.doctypeSystem = par.getDoctypeSystem();
        }
        if (this.doctypePublic == null) {
            this.doctypePublic = par.getDoctypePublic();
        }
        if (this.mediaType == null) {
            this.mediaType = par.getMediaType();
        }
        if (this.omitXmlDeclaration == null) {
            this.omitXmlDeclaration = par.getOmitXmlDeclaration();
        }
    }

    public Object getParentDocument(Element e) {
        Node n = e.getParentNode();
        if (n.getNodeType() == 9) {
            return n;
        }
        if (((Element)n).getTagName().equals("xsl:document")) {
            return (Element)n;
        }
        return this.getParentDocument((Element)n);
    }

    public String getCdataSectionElements() {
        return this.cdataSectionElements;
    }

    public String getDoctypePublic() {
        return this.doctypePublic;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    public String getIndent() {
        return this.indent;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getMethod() {
        return this.method;
    }

    public String getOmitXmlDeclaration() {
        return this.omitXmlDeclaration;
    }

    public String getVersion() {
        return this.version;
    }

    public String getStandalone() {
        return this.standalone;
    }

    public void process(XPathContext xcont, int node) throws XSLException, XPathException {
        try {
            DocHandler h = this.owner.getOutputProcessor().getDocHandler();
            if (h instanceof DocHandlerSerializer) {
                this.prop = ((DocHandlerSerializer)h).getOutputProperties();
            } else if (this.owner.getOutputProperties() != null) {
                this.fillBlanksFromParent(this.owner.getOutputProperties());
                this.prop = new Properties();
                if (this.method != null) {
                    this.prop.setProperty("method", this.method);
                }
                if (this.version != null) {
                    this.prop.setProperty("version", this.version);
                }
                if (this.encoding != null) {
                    this.prop.setProperty("encoding", this.encoding);
                }
                if (this.standalone != null) {
                    this.prop.setProperty("standalone", this.standalone);
                }
                if (this.indent != null) {
                    this.prop.setProperty("indent", this.indent);
                }
                if (this.cdataSectionElements != null) {
                    this.prop.setProperty("cdata-section-elements", this.cdataSectionElements);
                }
                if (this.doctypeSystem != null) {
                    this.prop.setProperty("doctype-system", this.doctypeSystem);
                }
                if (this.doctypePublic != null) {
                    this.prop.setProperty("doctype-public", this.doctypePublic);
                }
                if (this.mediaType != null) {
                    this.prop.setProperty("media-type", this.mediaType);
                }
                if (this.omitXmlDeclaration != null) {
                    this.prop.setProperty("omit-xml-declaration", this.omitXmlDeclaration);
                }
            }
            this.instHref.clear();
            this.hrefTemplate.init(new CharArray(this.href), this.owner.etBuilder);
            this.hrefTemplate.processTo(this.instHref, this.owner.getXPathProcessor(), xcont, this.varContext);
            URLLoader urlloader = new URLLoader();
            URL u = urlloader.load(urlloader.load(null, this.owner.getBaseURI()), this.instHref.toString());
            File f = new File(u.getFile());
            File dir = f.getParentFile();
            if (dir != null) {
                dir.mkdirs();
            }
            FileOutputStream o = new FileOutputStream(u.getFile());
            DocHandlerSerializer dhs = new DocHandlerSerializer(o, XSLDocument.fillDefaultProperties(this.prop));
            dhs.startDocument();
            this.owner.getOutputProcessor().setDocHandler(dhs);
            if (this.getFirst() != null) {
                this.getFirst().process(xcont, node);
            }
            dhs.endDocument();
            ((OutputStream)o).close();
            this.owner.getOutputProcessor().setDocHandler(h);
            if (this.getNext() != null) {
                this.getNext().process(xcont, node);
            }
        }
        catch (FileNotFoundException e) {
            throw new XSLException(e.toString());
        }
        catch (OutputException e) {
            throw new XSLException(e.toString());
        }
        catch (IOException e) {
            throw new XSLException(e.toString());
        }
        catch (SAXException e) {
            throw new XSLException("SAXException!!" + e.toString());
        }
    }

    public static Properties fillDefaultProperties(Properties p) {
        if (!((Hashtable)p).containsKey("method")) {
            p.setProperty("method", "xml");
        }
        if (!((Hashtable)p).containsKey("encoding")) {
            p.setProperty("encoding", "utf-8");
        }
        if (!((Hashtable)p).containsKey("cdata-section-elements")) {
            p.setProperty("cdata-section-elements", "");
        }
        return p;
    }
}

