/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xsl.xslt;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class NestedException
extends Exception {
    public static final String WRAPPING = " -> ";
    public static final String TRACE_SEPARATOR = "\t----------------------------------------";
    private Throwable cause;

    public NestedException() {
    }

    public NestedException(Throwable cause) {
        this.cause = cause;
    }

    public NestedException(String message) {
        super(message);
    }

    public NestedException(Throwable cause, String message) {
        super(message);
        this.cause = cause;
    }

    public NestedException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    public final Throwable getCause() {
        return this.cause;
    }

    public final void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public final void printStackTrace(PrintStream out) {
        if (this.cause == null) {
            super.printStackTrace(out);
        } else {
            PrintStream printStream = out;
            synchronized (printStream) {
                out.print(this.toFullString() + WRAPPING);
                this.cause.printStackTrace(out);
                out.println(TRACE_SEPARATOR);
                out.print(this.traceOf(this.cause));
            }
        }
    }

    public final void printStackTrace(PrintWriter out) {
        if (this.cause == null) {
            super.printStackTrace(out);
        } else {
            PrintWriter printWriter = out;
            synchronized (printWriter) {
                out.print(this.toFullString() + WRAPPING);
                this.cause.printStackTrace(out);
                out.println(TRACE_SEPARATOR);
                out.print(this.traceOf(this.cause));
            }
        }
    }

    private String traceOf(Throwable th) {
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        super.printStackTrace(pw);
        pw.flush();
        String s = w.toString();
        int p = s.indexOf("\tat");
        if (p != -1) {
            s = s.substring(p);
        }
        return s;
    }

    private final String toFullString() {
        return this.cause == null ? super.toString() : super.toString() + WRAPPING + this.cause.toString();
    }

    public String toString() {
        return this.toFullString();
    }
}

