/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xsl.xpath;

import com.inqmy.lib.xml.dom.AttrImpl;
import com.inqmy.lib.xml.dom.DocumentImpl;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import com.inqmy.lib.xml.parser.pool.CharArrayPool;
import com.inqmy.lib.xml.util.analyze.XMLAnalyzerResult;
import com.inqmy.lib.xsl.xpath.LibraryManager;
import com.inqmy.lib.xsl.xpath.XPathContext;
import com.inqmy.lib.xsl.xpath.xobjects.XObjectFactory;
import com.inqmy.lib.xsl.xslt.QName;
import com.inqmy.lib.xsl.xslt.VariableContext;
import com.inqmy.lib.xsl.xslt.XSLStylesheet;
import com.inqmy.lib.xsl.xslt.pool.ObjectPool;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class DTM {
    public static final int DEFAULT_CAPACITY = 10;
    public int RESIZE_STEP = 10;
    private XPathContext initialContext = null;
    public int size = 0;
    private int capacity;
    public QName[] name;
    public byte[] nodeType;
    public int[] parent;
    public int[] firstChild;
    public int[] previousSibling;
    public int[] nextSibling;
    public int[] documentNodes;
    private int documentNodesCount = 0;
    public Node[] domtree = null;
    private boolean[] initialized = null;
    private StringBuffer leadingText = new StringBuffer(1024);
    private static final String[] empty = new String[0];
    private boolean[] dangling = null;
    private boolean domInitialized = false;
    private DocumentImpl doc = null;
    private Node frag = null;
    protected CharArray[] stringValue;
    protected CharArray buffer = new CharArray(300000, 100000);
    protected int[] indexStart;
    protected int[] indexEnd;
    public XMLAnalyzerResult analyzerResult = null;
    boolean bEndDoc = false;
    private int[] idAttributes = new int[100];
    private int nIdAttributes = 0;
    private boolean[] towNamespaces = null;
    public static final byte ELEMENT_NODE = 1;
    public static final byte ATTRIBUTE_NODE = 2;
    public static final byte TEXT_NODE = 3;
    public static final byte CDATA_SECTION_NODE = 4;
    public static final byte ENTITY_REFERENCE_NODE = 5;
    public static final byte ENTITY_NODE = 6;
    public static final byte PROCESSING_INSTRUCTION_NODE = 7;
    public static final byte COMMENT_NODE = 8;
    public static final byte DOCUMENT_NODE = 9;
    public static final byte DOCUMENT_TYPE_NODE = 10;
    public static final byte DOCUMENT_FRAGMENT_NODE = 11;
    public static final byte NOTATION_NODE = 12;
    public static final byte NAMESPACE_NODE = 13;
    public static final byte WHATEVER_NODE = 100;
    public static final int NONE = -1;
    public CharArrayPool carrPool = new CharArrayPool(10000, 10000);
    public ObjectPool qnamePool = new ObjectPool(class$com$inqmy$lib$xsl$xslt$QName == null ? (class$com$inqmy$lib$xsl$xslt$QName = DTM.class$("com.inqmy.lib.xsl.xslt.QName")) : class$com$inqmy$lib$xsl$xslt$QName, 10000, 10000);
    public XObjectFactory xfactProcess = null;
    public XObjectFactory xfactMatch = null;
    public Hashtable xfDocumentCache = new Hashtable();
    static /* synthetic */ Class class$com$inqmy$lib$xsl$xslt$QName;

    public DTM() {
        this(10);
    }

    public DTM(int capacity) {
        this.capacity = capacity;
        this.name = new QName[capacity];
        this.nodeType = new byte[capacity];
        this.parent = new int[capacity];
        this.firstChild = new int[capacity];
        this.previousSibling = new int[capacity];
        this.nextSibling = new int[capacity];
        this.stringValue = new CharArray[capacity];
        this.indexStart = new int[capacity];
        this.indexEnd = new int[capacity];
        this.documentNodes = new int[10];
    }

    public void setFactories(XObjectFactory xp, XObjectFactory xm) {
        this.xfactProcess = xp;
        this.xfactMatch = xm;
    }

    public XPathContext getInitialContext() {
        return this.getInitialContext(null);
    }

    public XPathContext getInitialContext(XSLStylesheet owner) {
        if (this.initialContext == null) {
            if (this.xfactProcess == null) {
                this.xfactMatch = this.xfactProcess = new XObjectFactory(100);
            }
            this.initialContext = new XPathContext(this, 0, 1, 1, new VariableContext(), new LibraryManager(), new Hashtable(), 0, this.xfactProcess, this.xfactMatch, owner, null);
        }
        XPathContext icont = new XPathContext();
        icont.owner = owner;
        icont.reuse(this.initialContext, 0, 1, 1);
        icont.setGlobalCurrentNode(0);
        return icont;
    }

    public void clear() {
        this.size = 0;
        this.analyzerResult = null;
        this.buffer.clear();
        this.initialContext = null;
        this.xfactProcess = null;
        this.xfactMatch = null;
        this.xfDocumentCache.clear();
        this.nIdAttributes = 0;
    }

    public void addIdAttribute(int x) {
        if (this.idAttributes.length == this.nIdAttributes) {
            int[] idAttributesOld = this.idAttributes;
            this.idAttributes = new int[this.nIdAttributes * 2];
            System.arraycopy(idAttributesOld, 0, this.idAttributes, 0, this.nIdAttributes);
        }
        this.idAttributes[this.nIdAttributes] = x;
        ++this.nIdAttributes;
    }

    public int getElementById(String id) {
        int i = 0;
        while (i < this.nIdAttributes) {
            if (this.getStringValue(this.idAttributes[i]).equals(id)) {
                return this.parent[this.idAttributes[i]];
            }
            ++i;
        }
        return -1;
    }

    protected void appendNode(CharArray name0, CharArray uri, int uriId, byte nodeType0, CharArray stringValue0, int indexStart0, int indexEnd0) {
        if (this.size >= this.capacity - 1) {
            this.resize();
        }
        if (nodeType0 == 9) {
            this.bEndDoc = false;
            this.documentNodes[this.documentNodesCount++] = this.size;
            if (this.documentNodesCount == this.documentNodes.length) {
                int[] temp = new int[this.documentNodesCount + this.RESIZE_STEP];
                System.arraycopy(this.documentNodes, 0, temp, 0, this.documentNodesCount);
                this.documentNodes = temp;
            }
        } else {
            this.bEndDoc = false;
        }
        if (uri == null) {
            uri = CharArray.EMPTY;
        }
        if (this.name[this.size] == null && nodeType0 != 3) {
            this.name[this.size] = (QName)this.qnamePool.getObject();
        }
        if (this.name[this.size] != null) {
            this.name[this.size].reuse(name0, uri, uriId);
        }
        this.nodeType[this.size] = nodeType0;
        this.nextSibling[this.size] = -1;
        this.previousSibling[this.size] = -1;
        this.firstChild[this.size] = -1;
        this.parent[this.size] = -1;
        if (stringValue0 != null) {
            if (this.stringValue[this.size] != null) {
                this.stringValue[this.size].clear();
            }
            if (this.stringValue[this.size] == null) {
                this.stringValue[this.size] = this.carrPool.getObject().reuse();
            }
            this.stringValue[this.size].set(stringValue0);
        }
        this.indexStart[this.size] = indexStart0;
        this.indexEnd[this.size] = indexEnd0;
        ++this.size;
    }

    private void appendItem(StringBuffer sb, int index) {
        sb.append("[").append(index).append("] ").append(this.name[index]);
    }

    private void appendDetailedItem(StringBuffer sb, int index) {
        sb.append("    [").append(index).append("] ").append(this.nodeTypeToString(this.nodeType[index])).append(" name='").append(this.name[index]).append("', parent=").append(this.parent[index]).append(", previousSibling=").append(this.previousSibling[index]).append(", nextSibling=").append(this.nextSibling[index]).append(", firstChild=").append(this.firstChild[index]).append(", stringValue='");
        if (this.stringValue[index].length() < 30) {
            sb.append(this.stringValue[index].replace('\n', '#'));
        } else {
            sb.append(this.stringValue[index].replace('\n', '#'));
            sb.append("...");
        }
        sb.append("']\n");
    }

    public String toDetailedString() {
        if (this.size == 0) {
            return "(EMPTY DTM)";
        }
        StringBuffer r = new StringBuffer(100000);
        r.append("\nDocument Table Model, detailed description: \n");
        this.appendDetailedItem(r, 0);
        int i = 1;
        while (i < this.size) {
            this.appendDetailedItem(r, i);
            ++i;
        }
        r.append("\n");
        return r.toString();
    }

    public int[] getChildNodes(int node, int[] nodes, int start) {
        int i = this.firstChild[node];
        int p = start;
        int nodesLength = nodes.length;
        while (true) {
            if (p >= nodesLength) {
                nodes = this.resizeIntArray(nodes, p);
                nodesLength = nodes.length;
            }
            nodes[p] = i;
            if (i == -1) break;
            i = this.nextSibling[i];
            ++p;
        }
        return nodes;
    }

    public int[] getChildNodes(int node) {
        int i = this.firstChild[node];
        int nodeCount = 0;
        while (i != -1) {
            ++nodeCount;
            i = this.nextSibling[i];
        }
        int[] nodes = new int[nodeCount];
        i = this.firstChild[node];
        nodeCount = 0;
        while (i != -1) {
            nodes[nodeCount++] = i;
            i = this.nextSibling[i];
        }
        return nodes;
    }

    public int[] getAttributeNodes(int node, int[] nodes, int start) {
        int x = node + 1;
        int p = start;
        int nodesLength = nodes.length;
        while (true) {
            byte t;
            if (p >= nodesLength) {
                nodes = this.resizeIntArray(nodes, p);
                nodesLength = nodes.length;
            }
            if ((t = this.nodeType[x]) != 2 && t != 13) break;
            if (t == 2) {
                nodes[p] = x;
                ++p;
            }
            ++x;
        }
        nodes[p] = -1;
        return nodes;
    }

    public int[] getAttributeAndNSNodes(int node, int[] nodes, int start) {
        int x = node + 1;
        int p = start;
        int nodesLength = nodes.length;
        while (true) {
            byte t;
            if (p >= nodesLength) {
                nodes = this.resizeIntArray(nodes, p);
                nodesLength = nodes.length;
            }
            if ((t = this.nodeType[x]) != 2 && t != 13) break;
            nodes[p] = x++;
            ++p;
        }
        nodes[p] = -1;
        return nodes;
    }

    public int getAttributesStartIndex(int node) {
        return node + 1;
    }

    public int getAttributesEndIndex(int node) {
        int x = node + 1;
        while (x < this.size && this.nodeType[x] == 2) {
            ++x;
        }
        return x - 1;
    }

    public int getAttributesAndNSEndIndex(int node) {
        int x = node + 1;
        while (x < this.size && (this.nodeType[x] == 2 || this.nodeType[x] == 13)) {
            ++x;
        }
        return x - 1;
    }

    void resize() {
        this.resize(this.capacity + this.RESIZE_STEP);
    }

    void resize(int capacity1) {
        QName[] name1 = new QName[capacity1];
        System.arraycopy(this.name, 0, name1, 0, this.capacity);
        this.name = name1;
        byte[] nodeType1 = new byte[capacity1];
        System.arraycopy(this.nodeType, 0, nodeType1, 0, this.capacity);
        this.nodeType = nodeType1;
        int[] parent1 = new int[capacity1];
        System.arraycopy(this.parent, 0, parent1, 0, this.capacity);
        this.parent = parent1;
        int[] firstChild1 = new int[capacity1];
        System.arraycopy(this.firstChild, 0, firstChild1, 0, this.capacity);
        this.firstChild = firstChild1;
        int[] previousSibling1 = new int[capacity1];
        System.arraycopy(this.previousSibling, 0, previousSibling1, 0, this.capacity);
        this.previousSibling = previousSibling1;
        int[] nextSibling1 = new int[capacity1];
        System.arraycopy(this.nextSibling, 0, nextSibling1, 0, this.capacity);
        this.nextSibling = nextSibling1;
        CharArray[] stringValue1 = new CharArray[capacity1];
        System.arraycopy(this.stringValue, 0, stringValue1, 0, this.capacity);
        this.stringValue = stringValue1;
        int[] indexStart1 = new int[capacity1];
        System.arraycopy(this.indexStart, 0, indexStart1, 0, this.capacity);
        this.indexStart = indexStart1;
        int[] indexEnd1 = new int[capacity1];
        System.arraycopy(this.indexEnd, 0, indexEnd1, 0, this.capacity);
        this.indexEnd = indexEnd1;
        this.capacity = capacity1;
        this.RESIZE_STEP = this.capacity / 2;
    }

    public String nodeTypeToString(int nt) {
        String[] s = new String[]{"", "ELEM", "ATTR", "TEXT", "CDTA", "EREF", "ENTY", "PROC", "COMM", "DOCU", "DCTP", "DCFR", "NOTN"};
        return s[nt];
    }

    public int getCapacity() {
        return this.capacity;
    }

    private int[] resizeIntArray(int[] a, int l) {
        int[] b = new int[l + a.length];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    public void getStringValue(int index, CharArray ca) {
        int b = this.indexStart[index];
        if (b != -1) {
            int e = this.indexEnd[index];
            ca.substring(this.buffer, b, e);
        } else {
            ca.set(this.stringValue[index]);
        }
    }

    public CharArray getStringValue(int index) {
        int b = this.indexStart[index];
        if (b != -1) {
            int e = this.indexEnd[index];
            if (this.stringValue[index] == null) {
                this.stringValue[index] = this.carrPool.getObject().reuse();
            }
            this.stringValue[index].substring(this.buffer, b, e);
            this.indexStart[index] = -1;
            this.indexEnd[index] = -1;
            return this.stringValue[index];
        }
        return this.stringValue[index];
    }

    void print() {
        System.err.println("DUMP DTM BEGIN");
        System.err.println("#x %nodeType (0)indexStart (1)indexEnd $stringValue");
        int i = 0;
        while (i < Math.min(this.size, 100)) {
            System.err.println(" #" + i + ": %" + this.nodeTypeToString(this.nodeType[i]) + " (0)" + this.indexStart[i] + " (1)" + this.indexEnd[i] + " $\"" + this.stringValue[i] + "\"");
            ++i;
        }
        System.err.println("DUMP DTM END");
        System.err.println("DUMP BUFFER BEGIN");
        int w = 50;
        int e = (this.buffer.length() + w - 1) % w;
        int i2 = 0;
        while (i2 < e - 1) {
            System.err.print(new String(this.buffer.getData(), i2 * w, i2 * w + w));
            ++i2;
        }
        System.err.println(new String(this.buffer.getData(), (e - 1) * w, this.buffer.length()));
        System.err.println("DUMP BUFFER END");
    }

    public Document getDocument() {
        this.initializeDOM();
        return this.doc;
    }

    public Node getFragment() {
        return this.frag;
    }

    public StringBuffer getLeadingText() {
        return this.leadingText;
    }

    public void reinitializeDOM(int[] excluding) {
        this.reinitializeDOM(excluding, false, empty);
    }

    public void reinitializeDOM(int[] excluding, String[] specialNamespaces) {
        this.reinitializeDOM(excluding, false, specialNamespaces);
    }

    public void reinitializeDOM(int[] excluding, boolean retainParentNamespaces) {
        this.reinitializeDOM(excluding, retainParentNamespaces, null);
    }

    public void reinitializeDOM(int[] excluding, boolean retainParentNamespaces, String[] specialNamespaces) {
        this.reinitializeDOM(excluding, retainParentNamespaces, specialNamespaces, false);
    }

    public void reinitializeDOM(int[] excluding, boolean retainParentNamespaces, String[] specialNamespaces, boolean visibleOnly) {
        int i;
        this.towNamespaces = new boolean[this.size];
        if (retainParentNamespaces) {
            Arrays.sort(excluding);
            i = 0;
            while (i < this.size) {
                this.towNamespaces[i] = Arrays.binarySearch(excluding, this.parent[i]) >= 0;
                ++i;
            }
        }
        this.doc = new DocumentImpl();
        this.domtree = new Node[this.size];
        this.dangling = new boolean[this.size];
        this.initialized = new boolean[this.size];
        i = 1;
        while (i < this.domtree.length) {
            this.domtree[i] = this.subtree(i, excluding, retainParentNamespaces, specialNamespaces, visibleOnly);
            this.initialized[i] = true;
            if (Arrays.binarySearch(excluding, i) < 0) {
                this.dangling[i] = this.isDangling(i, excluding);
            }
            ++i;
        }
        int i2 = 1;
        i2 = 1;
        while (i2 < this.size) {
            if (this.domtree[i2].getNodeType() == 3) {
                if (Arrays.binarySearch(excluding, i2) < 0) {
                    this.leadingText.append(this.stringValue[i2].toString());
                }
            } else if (Arrays.binarySearch(excluding, i2) < 0) break;
            ++i2;
        }
        if (i2 >= this.domtree.length) {
            return;
        }
        this.doc.appendChild(this.domtree[i2]);
        this.frag = this.doc.createDocumentFragment();
        if (this.dangling.length >= 1) {
            int j = i2;
            while (j < this.size) {
                if (this.dangling[j]) {
                    this.frag.appendChild(this.domtree[j]);
                }
                ++j;
            }
        } else {
            this.frag = this.doc;
        }
        this.domtree[0] = this.doc;
        this.domInitialized = true;
    }

    public void initializeDOM() {
        this.towNamespaces = new boolean[this.size];
        boolean bl = this.domInitialized = this.domInitialized && this.domtree.length == this.size;
        if (!this.domInitialized) {
            if (this.doc == null) {
                this.doc = new DocumentImpl();
            }
            int oldSize = 1;
            if (this.domtree != null && this.domtree.length > 0 && this.initialized != null) {
                oldSize = this.domtree.length;
                Node[] domtree1 = new Node[this.size];
                System.arraycopy(this.domtree, 0, domtree1, 0, this.domtree.length);
                this.domtree = domtree1;
                boolean[] initialized1 = new boolean[this.size];
                System.arraycopy(this.initialized, 0, initialized1, 0, this.initialized.length);
                this.initialized = initialized1;
            } else {
                this.domtree = new Node[this.size];
                this.initialized = new boolean[this.size];
            }
            int[] excluding = new int[]{};
            int i = oldSize;
            while (i < this.domtree.length) {
                this.domtree[i] = this.subtree(i, excluding, false, empty, false);
                this.initialized[i] = true;
                ++i;
            }
            if (this.doc.getDocumentElement() == null) {
                int i2 = 1;
                i2 = 1;
                while (i2 < this.domtree.length && this.domtree[i2].getNodeType() == 3) {
                    ++i2;
                }
                this.doc.appendChild(this.domtree[i2]);
                this.domtree[0] = this.doc;
            }
            this.domInitialized = true;
        }
    }

    private boolean isDangling(int node, int[] excludeList) {
        int father = this.parent[node];
        if (this.nodeType[father] != 9) {
            if (Arrays.binarySearch(excludeList, father) >= 0) {
                return this.isDangling(father, excludeList);
            }
            return false;
        }
        return true;
    }

    private Node subtree(int index, int[] excluding, boolean retainParentNamespaces, String[] specialPrefixes, boolean visibleOnly) {
        if (this.initialized[index]) {
            return this.domtree[index];
        }
        QName q = this.name[index];
        switch ((short)this.nodeType[index]) {
            case 3: {
                Text n = this.doc.createTextNode(this.getStringValue(index).toString());
                this.domtree[index] = n;
                this.initialized[index] = true;
                return n;
            }
            case 2: {
                Attr n = this.doc.createAttributeNS(this.name[index].uri.toString(), this.name[index].rawname.toString());
                ((AttrImpl)n).setValue(this.getStringValue(index).toString());
                this.domtree[index] = n;
                this.initialized[index] = true;
                return n;
            }
            case 7: {
                ProcessingInstruction n = this.doc.createProcessingInstruction(this.name[index].rawname.toString(), this.getStringValue(index).toString());
                return n;
            }
            case 8: 
            case 13: {
                Comment n = this.doc.createComment(this.getStringValue(index).toString());
                this.domtree[index] = n;
                this.initialized[index] = true;
                return n;
            }
            case 4: {
                CDATASection n = this.doc.createCDATASection(this.getStringValue(index).toString());
                this.domtree[index] = n;
                this.initialized[index] = true;
                return n;
            }
            case 1: {
                String defaultNamespace;
                boolean towNamespaces = retainParentNamespaces && this.towNamespaces[index];
                Hashtable<String, String> namespaces = null;
                namespaces = new Hashtable<String, String>();
                Element n = this.doc.createElementNS(this.name[index].uri.toString(), this.name[index].rawname.toString());
                int x = index + 1;
                while (x < this.size) {
                    Attr ai;
                    if (Arrays.binarySearch(excluding, x) >= 0) {
                        ++x;
                        continue;
                    }
                    if (this.nodeType[x] == 13) {
                        namespaces.put(this.name[x].localname.toString(), this.getStringValue(x).toString());
                        ++x;
                        continue;
                    }
                    if (this.nodeType[x] != 2) break;
                    QName q1 = this.name[x];
                    if (q1.uri != null) {
                        ai = this.doc.createAttributeNS(q1.uri.toString(), q1.rawname.toString());
                        ai.setValue(this.getStringValue(x).toString());
                        n.setAttributeNodeNS(ai);
                        ++x;
                        continue;
                    }
                    ai = this.doc.createAttribute(q1.rawname.toString());
                    ai.setValue(this.getStringValue(x).toString());
                    n.setAttributeNode(ai);
                    ++x;
                }
                if (towNamespaces) {
                    this.getNamespaceDeclarations(index, namespaces);
                } else {
                    this.getNamespaceDeclarations(index, namespaces, specialPrefixes, false);
                }
                Enumeration newNamespaces = namespaces.keys();
                while (newNamespaces.hasMoreElements()) {
                    String nextPrefix = (String)newNamespaces.nextElement();
                    String nextValue = (String)namespaces.get(nextPrefix);
                    if (visibleOnly && !this.checkVisibility(index, nextPrefix)) continue;
                    Attr at = this.doc.createAttribute("xmlns:" + nextPrefix);
                    at.setValue(nextValue);
                    n.setAttributeNode(at);
                }
                if (towNamespaces && (defaultNamespace = this.getDefaultNamespace(index)) != null) {
                    Attr ai = this.doc.createAttribute("xmlns");
                    ai.setValue(defaultNamespace);
                    n.setAttributeNode(ai);
                }
                int[] pokolenie = this.getChildNodes(index);
                int i = 0;
                while (i < pokolenie.length) {
                    if (Arrays.binarySearch(excluding, pokolenie[i]) < 0) {
                        n.appendChild(this.subtree(pokolenie[i], excluding, true, specialPrefixes, visibleOnly));
                    }
                    ++i;
                }
                this.domtree[index] = n;
                this.initialized[index] = true;
                return n;
            }
        }
        return this.doc.createTextNode("");
    }

    private boolean checkVisibility(int element, String prefix) {
        if (this.name[element].prefix.toString().equals(prefix)) {
            return true;
        }
        int k = element + 1;
        while (true) {
            if (this.nodeType[k] == 13) {
                ++k;
                continue;
            }
            if (this.nodeType[k] != 2) break;
            if (this.name[k].prefix.toString().equals(prefix)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private String getDefaultNamespace(int index) {
        if (this.nodeType[index] == 9) {
            return null;
        }
        int k = index + 1;
        while (true) {
            if (this.nodeType[k] == 2 && this.name[k].equals("xmlns")) {
                return this.getStringValue(index).toString();
            }
            if (this.nodeType[k] != 2 && this.nodeType[k] != 13) break;
            ++k;
        }
        return this.getDefaultNamespace(this.parent[index]);
    }

    private void getNamespaceDeclarations(int index, Hashtable mappings, String[] intendedPrefixes, boolean dragFromParent) {
        if (this.nodeType[index] == 9) {
            return;
        }
        int k = index + 1;
        while (this.nodeType[k] == 13) {
            if (intendedPrefixes != null && Arrays.binarySearch(intendedPrefixes, this.name[k].getPrefix()) < 0) {
                ++k;
                continue;
            }
            String localName = this.name[k].localname.toString();
            String value = this.stringValue[k].toString();
            if (mappings.get(localName) == null) {
                mappings.put(localName, value);
            }
            ++k;
        }
        if (dragFromParent) {
            this.getNamespaceDeclarations(this.parent[index], mappings, intendedPrefixes, dragFromParent);
        }
    }

    private void getNamespaceDeclarations(int index, Hashtable mappings) {
        this.getNamespaceDeclarations(index, mappings, null, true);
    }

    public int getDocumentElement(int node) {
        int i = this.documentNodesCount - 1;
        while (i >= 0) {
            int docNode = this.documentNodes[i];
            if (docNode <= node) {
                return docNode;
            }
            --i;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

