/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.util;

import com.inqmy.lib.xml.names.XMLNameMapper;
import com.inqmy.lib.xml.util.NamespaceContainer;
import java.io.Serializable;

public class QName
implements Serializable {
    String prefix;
    String localName;
    String uri;

    public QName(String prefix, String localName, String uri) {
        if (prefix == null) {
            prefix = "";
        }
        this.prefix = prefix;
        this.localName = localName;
        this.uri = uri;
    }

    public QName(String qName, String uri) {
        this.prefix = QName.getPrefix(qName);
        this.localName = QName.getLocalName(qName);
        this.uri = uri;
    }

    public int hashCode() {
        return this.localName.hashCode() ^ this.uri.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof QName)) {
            return super.equals(object);
        }
        QName name = (QName)object;
        if (!this.prefix.equals(name.prefix)) {
            return false;
        }
        if (!this.localName.equals(name.localName)) {
            return false;
        }
        return this.uri.equals(name.uri);
    }

    public String getQName() {
        if (this.prefix.length() == 0) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public String toString() {
        return this.getQName();
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public static String repairClassName(String oldName) {
        return XMLNameMapper.toClassIdentifierStatic(oldName);
    }

    public static String repairMethodName(String oldName) {
        return XMLNameMapper.toMethodIdentifierStatic(oldName);
    }

    public static String repairPackageName(String oldName) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < oldName.length()) {
            char c = oldName.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                result.append(Character.toLowerCase(c));
            }
            ++i;
        }
        return result.toString();
    }

    public static QName qnameCreate(String qName, NamespaceContainer uriContainer) throws Exception {
        String prefix = QName.getPrefix(qName);
        String localName = QName.getLocalName(qName);
        String uri = uriContainer.getPrefixURI(prefix);
        if (uri == null && prefix.length() != 0) {
            throw new Exception(" Trying to ask for QName with undefined namespace prefix: " + qName);
        }
        QName result = new QName(prefix, localName, uri);
        return result;
    }

    public static QName qnameWSDLCreate(String qName, NamespaceContainer uriContainer, String targetNamespace) throws Exception {
        String prefix = QName.getPrefix(qName);
        String localName = QName.getLocalName(qName);
        String uri = null;
        uri = prefix.length() == 0 ? targetNamespace : uriContainer.getPrefixURI(prefix);
        if (uri == null && prefix.length() != 0) {
            throw new Exception(" Trying to ask for QName with undefined namespace prefix: " + qName);
        }
        QName result = new QName(prefix, localName, uri);
        return result;
    }

    public static String getPrefix(String qname) {
        int separator = qname.lastIndexOf(58);
        if (separator == -1) {
            return "";
        }
        return qname.substring(0, separator);
    }

    public static String getLocalName(String qname) {
        int separator = qname.indexOf(58);
        if (separator == -1) {
            return qname;
        }
        return qname.substring(separator + 1);
    }
}

