/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.util;

import com.inqmy.lib.xml.parser.DocHandler;
import com.inqmy.lib.xml.util.SAXEmptyHandler;
import com.inqmy.lib.xml.util.SAXToDocHandler;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class DOMToSAX {
    private ContentHandler contentHandler = null;
    private DTDHandler dtdHandler = null;
    private ErrorHandler errorHandler = null;
    private DeclHandler declHandler = null;
    private LexicalHandler lexicalHandler = null;
    private static final SAXEmptyHandler DEFAULT_HANDLER = new SAXEmptyHandler();

    public void convert(Node document, Object handler) throws Exception {
        if (document == null || handler == null) {
            throw new IllegalArgumentException();
        }
        this.convert0(document, handler);
    }

    private void convert(Node node) throws SAXException {
        short t = node.getNodeType();
        String uri = node.getNamespaceURI();
        String localName = node.getLocalName();
        String name = node.getNodeName();
        switch (t) {
            case 1: {
                NamedNodeMap map = node.getAttributes();
                AttributesImpl attributes = new AttributesImpl();
                int i = 0;
                while (i < map.getLength()) {
                    Node a = map.item(i);
                    attributes.addAttribute(a.getNamespaceURI(), a.getLocalName(), a.getNodeName(), "CDATA", a.getNodeValue());
                    ++i;
                }
                this.contentHandler.startElement(uri, localName, name, attributes);
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                char[] data = ((CharacterData)node).getData().toCharArray();
                this.contentHandler.characters(data, 0, data.length);
                return;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                this.contentHandler.processingInstruction(pi.getTarget(), pi.getData());
                return;
            }
            case 8: {
                return;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                DocumentType x = (DocumentType)node;
                this.lexicalHandler.startDTD(x.getName(), x.getPublicId(), x.getSystemId());
                break;
            }
            case 12: {
                Notation notation = (Notation)node;
                this.dtdHandler.notationDecl(notation.getNodeName(), notation.getPublicId(), notation.getSystemId());
                return;
            }
        }
        Node c = node.getFirstChild();
        while (c != null) {
            this.convert(c);
            c = c.getNextSibling();
        }
        switch (t) {
            case 1: {
                this.contentHandler.endElement(uri, localName, name);
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
        }
    }

    public void convert0(Node document, Object handler) throws Exception {
        if (handler instanceof DocHandler) {
            handler = new SAXToDocHandler((DocHandler)handler);
        }
        this.contentHandler = DEFAULT_HANDLER;
        this.dtdHandler = DEFAULT_HANDLER;
        this.errorHandler = DEFAULT_HANDLER;
        this.declHandler = DEFAULT_HANDLER;
        this.lexicalHandler = DEFAULT_HANDLER;
        if (handler instanceof ContentHandler) {
            this.contentHandler = (ContentHandler)handler;
        }
        if (handler instanceof DTDHandler) {
            this.dtdHandler = (DTDHandler)handler;
        }
        if (handler instanceof ErrorHandler) {
            this.errorHandler = (ErrorHandler)handler;
        }
        if (handler instanceof DeclHandler) {
            this.declHandler = (DeclHandler)handler;
        }
        if (handler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)handler;
        }
        try {
            this.contentHandler.startDocument();
            this.convert(document);
            this.contentHandler.endDocument();
        }
        catch (Exception e) {
            if (e instanceof SAXParseException) {
                this.errorHandler.fatalError((SAXParseException)e);
            }
            throw e;
        }
    }
}

