/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.parser.readers;

import com.inqmy.lib.xml.parser.helpers.AdvancedXMLStreamReader;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import com.inqmy.lib.xml.parser.readers.InputSource;
import java.io.IOException;
import java.io.InputStream;

public final class UTF8Reader
extends InputSource {
    protected InputStream in = null;
    protected byte[] buf = null;
    protected int len = -1;
    protected char[] mapping = null;
    protected boolean isUTF8 = true;
    protected int idx = 0;
    protected int DEFAULT_EXT = 10000;
    char x1;
    byte[] utf8buf = new byte[10];
    byte utf8buflen = 0;
    int utf8left = 0;
    public int[] res = new int[2];

    public UTF8Reader() {
        this.buf = new byte[this.ext];
        this.ext = this.DEFAULT_EXT;
    }

    public UTF8Reader(AdvancedXMLStreamReader parent, InputStream in, CharArray id) {
        this.in = in;
        this.parent = parent;
        this.buf = new byte[this.ext];
        this.ext = this.DEFAULT_EXT;
        this.id = id;
        this.eos = false;
    }

    public UTF8Reader reuse(AdvancedXMLStreamReader parent, InputStream in, CharArray id) {
        this.eos = false;
        this.in = in;
        this.parent = parent;
        this.id = id;
        return this;
    }

    public int getBufLen() {
        return this.buf.length;
    }

    public char read() throws Exception {
        if (this.restBytes == 0) {
            this.fetchData();
        }
        if (this.eos) {
            this.in.close();
            return '\u0000';
        }
        --this.restBytes;
        if (this.buf[this.pos] == 10) {
            ++this.iRow;
            this.iCol = 1;
        } else if (this.buf[this.pos] != 13) {
            ++this.iCol;
        }
        if (this.len > 0) {
            --this.len;
        }
        if (this.bReadRaw) {
            this.x1 = (char)this.buf[this.pos];
        } else if (this.isUTF8) {
            if (this.utf8left > 0) {
                byte by = this.utf8buflen;
                this.utf8buflen = (byte)(by + 1);
                this.utf8buf[by] = this.buf[this.pos];
                --this.utf8left;
                ++this.pos;
                if (this.utf8left > 0) {
                    return this.read();
                }
            }
            if (this.utf8left == 0 && this.utf8buflen > 0) {
                this.x1 = (char)this.parseUTF8toUCS4(this.utf8buf, 0, this.utf8buflen)[1];
                this.utf8buflen = 0;
                return this.x1;
            }
            this.x1 = (char)this.buf[this.pos];
            if (this.buf[this.pos] < 0 && this.utf8left == 0) {
                this.utf8left = this.getUTF8CharCount(this.buf[this.pos]);
                byte by = this.utf8buflen;
                this.utf8buflen = (byte)(by + 1);
                this.utf8buf[by] = this.buf[this.pos];
                --this.utf8left;
                ++this.pos;
                return this.read();
            }
        } else {
            this.idx = this.buf[this.pos];
            if (this.idx < 0) {
                this.idx = 256 + this.idx;
            }
            this.x1 = this.mapping[this.idx];
        }
        ++this.pos;
        return this.x1;
    }

    protected void resizeBuffer() {
        byte[] newbuf = new byte[this.buf.length + this.ext];
        System.arraycopy(this.buf, 0, newbuf, 0, this.buf.length);
        this.buf = newbuf;
        this.ext *= 2;
    }

    protected int readData(int offset, int len) throws IOException {
        int bb = this.in.read(this.buf, offset, len);
        return bb;
    }

    protected void moveData(int offsetStart, int offsetEnd, int size) throws Exception {
        if (offsetStart > offsetEnd || offsetStart + size <= offsetEnd) {
            System.arraycopy(this.buf, offsetStart, this.buf, offsetEnd, size);
        } else if (offsetStart + size > offsetEnd) {
            byte[] bbb = new byte[size];
            System.arraycopy(this.buf, offsetStart, bbb, 0, size);
            System.arraycopy(bbb, 0, this.buf, offsetEnd, size);
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public int[] parseUTF8toUCS4(byte[] data, int off, int len) {
        this.res[0] = len;
        if (len == 6) {
            this.res[1] = (data[off] & 1) << 30;
            this.res[1] = this.res[1] | (data[off + 1] & 0x3F) << 24;
            this.res[1] = this.res[1] | (data[off + 2] & 0x3F) << 18;
            this.res[1] = this.res[1] | (data[off + 3] & 0x3F) << 12;
            this.res[1] = this.res[1] | (data[off + 4] & 0x3F) << 6;
            this.res[1] = this.res[1] | data[off + 5] & 0x3F;
        } else if (len == 5) {
            this.res[1] = (data[off] & 3) << 24;
            this.res[1] = this.res[1] | (data[off + 1] & 0x3F) << 18;
            this.res[1] = this.res[1] | (data[off + 2] & 0x3F) << 12;
            this.res[1] = this.res[1] | (data[off + 3] & 0x3F) << 6;
            this.res[1] = this.res[1] | data[off + 4] & 0x3F;
        } else if (len == 4) {
            this.res[1] = (data[off] & 7) << 18;
            this.res[1] = this.res[1] | (data[off + 1] & 0x3F) << 12;
            this.res[1] = this.res[1] | (data[off + 2] & 0x3F) << 6;
            this.res[1] = this.res[1] | data[off + 3] & 0x3F;
        } else if (len == 3) {
            this.res[1] = (data[off] & 0xF) << 12;
            this.res[1] = this.res[1] | (data[off + 1] & 0x3F) << 6;
            this.res[1] = this.res[1] | data[off + 2] & 0x3F;
        } else if (len == 2) {
            this.res[1] = (data[off] & 0x1F) << 6;
            this.res[1] = this.res[1] | data[off + 1] & 0x3F;
        } else if (len == 1) {
            this.res[1] = data[off];
        }
        return this.res;
    }

    public int getUTF8CharCount(byte ch) {
        if ((ch & 0xFC) == 252) {
            return 6;
        }
        if ((ch & 0xF8) == 248) {
            return 5;
        }
        if ((ch & 0xF0) == 240) {
            return 4;
        }
        if ((ch & 0xE0) == 224) {
            return 3;
        }
        if ((ch & 0xC0) == 192) {
            return 2;
        }
        return 1;
    }

    public void setEncoding(CharArray enc) {
    }
}

