/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.parser.readers;

import com.inqmy.lib.xml.parser.helpers.AdvancedXMLStreamReader;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import com.inqmy.lib.xml.parser.readers.InputSource;
import java.io.IOException;
import java.io.InputStream;

public class UTF16Reader
extends InputSource {
    protected InputStream in = null;
    protected byte[] buf = null;
    protected int len = -1;

    public UTF16Reader(AdvancedXMLStreamReader parent, InputStream in, CharArray id) throws Exception {
        this.in = in;
        this.parent = parent;
        this.buf = new byte[this.ext];
        this.ext = 10000;
        this.len = -1;
        this.id = id;
    }

    public int getBufLen() {
        return this.buf.length / 2;
    }

    public char read() throws Exception {
        if (2 * this.pos + 1 >= this.buf.length) {
            this.fetchData();
        }
        if (this.len == 0 || this.pos >= this.restBytes) {
            this.in.close();
            return '\u0000';
        }
        if (this.eos && this.len == -1) {
            if (this.restBytes <= 0) {
                return '\u0000';
            }
            --this.restBytes;
        }
        if (this.buf[this.pos] == 10) {
            ++this.iRow;
            this.iCol = 1;
        } else if (this.buf[this.pos] != 13) {
            ++this.iCol;
        }
        char ch = (char)((char)this.buf[this.pos * 2] & 0xFF);
        ch = (char)(ch | (char)((char)this.buf[this.pos * 2 + 1] << 8 & 0xFF00));
        ++this.pos;
        if (this.len > 0) {
            --this.len;
        }
        return ch;
    }

    public char peak() throws Exception {
        if (this.pos >= this.buf.length) {
            this.fetchData();
        }
        if (this.eos && this.restBytes <= 0) {
            return '\u0000';
        }
        char ch = (char)((char)this.buf[this.pos * 2] & 0xFF);
        ch = (char)(ch | (char)((char)this.buf[this.pos * 2 + 1] << 8 & 0xFF00));
        return ch;
    }

    protected void resizeBuffer() {
        byte[] newbuf = new byte[this.buf.length + this.ext];
        System.arraycopy(this.buf, 0, newbuf, 0, this.buf.length);
        this.buf = newbuf;
        this.ext *= 2;
    }

    protected int readData(int offset, int len) throws IOException {
        return this.in.read(this.buf, offset * 2, len * 2) / 2;
    }

    protected void moveData(int offsetStart, int offsetEnd, int size) throws Exception {
        if ((offsetStart *= 2) > (offsetEnd *= 2) || offsetStart + (size *= 2) <= offsetEnd) {
            System.arraycopy(this.buf, offsetStart, this.buf, offsetEnd, size);
        } else if (offsetStart + size > offsetEnd) {
            char[] bbb = new char[size];
            System.arraycopy(this.buf, offsetStart, bbb, 0, size);
            System.arraycopy(bbb, 0, this.buf, offsetEnd, size);
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }
}

