/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.parser.readers;

import com.inqmy.lib.xml.Symbols;
import com.inqmy.lib.xml.parser.XMLParser;
import com.inqmy.lib.xml.parser.handlers.EncodingHandler;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import com.inqmy.lib.xml.parser.helpers.Encoding;
import com.inqmy.lib.xml.parser.helpers.Entity;
import com.inqmy.lib.xml.parser.helpers.IXMLStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.xml.sax.InputSource;

public class SOAPXMLStream
implements IXMLStream {
    protected int pos = 0;
    protected int ext = 0;
    public boolean eos = false;
    protected int a1;
    protected int a2;
    protected int restBytes = 0;
    protected int totalRead = 0;
    protected CharArray id = null;
    protected CharArray name = null;
    protected int iRow = 1;
    protected int iCol = 1;
    protected boolean bLiteral = false;
    protected char lastchar;
    private int sid = -1;
    protected boolean bReadRaw = false;
    protected InputStream in = null;
    protected byte[] bytebuf = null;
    protected char[] buf = null;
    protected int idx = 0;
    protected int DEFAULT_EXT = 10000;
    int x1;
    XMLParser xmlparser = null;
    private static EncodingHandler encodingHandler = new EncodingHandler();
    private static final CharArray crUTF8 = new CharArray("utf-8");
    protected static Encoding encoding = encodingHandler.getEncoding(crUTF8);
    int cds1;
    char ch;
    int colonChar = -1;

    public SOAPXMLStream() {
    }

    public SOAPXMLStream(XMLParser parent) {
        this.xmlparser = parent;
    }

    public void reuse() {
        this.pos = 0;
        this.ext = this.DEFAULT_EXT;
        this.eos = false;
        this.restBytes = 0;
        this.totalRead = 0;
        this.iRow = 1;
        this.iCol = 1;
        this.bLiteral = false;
        this.bReadRaw = false;
    }

    public char read() throws Exception {
        if (this.restBytes == 0) {
            this.fetchData();
        }
        if (this.eos) {
            if (this.xmlparser != null) {
                this.xmlparser.onDocumentEOF();
            }
            return '\u0000';
        }
        --this.restBytes;
        this.lastchar = this.buf[this.pos];
        ++this.pos;
        return this.lastchar;
    }

    protected int readData(int off, int len) throws IOException {
        int bb = this.in.read(this.bytebuf, off, len - 6);
        if (bb == -1) {
            return -1;
        }
        int i = 0;
        int j = 0;
        char ch = '\u0000';
        byte x = 0;
        while (i < bb) {
            x = this.bytebuf[i];
            if (x < 0) {
                while ((ch = (char)encoding.process(this.bytebuf[i++])) == '\ufffe') {
                    if (i != bb) continue;
                    this.bytebuf[i] = (byte)this.in.read();
                    ++bb;
                }
                --i;
                if (ch == '\uffffffff') {
                    throw new UnsupportedEncodingException("XMLParser: Unsupported Character");
                }
                this.buf[j] = ch;
            } else {
                this.buf[j] = (char)x;
            }
            ++j;
            ++i;
        }
        return j;
    }

    protected int getBufLen() {
        return this.buf.length;
    }

    public void setLastChar(int value) {
        this.lastchar = (char)value;
    }

    public char getLastChar() {
        return this.lastchar;
    }

    protected void fetchData() throws Exception {
        this.pos = 0;
        this.a1 = this.getBufLen() - this.pos;
        this.a2 = this.readData(this.pos, this.a1);
        if (this.a2 == -1) {
            this.eos = true;
            this.restBytes = 0;
        } else {
            this.restBytes = this.a2;
        }
    }

    public int getRow() {
        return this.iRow;
    }

    public int getCol() {
        return this.iCol;
    }

    public CharArray getID() {
        return this.id;
    }

    public int getRestBytes() {
        return this.restBytes;
    }

    public boolean getLiteral() {
        return this.bLiteral;
    }

    public void setLiteral(boolean value) {
        this.bLiteral = value;
    }

    public boolean isFinished() {
        return this.eos && this.restBytes <= 0;
    }

    public InputStream getInputStream() {
        return null;
    }

    public int getSID() {
        return this.sid;
    }

    public void setSID(int i) {
        this.sid = i;
    }

    public void setReadRaw(boolean b) {
        this.bReadRaw = b;
    }

    public void setName(CharArray name) {
        this.name = name.copy();
    }

    public CharArray getName() {
        return this.name;
    }

    public void setEncoding(CharArray enc) {
    }

    public boolean scanByte(char b) throws Exception {
        if (this.lastchar == b) {
            this.read();
            return true;
        }
        return false;
    }

    public boolean scanChars(char[] b) throws Exception {
        int l = b.length;
        if (l > 0 && b[0] != this.getLastChar()) {
            return false;
        }
        int i = 1;
        while (i < l) {
            if (b[i] != this.read()) {
                return false;
            }
            ++i;
        }
        this.read();
        return true;
    }

    public boolean scanString(String b) throws Exception {
        int l = b.length();
        if (l > 0 && b.charAt(0) != this.getLastChar()) {
            return false;
        }
        int i = 1;
        while (i < l) {
            if (b.charAt(i) != this.read()) {
                return false;
            }
            ++i;
        }
        this.read();
        return true;
    }

    public void addInputFromInputStream(InputStream in, CharArray id) throws Exception {
        this.reuse();
        this.in = in;
        if (this.buf == null) {
            this.buf = new char[this.DEFAULT_EXT];
            this.bytebuf = new byte[this.DEFAULT_EXT];
        }
        this.ext = this.DEFAULT_EXT;
        this.id = id;
        this.eos = false;
        this.read();
    }

    public void addInputSource(InputSource src) throws Exception {
        throw new Exception("not Supported");
    }

    public void addInputSource(InputSource src, CharArray id) throws Exception {
        throw new Exception("not Supported");
    }

    public void addInputFromCharArray(CharArray src, CharArray id) throws Exception {
        throw new Exception("not Supported");
    }

    public void addInputFromReader(Reader reader, CharArray id) throws Exception {
        throw new Exception("not Supported");
    }

    public void addInputFromEntity(Entity ent) throws Exception {
        throw new Exception("not Supported");
    }

    public int getSourceID() {
        return 1;
    }

    public boolean isFinished(int a) {
        return false;
    }

    public void clearFinished(int a) {
    }

    public void scanCharData(CharArray carr) throws Exception {
        char cs = this.getLastChar();
        carr.clear();
        switch (cs) {
            case '&': 
            case '<': {
                return;
            }
        }
        carr.append(cs);
        do {
            if (this.restBytes == 0) {
                this.fetchData();
            }
            if (this.eos) {
                if (this.xmlparser != null) {
                    this.xmlparser.onDocumentEOF();
                }
                return;
            }
            --this.restBytes;
            cs = this.buf[this.pos++];
            carr.append(cs);
        } while (cs != '<' && cs != '&');
        this.lastchar = cs;
        carr.setSize(carr.getSize() - 1);
    }

    public int scanName(CharArray chr) throws Exception {
        do {
            this.colonChar = -1;
            if (this.restBytes == 0) {
                this.fetchData();
            }
            if (this.eos) {
                return this.colonChar;
            }
            --this.restBytes;
            this.ch = this.buf[this.pos++];
            if (this.ch == ':') {
                this.colonChar = chr.length();
            }
            chr.append(this.ch);
        } while (Symbols.isLetterOrDigit(this.ch) || this.ch == '_' || this.ch == ':' || this.ch == '.' || this.ch == '-' || this.ch == '|');
        this.lastchar = this.ch;
        chr.setSize(chr.getSize() - 1);
        return this.colonChar;
    }
}

