/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.parser.readers;

import com.inqmy.lib.xml.parser.helpers.AdvancedXMLStreamReader;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import com.inqmy.lib.xml.parser.readers.InputSource;
import java.io.IOException;

public final class CharArrayReader
extends InputSource {
    private char[] buf = null;

    public CharArrayReader() {
    }

    public CharArrayReader(AdvancedXMLStreamReader parent, CharArray src, CharArray id) {
        this.reuse(parent, src, id);
    }

    public CharArrayReader reuse(AdvancedXMLStreamReader parent, CharArray src, CharArray id) {
        super.reuse();
        this.parent = parent;
        this.buf = src.getData();
        this.id = id;
        this.restBytes = src.getSize();
        this.eos = true;
        this.iRow = 1;
        this.iCol = 1;
        this.pos = src.getOffset();
        return this;
    }

    public char read() throws Exception {
        if (this.eos) {
            if (this.restBytes <= 0) {
                this.parent.onEncodedDataReaderEOF();
                return '\u0000';
            }
            --this.restBytes;
        }
        if (this.buf[this.pos] == '\n') {
            ++this.iRow;
            this.iCol = 1;
        } else if (this.buf[this.pos] != '\r') {
            ++this.iCol;
        }
        return this.buf[this.pos++];
    }

    protected void resizeBuffer() {
    }

    protected int readData(int off, int len) throws IOException {
        return 0;
    }

    protected void moveData(int offsetStart, int offsetEnd, int size) throws Exception {
    }

    protected int getBufLen() {
        return this.buf.length;
    }
}

