/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.parser.handlers;

import com.inqmy.lib.xml.parser.XMLParser;
import com.inqmy.lib.xml.parser.XMLParserConstants;
import com.inqmy.lib.xml.parser.handlers.NamespaceEntry;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import com.inqmy.lib.xsl.xslt.NamespaceManager;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class NamespaceHandler {
    protected Vector ns = null;
    protected Hashtable hashns = null;
    protected final CharArray defaultPrefixName = new CharArray("<<<>>>");
    protected XMLParser parent = null;

    public NamespaceHandler(XMLParser parent) {
        this.ns = new Vector();
        this.hashns = new Hashtable();
        this.parent = parent;
        this.add(XMLParserConstants.crXML, XMLParserConstants.caXMLNamespace);
        this.add(XMLParserConstants.caXMLNS, XMLParserConstants.crXMLNSNamespace);
        this.levelUp();
        this.levelUp();
    }

    public NamespaceHandler reuse(XMLParser parent) {
        this.ns.clear();
        this.hashns.clear();
        this.parent = parent;
        this.add(XMLParserConstants.crXML, XMLParserConstants.caXMLNamespace);
        this.add(XMLParserConstants.caXMLNS, XMLParserConstants.crXMLNSNamespace);
        this.levelUp();
        this.levelUp();
        return this;
    }

    public void print() {
        ((NamespaceEntry)this.hashns.get(this.defaultPrefixName)).print();
    }

    public void addDefault(CharArray uri) {
        this.add(this.defaultPrefixName, uri.copy());
    }

    public CharArray getDefault() {
        return this.get(this.defaultPrefixName);
    }

    public CharArray get(CharArray prefix) {
        if (prefix == null || prefix.length() == 0) {
            return this.getDefault();
        }
        NamespaceEntry ne = (NamespaceEntry)this.hashns.get(prefix);
        return ne != null ? ne.getUri() : CharArray.EMPTY;
    }

    public CharArray getAttr(CharArray prefix) {
        NamespaceEntry ne = (NamespaceEntry)this.hashns.get(prefix);
        return ne != null ? ne.getUri() : CharArray.EMPTY;
    }

    public void add(String prefix, String uri) {
        this.add(new CharArray(prefix), new CharArray(uri));
    }

    public void add(CharArray prefix, CharArray uri) {
        NamespaceEntry ne;
        NamespaceEntry neout;
        if (!prefix.getStatic()) {
            prefix = prefix.copy();
        }
        if (!uri.getStatic()) {
            uri = uri.copy();
        }
        if ((neout = this.hashns.put(prefix, ne = new NamespaceEntry(prefix, uri))) != null) {
            // empty if block
        }
        if (neout != null) {
            ne.setPrevNamespace(neout);
            this.ns.removeElement(neout);
        }
        this.ns.add(ne);
    }

    public void levelUp() {
        int i = 0;
        while (i < this.ns.size()) {
            ((NamespaceEntry)this.ns.get(i)).levelUp();
            ++i;
        }
    }

    public void levelDown() throws Exception {
        int i = 0;
        while (i < this.ns.size()) {
            NamespaceEntry nsent = (NamespaceEntry)this.ns.get(i);
            boolean changedMapping = nsent.levelDown();
            if (this.parent != null && changedMapping) {
                this.parent.changingMapping(nsent.getPrefix(), nsent.getUri());
            }
            if (!((NamespaceEntry)this.ns.get(i)).isValid()) {
                CharArray pref;
                CharArray pref2 = pref = ((NamespaceEntry)this.ns.get(i)).getPrefix();
                if (pref.equals(this.defaultPrefixName)) {
                    pref2 = CharArray.EMPTY;
                }
                if (this.parent != null) {
                    this.parent.endPrefixMapping(pref2);
                }
                this.hashns.remove(pref);
                this.ns.removeElementAt(i);
                --i;
            }
            ++i;
        }
    }

    public void findNamespaceNodes(Element el, NamespaceManager nsmanager) {
        NamedNodeMap nm = el.getAttributes();
        int i = 0;
        while (i < nm.getLength()) {
            Attr attr = (Attr)nm.item(i);
            if (attr.getPrefix() != null) {
                if (attr.getPrefix().equals("xmlns")) {
                    this.add(new CharArray(attr.getLocalName()), new CharArray(attr.getValue()));
                    if (nsmanager != null) {
                        nsmanager.put(attr.getValue());
                    }
                } else if (attr.getPrefix().length() == 0 && attr.getLocalName().equals("xmlns")) {
                    this.addDefault(new CharArray(attr.getValue()));
                    if (nsmanager != null) {
                        nsmanager.put(attr.getValue());
                    }
                }
            }
            ++i;
        }
    }

    public boolean isMapped(CharArray prefix) {
        if (prefix != null && prefix.length() > 0 && !prefix.equals("xmlns")) {
            return (NamespaceEntry)this.hashns.get(prefix) != null;
        }
        return true;
    }
}

