/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml;

import com.inqmy.lib.xml.StandardDOMParser;
import com.inqmy.lib.xml.parser.DOMParser;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StandardDOMWriterOpt {
    private BufferedOutputStream out = null;
    private FileWriter fileWriter = null;
    private String dtd;
    private boolean canonical = false;
    private int counter = 0;
    private static int NL = 10;

    public StandardDOMWriterOpt() {
    }

    public StandardDOMWriterOpt(boolean _canonical) {
        this.canonical = _canonical;
    }

    private void print(Node node, String dest) throws IOException {
        this.out = new BufferedOutputStream(new FileOutputStream(dest));
        this.print(node);
        this.out.close();
    }

    private void writeOut(String s) throws IOException {
        int i = 0;
        int l = s.length();
        while (i < l) {
            this.writeOut((byte)s.charAt(i));
            ++i;
        }
    }

    private void writeOut(char ch) throws IOException {
        this.writeOut((byte)ch);
    }

    private void writeOut(byte ch) throws IOException {
        this.writeOut((int)ch);
    }

    private void writeOut(int ch) throws IOException {
        if (this.out != null) {
            this.out.write(ch);
        } else if (this.fileWriter != null) {
            this.fileWriter.write(ch);
        }
    }

    private void print(Node node) throws IOException {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                if (!this.canonical) {
                    this.writeOut("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                    this.writeOut(10);
                    if (this.dtd != null) {
                        this.writeOut(this.dtd);
                        this.writeOut(NL);
                    }
                }
                this.print(((Document)node).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                this.writeOut(NL);
                ++this.counter;
                this.addEmptySpace(this.out, this.counter);
                this.writeOut('<');
                this.writeOut(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                Attr attr = null;
                int i = 0;
                while (i < attrs.length) {
                    attr = attrs[i];
                    this.writeOut(' ');
                    this.writeOut(attr.getNodeName());
                    this.writeOut("=\"");
                    this.normalize(attr.getNodeValue());
                    this.writeOut('\"');
                    ++i;
                }
                this.writeOut('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                int i2 = 0;
                while (i2 < len) {
                    this.print(children.item(i2));
                    ++i2;
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    int i = 0;
                    while (i < len) {
                        this.print(children.item(i));
                        ++i;
                    }
                    break;
                }
                this.writeOut('&');
                this.writeOut(node.getNodeName());
                this.writeOut(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    this.normalize(node.getNodeValue());
                    break;
                }
                this.writeOut("<![CDATA[");
                this.writeOut(node.getNodeValue());
                this.writeOut("]]>");
                break;
            }
            case 3: {
                if (StandardDOMParser.isWhiteSpace(node.getNodeValue())) break;
                this.writeOut(NL);
                ++this.counter;
                this.addEmptySpace(this.out, this.counter);
                this.normalize(node.getNodeValue().trim());
                --this.counter;
                break;
            }
            case 7: {
                this.writeOut("<?");
                this.writeOut(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.writeOut(' ');
                    this.writeOut(data);
                }
                this.writeOut("?>");
                break;
            }
        }
        if (type == 1) {
            this.writeOut(NL);
            this.addEmptySpace(this.out, this.counter);
            this.writeOut("</");
            this.writeOut(node.getNodeName());
            this.writeOut('>');
            --this.counter;
        }
    }

    private void addEmptySpace(OutputStream out, int counter) throws IOException {
        int i = 0;
        while (i < counter) {
            this.writeOut(' ');
            this.writeOut(' ');
            ++i;
        }
    }

    public void write(Document doc, String dest, String _dtd) throws IOException {
        this.dtd = _dtd;
        this.counter = 0;
        this.out = null;
        this.fileWriter = null;
        this.print(doc, dest);
        this.out.close();
        this.dtd = null;
    }

    public void write(Document doc, OutputStream stream, String _dtd) throws IOException {
        this.dtd = _dtd;
        this.counter = 0;
        this.out = new BufferedOutputStream(stream);
        this.fileWriter = null;
        this.print(doc);
        this.dtd = null;
    }

    public void write(Document doc, FileWriter fw, String _dtd) throws IOException {
        this.dtd = _dtd;
        this.fileWriter = fw;
        this.out = null;
        this.counter = 0;
        this.print(doc);
        this.dtd = null;
    }

    protected void normalize(String s) throws IOException {
        int len = s != null ? s.length() : 0;
        char ch = '\u0000';
        int i = 0;
        while (i < len) {
            ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    this.writeOut("&lt;");
                    break;
                }
                case '>': {
                    this.writeOut("&gt;");
                    break;
                }
                case '&': {
                    this.writeOut("&amp;");
                    break;
                }
                case '\"': {
                    this.writeOut("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        this.writeOut("&#");
                        this.writeOut(Integer.toString(ch));
                        this.writeOut(';');
                        break;
                    }
                }
                default: {
                    this.writeOut((int)ch);
                }
            }
            ++i;
        }
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        String name = null;
        int index = -1;
        String curName = null;
        int i2 = 0;
        while (i2 < len - 1) {
            name = array[i2].getNodeName();
            index = i2;
            int j = i2 + 1;
            while (j < len) {
                curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i2) {
                Attr temp = array[i2];
                array[i2] = array[index];
                array[index] = temp;
            }
            ++i2;
        }
        return array;
    }

    public static void main(String[] args) {
        try {
            DOMParser parser = new DOMParser();
            String pp = "d:/develop/xml2000/tests/xsltmark2/testcases/brutal.xsl";
            String ppout = pp + ".out";
            Document doc = parser.parse(pp);
            StandardDOMWriterOpt wr = new StandardDOMWriterOpt();
            int iter = 500;
            long a = System.currentTimeMillis();
            int i = 0;
            while (i < iter) {
                wr.write(doc, ppout, "");
                ++i;
            }
            long b = System.currentTimeMillis() - a;
            System.out.println(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

