/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StandardDOMWriterNoSpace {
    private PrintWriter out;
    private String dtd;
    private boolean canonical = false;
    private int counter = 0;

    public StandardDOMWriterNoSpace() {
    }

    public StandardDOMWriterNoSpace(boolean _canonical) {
        this.canonical = _canonical;
    }

    private void print(Node node, String dest) throws IOException {
        this.out = new PrintWriter(new FileWriter(dest));
        this.print(node);
        this.out.close();
    }

    private void print(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                if (!this.canonical) {
                    this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                    if (this.dtd != null) {
                        this.out.println(this.dtd);
                    }
                }
                this.print(((Document)node).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                this.out.println();
                ++this.counter;
                this.out.print(this.addEmptySpace(this.counter));
                this.out.print('<');
                this.out.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                Attr attr = null;
                int i = 0;
                while (i < attrs.length) {
                    attr = attrs[i];
                    this.out.print(' ');
                    this.out.print(attr.getNodeName());
                    this.out.print("=\"");
                    this.out.print(this.normalize(attr.getNodeValue()));
                    this.out.print('\"');
                    ++i;
                }
                this.out.print('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                int i2 = 0;
                while (i2 < len) {
                    this.print(children.item(i2));
                    ++i2;
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    int i = 0;
                    while (i < len) {
                        this.print(children.item(i));
                        ++i;
                    }
                    break;
                }
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    this.out.print(this.normalize(node.getNodeValue()));
                    break;
                }
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                if (node.getNodeValue().trim().equals("")) break;
                this.out.print(this.normalize(node.getNodeValue().trim()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.out.print(' ');
                    this.out.print(data);
                }
                this.out.print("?>");
                break;
            }
        }
        if (type == 1) {
            this.out.print("</");
            this.out.print(node.getNodeName());
            this.out.print('>');
            --this.counter;
        }
        this.out.flush();
    }

    private String addEmptySpace(int counter) {
        String s = "";
        int i = 0;
        while (i < counter) {
            s = s + "  ";
            ++i;
        }
        return s;
    }

    public void write(Document doc, String dest, String _dtd) throws IOException {
        this.dtd = _dtd;
        this.counter = 0;
        this.print(doc, dest);
        this.out.close();
        this.dtd = null;
    }

    public void write(Document doc, FileWriter fw, String _dtd) {
        this.dtd = _dtd;
        this.out = new PrintWriter(fw);
        this.counter = 0;
        this.print(doc);
        this.out.close();
        this.dtd = null;
    }

    protected String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        char ch = '\u0000';
        int i = 0;
        while (i < len) {
            ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        break;
                    }
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        String name = null;
        int index = -1;
        String curName = null;
        int i2 = 0;
        while (i2 < len - 1) {
            name = array[i2].getNodeName();
            index = i2;
            int j = i2 + 1;
            while (j < len) {
                curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i2) {
                Attr temp = array[i2];
                array[i2] = array[index];
                array[index] = temp;
            }
            ++i2;
        }
        return array;
    }
}

