/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml;

import com.inqmy.lib.xml.StandardDOMParserWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class StandardDOMParser
implements StandardDOMParserWrapper,
ErrorHandler {
    DocumentBuilderFactory factory = null;
    DocumentBuilder builder = null;
    public static final String INQMY_PARSER = "server.parser.inqmy";

    public StandardDOMParser() {
        try {
            if (System.getProperty(INQMY_PARSER) != null) {
                try {
                    this.factory = (DocumentBuilderFactory)Class.forName("com.inqmy.lib.jaxp.DocumentBuilderFactoryImpl").newInstance();
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter((Writer)sw, true);
                    e.printStackTrace(pw);
                    String msg = sw.toString();
                    pw.close();
                    throw new RuntimeException(msg);
                }
            } else {
                this.factory = DocumentBuilderFactory.newInstance();
            }
            this.builder = this.factory.newDocumentBuilder();
            this.setValidation(false);
            this.setReadDTD(false);
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            e.printStackTrace(pw);
            String msg = sw.toString();
            pw.close();
            throw new RuntimeException(msg);
        }
    }

    public static void trimWhiteSpaces(Node node) {
        block4: {
            block5: {
                block3: {
                    if (!(node instanceof Document)) break block3;
                    StandardDOMParser.trimWhiteSpaces(((Document)node).getDocumentElement());
                    break block4;
                }
                if (!(node instanceof Element)) break block5;
                NodeList nl = ((Element)node).getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    StandardDOMParser.trimWhiteSpaces(nl.item(i));
                    ++i;
                }
                break block4;
            }
            if (!(node instanceof Text)) break block4;
            Text tx = (Text)node;
            try {
                tx.setData(StandardDOMParser.trimWhiteSpace(tx.getData()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Document parse(String uri) throws SAXException, IOException {
        return this.parse(new InputSource(uri));
    }

    public Document parse(InputStream is) throws SAXException, IOException {
        return this.parse(new InputSource(is));
    }

    public Document parse(InputSource is) throws SAXException, IOException {
        Document doc = null;
        try {
            doc = this.builder.parse(is);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SAXException(ex.getMessage());
        }
        doc.normalize();
        StandardDOMParser.trimWhiteSpaces(doc);
        return doc;
    }

    public void warning(SAXParseException ex) {
    }

    public void error(SAXParseException ex) {
    }

    public void fatalError(SAXParseException ex) throws SAXException {
    }

    public void setValidation(boolean value) throws SAXException {
        try {
            this.factory.setValidating(value);
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public void setFeature(String feature, boolean value) throws SAXException {
        try {
            if (feature.equals("http://xml.org/sax/features/namespaces")) {
                this.setNamespaces(value);
            } else if (feature.equals("http://xml.org/sax/features/validation")) {
                this.setValidation(value);
            } else if (feature.equals("http://inqmy.org/dom/features/trim-white-spaces")) {
                if (this.factory.getClass().getName().equals("com.inqmy.lib.jaxp.DocumentBuilderFactoryImpl")) {
                    this.factory.setAttribute(feature, new Boolean(value));
                }
            } else if (feature.equals("http://apache.org/xml/features/nonvalidating/load-external-dtd")) {
                if (this.factory.getClass().getName().equals("org.apache.xerces.jaxp.DocumentBuilderFactoryImpl")) {
                    this.factory.setAttribute(feature, new Boolean(value));
                }
            } else if (feature.equals("http://inqmy.org/xml/features/close-streams")) {
                this.factory.setAttribute(feature, new Boolean(value));
            } else {
                throw new SAXNotSupportedException(feature);
            }
            try {
                this.builder = this.factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public void setNamespaces(boolean value) throws SAXException {
        try {
            this.factory.setNamespaceAware(value);
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public void setParserProxy(String host, int port) throws SAXException {
        this.setProperty("http://inqmy.org/sax/properties/proxy-host", host);
        this.setProperty("http://inqmy.org/sax/properties/proxy-port", new Integer(port));
    }

    public void setProperty(String property, Object data) throws SAXException {
        if (property.equals("http://xml.org/sax/features/namespaces")) {
            this.setNamespaces((Boolean)data);
        } else if (property.equals("http://xml.org/sax/features/validation")) {
            this.setValidation((Boolean)data);
        } else {
            throw new SAXNotSupportedException(property);
        }
        try {
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public void setParserAlternativeDTD(String uri) throws SAXException {
        this.setProperty("http://inqmy.org/sax/properties/alternative-dtd", uri);
    }

    public void setUseProxy(boolean value) throws SAXException {
        this.setFeature("http://inqmy.org/sax/features/use-proxy", value);
    }

    public void setReadDTD(boolean value) throws SAXException {
        this.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", value);
    }

    public void setCloseStreams(boolean value) throws SAXException {
        this.setFeature("http://inqmy.org/xml/features/close-streams", value);
    }

    public static Document createDocument() {
        try {
            DocumentBuilderFactory factory = null;
            if (System.getProperty(INQMY_PARSER) != null) {
                try {
                    factory = (DocumentBuilderFactory)Class.forName("com.inqmy.lib.jaxp.DocumentBuilderFactoryImpl").newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    factory = DocumentBuilderFactory.newInstance();
                }
            } else {
                factory = DocumentBuilderFactory.newInstance();
            }
            return factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Could not create a new Document. Exception: " + e);
        }
    }

    public static String trimWhiteSpace(String data) {
        if (data == null) {
            return "";
        }
        int b = 0;
        while (b < data.length() && StandardDOMParser.isWhiteSpaceChar(data.charAt(b))) {
            ++b;
        }
        int e = data.length() - 1;
        while (e > 0 && e > b && StandardDOMParser.isWhiteSpaceChar(data.charAt(e))) {
            --e;
        }
        data = data.substring(b, e + 1);
        return data;
    }

    public static boolean isWhiteSpace(String str) {
        if (str == null) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            if (!StandardDOMParser.isWhiteSpaceChar(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isWhiteSpaceChar(char ch) {
        return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t';
    }
}

