/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.validator;

import com.inqmy.lib.schema.SchemaException;
import com.inqmy.lib.schema.components.AttributeDeclaration;
import com.inqmy.lib.schema.components.AttributeUse;
import com.inqmy.lib.schema.components.Base;
import com.inqmy.lib.schema.components.ComplexTypeDefinition;
import com.inqmy.lib.schema.components.ElementDeclaration;
import com.inqmy.lib.schema.components.Facet;
import com.inqmy.lib.schema.components.FundamentalFacets;
import com.inqmy.lib.schema.components.Schema;
import com.inqmy.lib.schema.components.SimpleTypeDefinition;
import com.inqmy.lib.schema.components.TypeDefinitionBase;
import com.inqmy.lib.schema.components.Wildcard;
import com.inqmy.lib.schema.components.impl0.LoaderImpl;
import com.inqmy.lib.schema.regular.RegularExpression;
import com.inqmy.lib.schema.regular.RegularExpressionException;
import com.inqmy.lib.schema.validator.ComplexTypeDisperser;
import com.inqmy.lib.schema.validator.DisperserChildMappingStructure;
import com.inqmy.lib.schema.validator.SchemaValidationException;
import com.inqmy.lib.xml.dom.DOM;
import com.inqmy.lib.xml.parser.ActiveXMLParser;
import com.inqmy.lib.xml.parser.DocHandler;
import com.inqmy.lib.xml.parser.ParserException;
import com.inqmy.lib.xml.parser.SystemProperties;
import com.inqmy.lib.xml.parser.XMLParser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Validator {
    private Hashtable regularExpressionsMapping = new Hashtable();
    private Hashtable dispersersMapping = new Hashtable();
    private Vector validationErrorsCollector = new Vector();
    private XMLParser xmlParser = null;
    private DocHandler docHandler = null;
    private String[] externalSchemaLocations = null;
    private String[] externalSchemaNamespaces = null;
    private String externalNoNamespaceSchemaLocation = null;
    static /* synthetic */ Class class$javax$xml$transform$TransformerFactory;
    static /* synthetic */ Class class$com$inqmy$lib$jaxp$TransformerFactoryImpl;

    public void setParser(XMLParser xmlParser) {
        this.xmlParser = xmlParser;
    }

    public void setDocHandler(DocHandler docHandler) {
        this.docHandler = docHandler;
    }

    public void setExternalSchemas(String[] namespaces, String[] locations) {
        this.externalSchemaLocations = locations;
        this.externalSchemaNamespaces = namespaces;
    }

    public void setExternalNoNamespaceSchema(String location) {
        this.externalNoNamespaceSchemaLocation = location;
    }

    private Schema extractSchema() throws SchemaException, ParserException {
        if (this.externalNoNamespaceSchemaLocation != null) {
            String[] locs = new String[this.externalSchemaLocations.length + 1];
            String[] namsps = new String[this.externalSchemaNamespaces.length + 1];
            System.arraycopy(this.externalSchemaLocations, 0, locs, 0, this.externalSchemaLocations.length);
            System.arraycopy(this.externalSchemaNamespaces, 0, namsps, 0, this.externalSchemaNamespaces.length);
            locs[locs.length - 1] = this.externalNoNamespaceSchemaLocation;
            namsps[namsps.length - 1] = null;
            this.externalSchemaLocations = locs;
            this.externalSchemaNamespaces = namsps;
        }
        Node[] nodes = Validator.retrieveNodes(this.externalSchemaNamespaces, this.externalSchemaLocations, this.xmlParser.getEntityResolver());
        Vector<Node> nonNullNodes = new Vector<Node>();
        Vector<String> nonNullLocations = new Vector<String>();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] != null) {
                nonNullNodes.add(nodes[i]);
                nonNullLocations.add(this.externalSchemaLocations[i]);
            }
            ++i;
        }
        Node[] convertedNodes = new Node[nonNullNodes.size()];
        String[] convertedLocations = new String[nonNullLocations.size()];
        int i2 = 0;
        while (i2 < nonNullNodes.size()) {
            convertedNodes[i2] = (Node)nonNullNodes.get(i2);
            convertedLocations[i2] = (String)nonNullLocations.get(i2);
            ++i2;
        }
        nodes = convertedNodes;
        this.externalSchemaLocations = convertedLocations;
        LoaderImpl loader = new LoaderImpl();
        loader.setEntityResolver(this.xmlParser.getEntityResolver());
        Schema schema = loader.load(this.externalSchemaLocations, nodes);
        return schema;
    }

    public boolean validate(InputStream xmlInputStream) throws SchemaException, ParserException {
        Schema schema = this.extractSchema();
        return this.validate(xmlInputStream, schema);
    }

    public boolean validate(InputSource xmlInputSource) throws SchemaException, ParserException {
        Schema schema = this.extractSchema();
        if (this.xmlParser.getActiveParse()) {
            this.xmlParser.finalizeActiveParse();
        }
        return this.validate(xmlInputSource, schema);
    }

    private static Node[] retrieveNodes(String[] namespaces, String[] locations, EntityResolver eres) throws SchemaException {
        Node[] nodes = new Node[locations.length + 1];
        if (namespaces.length != locations.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < locations.length) {
            StreamSource ss = null;
            try {
                InputSource is = eres.resolveEntity(null, locations[i]);
                if (is == null) {
                    throw new SAXException("Cannot resolve enitity " + locations[i] + ". If you are using a DefaultHandler, be sure to implement the resolveEntity(String publicId, String systemId) method.");
                }
                InputStream ins = is.getByteStream();
                Reader r = is.getCharacterStream();
                String sysId = is.getSystemId();
                if (ins != null) {
                    ss = new StreamSource(ins);
                }
                if (r != null) {
                    ss = new StreamSource(r);
                }
                if (sysId != null) {
                    ss = new StreamSource(sysId);
                }
                if (ss == null) {
                    throw new SAXException("Entity resolved to an InputSource, whose InputStream, CharacterStream and SystemId are all null.");
                }
            }
            catch (SAXException e) {
                throw new SchemaException(e);
            }
            catch (IOException e) {
                throw new SchemaException(e);
            }
            Node n = Validator.parseToDOM(ss);
            Hashtable mappings = DOM.getNamespaceMappingsInScope(n);
            String targetNamespace = ((Document)n).getDocumentElement().getAttribute("targetNamespace");
            if (!((targetNamespace == null || targetNamespace.equals("")) && namespaces[i] != null || namespaces[i] == null && targetNamespace != null && targetNamespace != "" || namespaces[i] != null && !namespaces[i].equals(targetNamespace))) {
                nodes[i] = n;
            }
            ++i;
        }
        return nodes;
    }

    public boolean validate(String xmlPath, String xsdPath) throws SchemaException, ParserException {
        FileInputStream xmlinputStream = null;
        try {
            xmlinputStream = new FileInputStream(xmlPath);
        }
        catch (FileNotFoundException fileNotFoundExc) {
            throw new IllegalArgumentException("File " + xmlPath + " does not exists.");
        }
        return this.validate((InputStream)xmlinputStream, xsdPath);
    }

    public boolean validate(InputStream xmlInputStream, String xsdPath) throws SchemaException, ParserException {
        if (xsdPath == null) {
            throw new IllegalArgumentException("xsdPath is null");
        }
        LoaderImpl loader = new LoaderImpl();
        Schema schema = loader.load(Validator.parseToDOM(new StreamSource(xsdPath)));
        return this.validate(xmlInputStream, schema);
    }

    public boolean validate(InputStream xmlInputStream, Schema schema) throws SchemaException, ParserException {
        if (schema == null) {
            throw new IllegalArgumentException();
        }
        ActiveXMLParser parser = new ActiveXMLParser(xmlInputStream);
        if (this.xmlParser != null) {
            parser.setParser(this.xmlParser);
        }
        if (this.docHandler != null) {
            parser.setDocHandler(this.docHandler);
        }
        parser.begin();
        boolean result = this.validate(parser, schema);
        return result;
    }

    public boolean validate(InputSource xmlInputSource, Schema schema) throws SchemaException, ParserException {
        if (schema == null) {
            throw new IllegalArgumentException();
        }
        ActiveXMLParser parser = new ActiveXMLParser(xmlInputSource);
        if (this.xmlParser != null) {
            parser.setParser(this.xmlParser);
        }
        if (this.docHandler != null) {
            parser.setDocHandler(this.docHandler);
        }
        parser.begin();
        boolean result = this.validate(parser, schema);
        return result;
    }

    private boolean validate(ActiveXMLParser parser, Schema schema) throws ParserException, SchemaException {
        int parseCode = -1;
        String xPath = "";
        String lastElementAndIndex = null;
        Stack<Base> elementDeclrStack = new Stack<Base>();
        Stack<ComplexTypeDisperser> dispersersStack = new Stack<ComplexTypeDisperser>();
        Vector<String> nillableElementsCollector = new Vector<String>();
        ComplexTypeDisperser disperser = null;
        Base base = null;
        while ((parseCode = parser.next()) != 6) {
            if (parseCode == 1) {
                String localName = parser.getLocalName();
                String uri = parser.getURI();
                if (lastElementAndIndex != null) {
                    StringTokenizer helperTokenizer = new StringTokenizer(lastElementAndIndex, "[]");
                    String lastElementName = helperTokenizer.nextToken();
                    if (lastElementName.equals(localName)) {
                        int index = Integer.parseInt(helperTokenizer.nextToken());
                        xPath = xPath + "/" + localName + "[" + (index + 1) + "]";
                    } else {
                        xPath = xPath + "/" + localName + "[1]";
                    }
                    lastElementAndIndex = null;
                } else {
                    xPath = xPath + "/" + localName + "[1]";
                }
                if (disperser == null) {
                    base = schema.getTopLevelElementDeclaration(uri, localName);
                    if (base == null) {
                        this.validationErrorsCollector.add("Doc element " + xPath + " is not declared in schema.");
                        return false;
                    }
                } else {
                    DisperserChildMappingStructure childMappingStr = disperser.switchState(uri, localName);
                    if (childMappingStr == null) {
                        this.validationErrorsCollector.add("Element " + xPath + " is not declared in schema.");
                        return false;
                    }
                    base = childMappingStr.getBase();
                }
                Base elementDeclr = null;
                if (base instanceof ElementDeclaration) {
                    elementDeclr = base;
                } else if (base instanceof Wildcard) {
                    boolean wildcardValidation = this.validateWildcard((Wildcard)base, uri);
                    if (!wildcardValidation) {
                        this.validationErrorsCollector.add("Wildcard associated with element " + xPath + " is not valid.");
                        return false;
                    }
                    elementDeclr = schema.getTopLevelElementDeclaration(uri, localName);
                    if (elementDeclr == null) {
                        this.validationErrorsCollector.add("Element " + xPath + " is not declared in schema");
                        return false;
                    }
                }
                TypeDefinitionBase typeDefBase = null;
                String[] xsiAttributes = this.checkForXsiAttributes(parser);
                TypeDefinitionBase typeDefinitionBase = typeDefBase = xsiAttributes[0] == null ? elementDeclr.getTypeDefinition() : schema.getTopLevelTypeDefinition(xsiAttributes[0], xsiAttributes[1]);
                if (typeDefBase == null) {
                    this.validationErrorsCollector.add("Element " + xPath + " has no top level type definition in schema.");
                    return false;
                }
                if (xsiAttributes[2] != null && xsiAttributes[2].equals("true")) {
                    nillableElementsCollector.add(xPath);
                }
                elementDeclrStack.push(elementDeclr);
                if (!(typeDefBase instanceof ComplexTypeDefinition)) continue;
                if (disperser != null) {
                    dispersersStack.push(disperser);
                }
                disperser = this.useDisperser((ComplexTypeDefinition)typeDefBase);
                boolean attributesValidation = this.validateAttributes((ComplexTypeDefinition)typeDefBase, parser, xPath);
                if (attributesValidation) continue;
                this.validationErrorsCollector.add("Attributes associated with element " + xPath + " are not valid.");
                return false;
            }
            if (parseCode != 2) continue;
            ElementDeclaration elementDeclr = (ElementDeclaration)elementDeclrStack.pop();
            TypeDefinitionBase typeDefBase = elementDeclr.getTypeDefinition();
            boolean hasAttribXsiNill = nillableElementsCollector.contains(xPath);
            if (hasAttribXsiNill) {
                nillableElementsCollector.remove(xPath);
            }
            if (typeDefBase instanceof SimpleTypeDefinition) {
                String elementValue = parser.getValue();
                if (elementDeclr.isNillable() && hasAttribXsiNill) {
                    if (!elementValue.equals("")) {
                        this.validationErrorsCollector.add("Element " + xPath + " is not valid with respect to it's nillable declaration.");
                        return false;
                    }
                } else {
                    boolean simpleTypeValidation = this.validateSimpleType((SimpleTypeDefinition)typeDefBase, elementValue, xPath);
                    if (!simpleTypeValidation) {
                        this.validationErrorsCollector.add("Element " + xPath + " is not valid with respect to it's simple type definition.");
                        return false;
                    }
                }
            } else {
                if (elementDeclr.isNillable() && hasAttribXsiNill) {
                    if (!disperser.isInStartingState()) {
                        this.validationErrorsCollector.add("Element " + xPath + " is not valid with respect to it's nillable declaration.");
                        return false;
                    }
                } else if (!disperser.isInFinalState()) {
                    this.validationErrorsCollector.add("Element " + xPath + " is not valid with respect to it's complex type definition.");
                    return false;
                }
                this.reuseDisperser((ComplexTypeDefinition)typeDefBase, disperser);
                if (!dispersersStack.empty()) {
                    disperser = (ComplexTypeDisperser)dispersersStack.pop();
                }
            }
            int index = xPath.lastIndexOf("/");
            lastElementAndIndex = xPath.substring(index + 1);
            xPath = xPath.substring(0, index);
        }
        return true;
    }

    private String[] checkForXsiAttributes(ActiveXMLParser parser) {
        String[] result = new String[3];
        Attributes attribs = parser.getAttributes();
        boolean detectAny = false;
        boolean detectNil = false;
        int attribsCount = attribs.getLength();
        int i = 0;
        while (i < attribsCount) {
            String localName = attribs.getLocalName(i);
            if (attribs.getURI(i).equals("http://www.w3.org/2001/XMLSchema-instance")) {
                String attribValue = attribs.getValue(i);
                if (localName.equals("any")) {
                    String uri;
                    String[] prefixAndType = this.getPrefixAndValue(attribValue);
                    String prefix = prefixAndType[0];
                    result[0] = prefix != null ? ((uri = parser.getURI(prefix)) == null ? "" : uri) : "";
                    result[1] = prefixAndType[1];
                    detectAny = true;
                    if (detectNil) {
                        break;
                    }
                } else if (localName.equals("nil")) {
                    result[2] = attribValue;
                    detectNil = true;
                    if (detectAny) break;
                }
            }
            ++i;
        }
        return result;
    }

    private String[] getPrefixAndValue(String value) {
        String[] result = new String[2];
        int index = value.indexOf(":");
        if (index >= 0) {
            result[0] = value.substring(0, index);
            result[1] = value.substring(index + 1);
        } else {
            result[1] = value;
        }
        return result;
    }

    private void reuseDisperser(ComplexTypeDefinition complexTypeDef, ComplexTypeDisperser disperser) {
        disperser.reset();
        this.dispersersMapping.put(complexTypeDef, disperser);
    }

    private ComplexTypeDisperser useDisperser(ComplexTypeDefinition complexTypeDef) {
        ComplexTypeDisperser disperser = null;
        if (this.dispersersMapping.containsKey(complexTypeDef)) {
            disperser = (ComplexTypeDisperser)this.dispersersMapping.get(complexTypeDef);
            this.dispersersMapping.remove(complexTypeDef);
        } else {
            disperser = new ComplexTypeDisperser(complexTypeDef);
        }
        return disperser;
    }

    private boolean validateSimpleType(SimpleTypeDefinition simpleTypeDef, String value, String xPath) throws SchemaException {
        boolean result = true;
        if (simpleTypeDef.isVarietyList()) {
            SimpleTypeDefinition listMememberTypeDef = simpleTypeDef.getItemTypeDefinition();
            StringTokenizer listMemebersTokenizer = new StringTokenizer(value, " ");
            while (listMemebersTokenizer.hasMoreElements()) {
                String listMemeberValue = listMemebersTokenizer.nextToken();
                result = this.validateSimpleType(listMememberTypeDef, listMemeberValue, xPath);
                if (result) continue;
                this.validationErrorsCollector.add("Value " + listMemeberValue + " associated with list type definition of element " + xPath + ", is not valid with respect to this list members simple type definition.");
                return false;
            }
        } else {
            if (simpleTypeDef.isVarietyUnion()) {
                Vector unionMemebersTypeDefCollector = new Vector();
                simpleTypeDef.getMemberTypeDefinitions(unionMemebersTypeDefCollector);
                int i = 0;
                while (i < unionMemebersTypeDefCollector.size()) {
                    SimpleTypeDefinition unionMemeberTypeDef = (SimpleTypeDefinition)unionMemebersTypeDefCollector.get(i);
                    result = this.validateSimpleType(unionMemeberTypeDef, value, xPath);
                    if (result) break;
                    ++i;
                }
                if (!result) {
                    this.validationErrorsCollector.add("Value " + value + " is not valid with respect to any simple type definition, associated with union type definitio of element " + xPath + ".");
                }
                return result;
            }
            if (simpleTypeDef.isVarietyAtomic()) {
                Object fundamentalFacetsParseObj = null;
                FundamentalFacets fundamentalFacets = simpleTypeDef.getFundamentalFacets();
                if (fundamentalFacets != null && (fundamentalFacetsParseObj = fundamentalFacets.parse(value)) == null) {
                    this.validationErrorsCollector.add("Value " + value + " of element " + xPath + " does not belong to lexical space of element simple type definition.");
                    return false;
                }
                Facet[] facets = simpleTypeDef.getFacetsArray();
                boolean patternPresent = false;
                boolean patternValidation = false;
                boolean enumerationPresent = false;
                boolean enumerationValidation = false;
                int i = 0;
                while (i < facets.length) {
                    Facet facet = facets[i];
                    String facetValue = facet.getValue();
                    String facetName = facet.getName();
                    if (facetName.equals("pattern")) {
                        if (!patternPresent) {
                            patternPresent = true;
                        }
                        boolean bl = patternValidation = patternValidation || this.validatePattern(facetValue, value);
                        if (!patternValidation) {
                            this.validationErrorsCollector.add("Facet pattern with value " + facetValue + " is not valid with respect to simple type definition of element " + xPath + ".");
                        }
                    } else if (facetName.equals("enumeration")) {
                        if (!patternPresent) {
                            enumerationPresent = true;
                        }
                        boolean bl = enumerationValidation = enumerationValidation || this.validateEnumeration(fundamentalFacets, facetValue, value);
                        if (!patternValidation) {
                            this.validationErrorsCollector.add("Facet enumeration with value " + facetValue + " is not valid with respect to simple type definition of element " + xPath + ".");
                        }
                    } else if (facetName.equals("length")) {
                        result = this.validateLength(fundamentalFacetsParseObj, simpleTypeDef.isVarietyList(), facetValue);
                        if (!result) {
                            this.validationErrorsCollector.add("Facet length with value " + facetValue + " which is associated with element " + xPath + " is not valid.");
                            return false;
                        }
                    } else if (facetName.equals("minLength")) {
                        result = this.validateMinLength(fundamentalFacetsParseObj, simpleTypeDef.isVarietyList(), facetValue);
                        if (!result) {
                            this.validationErrorsCollector.add("Facet minLength with value " + facetValue + " which is associated with element " + xPath + " is not valid.");
                            return false;
                        }
                    } else if (facetName.equals("maxLength")) {
                        result = this.validateMaxLength(fundamentalFacetsParseObj, simpleTypeDef.isVarietyList(), facetValue);
                        if (!result) {
                            this.validationErrorsCollector.add("Facet naxLength with value " + facetValue + " which is associated with element " + xPath + " is not valid.");
                            return false;
                        }
                    } else if (facetName.equals("minExclusive")) {
                        result = this.validateMinExclusive(fundamentalFacets, fundamentalFacetsParseObj, facetValue);
                        if (!result) {
                            this.validationErrorsCollector.add("Facet minExclusive with value " + facetValue + " which is associated with element " + xPath + " is not valid.");
                            return false;
                        }
                    } else if (facetName.equals("maxExclusive")) {
                        result = this.validateMaxExclusive(fundamentalFacets, fundamentalFacetsParseObj, facetValue);
                        if (!result) {
                            this.validationErrorsCollector.add("Facet maxLength with value " + facetValue + " which is associated with element " + xPath + " is not valid.");
                            return false;
                        }
                    } else if (facetName.equals("minInclusive")) {
                        result = this.validateMinInclusive(fundamentalFacets, fundamentalFacetsParseObj, facetValue);
                        if (!result) {
                            this.validationErrorsCollector.add("Facet minInclusive with value " + facetValue + " which is associated with element " + xPath + " is not valid.");
                            return false;
                        }
                    } else if (facetName.equals("maxInclusive")) {
                        result = this.validateMaxInclusive(fundamentalFacets, fundamentalFacetsParseObj, facetValue);
                        if (!result) {
                            this.validationErrorsCollector.add("Facet maxExclusive with value " + facetValue + " which is associated with element " + xPath + " is not valid.");
                            return false;
                        }
                    } else if (facetName.equals("totalDigits")) {
                        result = this.validateTotalDigits(facetValue, value);
                        if (!result) {
                            this.validationErrorsCollector.add("Facet totalDigits with value " + facetValue + " which is associated with element " + xPath + " is not valid.");
                            return false;
                        }
                    } else if (facetName.equals("fractionDigits")) {
                        result = this.validateFractionDigits();
                        if (!result) {
                            this.validationErrorsCollector.add("Facet fractionDigits with value " + facetValue + " which is associated with element " + xPath + " is not valid.");
                            return false;
                        }
                    } else if (facetName.equals("whitespace") && !(result = this.validateWhitespace())) {
                        this.validationErrorsCollector.add("Facet whitespace with value " + facetValue + " which is associated with element " + xPath + " is not valid.");
                        return false;
                    }
                    ++i;
                }
                result = !(!result || !patternValidation && patternPresent || !enumerationValidation && enumerationPresent);
            }
        }
        return result;
    }

    private boolean validatePattern(String regularExpression, String value) throws RegularExpressionException {
        return this.getRegularExpression(regularExpression).matches(value);
    }

    private RegularExpression getRegularExpression(String regularExpression) throws RegularExpressionException {
        RegularExpression result = (RegularExpression)this.regularExpressionsMapping.get(regularExpression);
        if (result == null) {
            result = new RegularExpression(regularExpression);
            this.regularExpressionsMapping.put(regularExpression, result);
        }
        return result;
    }

    private boolean validateEnumeration(FundamentalFacets fundamentalFacets, String enumerationValue, String value) {
        return fundamentalFacets.equal(fundamentalFacets.parse(enumerationValue), fundamentalFacets.parse(value));
    }

    private int getLengthDependingOnType(Object fundamentalFacetsParseObj, boolean isList) throws SchemaException {
        if (fundamentalFacetsParseObj instanceof byte[] || isList) {
            return ((byte[])fundamentalFacetsParseObj).length;
        }
        return fundamentalFacetsParseObj.toString().length();
    }

    private boolean validateLength(Object fundamentalFacetsParseObj, boolean isList, String facetValue) throws SchemaException {
        return this.getLengthDependingOnType(fundamentalFacetsParseObj, isList) == Integer.parseInt(facetValue);
    }

    private boolean validateMinLength(Object fundamentalFacetsParseObj, boolean isList, String facetValue) throws SchemaException {
        return this.getLengthDependingOnType(fundamentalFacetsParseObj, isList) >= Integer.parseInt(facetValue);
    }

    private boolean validateMaxLength(Object fundamentalFacetsParseObj, boolean isList, String facetValue) throws SchemaException {
        return this.getLengthDependingOnType(fundamentalFacetsParseObj, isList) <= Integer.parseInt(facetValue);
    }

    private boolean validateMinExclusive(FundamentalFacets fundamentalFacets, Object fundamentalFacetsParseObj, String facetValue) {
        if (fundamentalFacets.isNumeric()) {
            return fundamentalFacets.less(fundamentalFacetsParseObj, fundamentalFacets.parse(facetValue));
        }
        return true;
    }

    private boolean validateMaxExclusive(FundamentalFacets fundamentalFacets, Object fundamentalFacetsParseObj, String facetValue) {
        if (fundamentalFacets.isNumeric()) {
            return !fundamentalFacets.less(fundamentalFacetsParseObj, fundamentalFacets.parse(facetValue));
        }
        return true;
    }

    private boolean validateMinInclusive(FundamentalFacets fundamentalFacets, Object fundamentalFacetsParseObj, String facetValue) {
        if (fundamentalFacets.isNumeric()) {
            return fundamentalFacets.less(fundamentalFacetsParseObj, fundamentalFacets.parse(facetValue));
        }
        return true;
    }

    private boolean validateMaxInclusive(FundamentalFacets fundamentalFacets, Object fundamentalFacetsParseObj, String facetValue) {
        if (fundamentalFacets.isNumeric()) {
            return !fundamentalFacets.less(fundamentalFacetsParseObj, fundamentalFacets.parse(facetValue));
        }
        return true;
    }

    private boolean validateTotalDigits(String facetValue, String value) {
        int facetIntValue = Integer.parseInt(facetValue);
        int charCounter = 0;
        int valueLength = value.length();
        int i = 0;
        while (i < valueLength) {
            char ch = value.charAt(i);
            if (ch >= '0' && ch <= '9') {
                ++charCounter;
            }
            ++i;
        }
        return charCounter <= facetIntValue;
    }

    private boolean validateFractionDigits() {
        return true;
    }

    private boolean validateWhitespace() {
        return true;
    }

    private boolean validateAttributes(ComplexTypeDefinition complexTypeDef, ActiveXMLParser parser, String xPath) throws SchemaException {
        AttributeUse[] attribUses = complexTypeDef.getAttributeUsesArray();
        Attributes attribs = parser.getAttributes();
        int attribsCount = attribs.getLength();
        boolean[] processedAttribs = new boolean[attribsCount];
        int i = 0;
        while (i < attribUses.length) {
            AttributeUse attribUse = attribUses[i];
            AttributeDeclaration attribDeclr = attribUse.getAttributeDeclaration();
            String attribUri = attribDeclr.getTargetNamespace();
            String attribName = attribDeclr.getName();
            String attribXPath = xPath + "@" + attribName;
            int attribIndex = 0;
            while (attribIndex < attribsCount) {
                if (!processedAttribs[attribIndex]) {
                    String processingAttribUri = attribs.getURI(attribIndex);
                    String processingAttribName = attribs.getLocalName(attribIndex);
                    if (processingAttribUri.equals(attribUri) && processingAttribName.equals(attribName)) {
                        processedAttribs[attribIndex] = true;
                        boolean attribValidationResult = this.validateAttribute(attribDeclr, attribs.getValue(attribIndex), attribXPath);
                        if (attribValidationResult) break;
                        this.validationErrorsCollector.add("Attribute " + attribXPath + " is not valid.");
                        return false;
                    }
                }
                ++attribIndex;
            }
            if (attribIndex == attribsCount && attribUse.isRequired()) {
                this.validationErrorsCollector.add("Attribute " + attribXPath + " is declared as required, but not defined in xml.");
                return false;
            }
            ++i;
        }
        Wildcard attribWildcard = complexTypeDef.getAttributeWildcard();
        int i2 = 0;
        while (i2 < attribsCount) {
            String attribLocalName = attribs.getLocalName(i2);
            String attribXPath = xPath + "@" + attribLocalName;
            if (!processedAttribs[i2]) {
                if (!("http://www.w3.org/2001/XMLSchema-instance".equals(attribs.getURI(i2)) || attribs.getQName(i2).startsWith("xml") || attribLocalName.equals("type") || attribLocalName.equals("nil"))) {
                    if (attribWildcard == null) {
                        this.validationErrorsCollector.add("Attribute " + attribXPath + " is not declared in schema.");
                        return false;
                    }
                    boolean wildcardValidation = this.validateWildcard(attribWildcard, attribs.getURI(i2));
                    if (!wildcardValidation) {
                        this.validationErrorsCollector.add("Wildcard, associated with attribute " + attribXPath + ", is not valid.");
                        return false;
                    }
                }
                processedAttribs[i2] = true;
            }
            ++i2;
        }
        return true;
    }

    private boolean validateWildcard(Wildcard wildcard, String uri) {
        if (wildcard.isNamespaceConstraintAny()) {
            return true;
        }
        String constraintNegated = wildcard.getNamespaceConstraintNegated();
        if (constraintNegated != null) {
            if (uri.equals(constraintNegated)) {
                return false;
            }
            return uri.length() != 0;
        }
        String[] namespaceCostrMembers = wildcard.getNamespaceConstraintMembersAsArray();
        boolean uriBelongToCostrMembers = false;
        int i = 0;
        while (i < namespaceCostrMembers.length) {
            if (uri.equals(namespaceCostrMembers[i])) {
                uriBelongToCostrMembers = true;
                break;
            }
            ++i;
        }
        return uriBelongToCostrMembers;
    }

    private boolean validateAttribute(AttributeDeclaration attrDeclr, String value, String xPath) throws SchemaException, RegularExpressionException {
        if (attrDeclr == null) {
            this.validationErrorsCollector.add("Attribute " + xPath + " is not declared in schema.");
            return false;
        }
        SimpleTypeDefinition attributeTypeDef = (SimpleTypeDefinition)attrDeclr.getTypeDefinition();
        if (attributeTypeDef == null) {
            this.validationErrorsCollector.add("Simple type of attribute " + xPath + " is not defined in schema.");
            return false;
        }
        boolean typeValidationResult = this.validateSimpleType(attributeTypeDef, value, xPath);
        if (!typeValidationResult) {
            this.validationErrorsCollector.add("Attribute " + xPath + " is not valid with respect to it's simple type definition.");
            return false;
        }
        String valueConstraintFixed = attrDeclr.getValueConstraintFixed();
        if (valueConstraintFixed != null) {
            FundamentalFacets fundamentalFacets = attributeTypeDef.getFundamentalFacets();
            Object actualValue = fundamentalFacets.parse(value);
            Object fixedValue = fundamentalFacets.parse(valueConstraintFixed);
            if (actualValue == null || !fundamentalFacets.equal(actualValue, fixedValue)) {
                this.validationErrorsCollector.add("Attribute " + xPath + " is not valid with respect to it's fixed value " + valueConstraintFixed + ".");
                return false;
            }
        }
        return true;
    }

    public void displayErrors() {
        int i = 0;
        while (i < this.validationErrorsCollector.size()) {
            System.out.println("[Validation Error] : " + this.validationErrorsCollector.get(i));
            ++i;
        }
    }

    public String[] getErrors() {
        Object[] errors = new String[this.validationErrorsCollector.size()];
        this.validationErrorsCollector.copyInto(errors);
        return errors;
    }

    private static Node parseToDOM(Source source) throws SchemaException {
        if (source == null) {
            return null;
        }
        Transformer transformer = Validator.createTransformer();
        DOMResult result = new DOMResult();
        try {
            transformer.transform(source, result);
            return result.getNode();
        }
        catch (Exception e) {
            throw new SchemaValidationException(e);
        }
    }

    private static Transformer createTransformer() throws SchemaException {
        Transformer transformer = null;
        try {
            SystemProperties.setProperty((class$javax$xml$transform$TransformerFactory == null ? (class$javax$xml$transform$TransformerFactory = Validator.class$("javax.xml.transform.TransformerFactory")) : class$javax$xml$transform$TransformerFactory).getName(), (class$com$inqmy$lib$jaxp$TransformerFactoryImpl == null ? (class$com$inqmy$lib$jaxp$TransformerFactoryImpl = Validator.class$("com.inqmy.lib.jaxp.TransformerFactoryImpl")) : class$com$inqmy$lib$jaxp$TransformerFactoryImpl).getName());
            TransformerFactory tf = TransformerFactory.newInstance();
            transformer = tf.newTransformer();
        }
        catch (TransformerException te) {
            throw new SchemaException(te);
        }
        return transformer;
    }

    public static void main(String[] args) throws Exception {
        Validator validator = new Validator();
        System.out.println("Validation : " + validator.validate("D:/xml/examples/schema/n.xml", "d:/xml/examples/schema/n.xsd"));
        validator.displayErrors();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

