/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.validator;

import com.inqmy.lib.jaxp.TransformerFactoryImpl;
import com.inqmy.lib.schema.SchemaException;
import com.inqmy.lib.schema.components.Schema;
import com.inqmy.lib.schema.components.impl0.LoaderImpl;
import com.inqmy.lib.schema.validator.Contributions;
import com.inqmy.lib.schema.validator.PSVIItem;
import com.inqmy.lib.schema.validator.SchemaComponentConstraints;
import com.inqmy.lib.schema.validator.SchemaRepresentationConstraints;
import com.inqmy.lib.schema.validator.SchemaValidationException;
import com.inqmy.lib.schema.validator.ValidationRules;
import com.inqmy.lib.xml.dom.DOM;
import com.inqmy.lib.xml.parser.URLLoaderBase;
import com.inqmy.lib.xml.util.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class SchemaValidator {
    protected Schema schema;
    protected static final boolean DEBUG = false;
    protected SchemaComponentConstraints scc = new SchemaComponentConstraints(this);
    protected ValidationRules vr = new ValidationRules(this);
    protected SchemaRepresentationConstraints src;
    protected Contributions con = new Contributions(this);
    private LoaderImpl loader;
    private Transformer transformer;

    public boolean validate(Node xml) throws SchemaException {
        return this.validate(xml, (Node)null);
    }

    public boolean validate(String xmlFile, String xsdFile) throws SchemaException {
        return this.validate(new StreamSource(xmlFile), xsdFile == null ? null : new StreamSource(xsdFile));
    }

    public boolean validate(Source xmlSource, Source xsdSource) throws SchemaException {
        return this.validate(this.parseToDOM(xmlSource), this.parseToDOM(xsdSource));
    }

    public boolean validate(Node xml, Node xsd) throws SchemaException {
        Schema schema;
        Element xmlElement;
        if (xml == null) {
            throw new IllegalArgumentException();
        }
        if (xml instanceof Document) {
            xmlElement = ((Document)xml).getDocumentElement();
        } else if (xml instanceof Element) {
            xmlElement = (Element)xml;
        } else {
            throw new SchemaValidationException("Unable to perform validation, the XML instance Node must be either an Element or a Document");
        }
        if (this.loader == null) {
            this.loader = new LoaderImpl();
        }
        URL xmlLocation = DOM.getLocation(xml);
        if (xsd == null) {
            String[] associated = SchemaValidator.getAssociatedSchemaLocations(xmlElement);
            Node[] nodes = new Node[associated.length];
            if (this.loader.getEntityResolver() != null) {
                try {
                    InputSource ins = this.loader.getEntityResolver().resolveEntity("", xmlElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"));
                    StreamSource s = new StreamSource();
                    s.setSystemId(ins.getSystemId());
                    s.setInputStream(ins.getByteStream());
                    s.setReader(ins.getCharacterStream());
                    nodes[0] = this.parseToDOM(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                int i = 0;
                while (i < associated.length) {
                    try {
                        associated[i] = URLLoaderBase.fileOrURLToURL(xmlLocation, associated[i]).toExternalForm();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    nodes[i] = this.parseToDOM(new StreamSource(associated[i]));
                    ++i;
                }
            }
            schema = this.loader.load(associated, nodes);
        } else {
            schema = this.loader.load(xsd);
        }
        return this.validate(xml, schema);
    }

    public boolean validate(Node node, Schema schema) throws SchemaException {
        Element validationRoot;
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (schema == null) {
            return this.validate(node, (Node)null);
        }
        this.schema = schema;
        short t = node.getNodeType();
        if (t == 9) {
            validationRoot = ((Document)node).getDocumentElement();
        } else if (t == 1) {
            validationRoot = (Element)node;
        } else {
            throw new SchemaValidationException();
        }
        this.con.clear();
        this.vr.clear();
        return this.vr.cvcAssessElt(validationRoot, null, false, null);
    }

    public void getPSVIItems(Vector v) {
        this.con.getPSVIItems(v);
    }

    public String getDescriptionOfTheFirstError() {
        Vector psviItems = new Vector();
        this.getPSVIItems(psviItems);
        int n = psviItems.size();
        int i = 0;
        while (i < n) {
            PSVIItem item = (PSVIItem)psviItems.get(i);
            if (item.isErrorDescription()) {
                return item.getValue() + " " + DOM.toXPath(item.getLocation());
            }
            ++i;
        }
        return "";
    }

    private void ensureTransformer() throws SchemaException {
        if (this.transformer == null) {
            try {
                TransformerFactoryImpl tf = new TransformerFactoryImpl();
                this.transformer = ((TransformerFactory)tf).newTransformer();
            }
            catch (TransformerException te) {
                throw new SchemaException(te);
            }
        }
    }

    private Node parseToDOM(Source source) throws SchemaException {
        if (source == null) {
            return null;
        }
        this.ensureTransformer();
        DOMResult result = new DOMResult();
        try {
            this.transformer.transform(source, result);
            return result.getNode();
        }
        catch (Exception e) {
            throw new SchemaValidationException(e);
        }
    }

    public static String[] getAssociatedSchemaLocations(Element e) {
        if (e.hasAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation")) {
            String[] x = StringUtils.split(e.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"));
            if (x.length == 1) {
                return new String[]{x[0]};
            }
            int l = x.length / 2;
            String[] r = new String[l];
            int i = 0;
            while (i < l) {
                r[i] = x[2 * i + 1];
                ++i;
            }
            return r;
        }
        if (e.hasAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation")) {
            return new String[]{e.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation")};
        }
        return new String[0];
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setUriResolver(URIResolver uriResolver) {
        if (this.loader == null) {
            this.loader = new LoaderImpl();
        }
        this.loader.setUriResolver(uriResolver);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (this.loader == null) {
            this.loader = new LoaderImpl();
        }
        this.loader.setEntityResolver(entityResolver);
    }
}

