/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.validator;

import com.inqmy.lib.schema.components.AttributeDeclaration;
import com.inqmy.lib.schema.components.ElementDeclaration;
import com.inqmy.lib.schema.components.TypeDefinitionBase;
import com.inqmy.lib.schema.validator.PSVIItem;
import com.inqmy.lib.schema.validator.SchemaValidationException;
import com.inqmy.lib.schema.validator.SchemaValidator;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class Contributions {
    private static final boolean DEBUG = false;
    private SchemaValidator owner;
    private Vector psviItems;
    private int errorSuppressLevel;

    protected Contributions(SchemaValidator owner) {
        this.owner = owner;
        this.psviItems = new Vector();
    }

    protected void clear() {
        this.psviItems.clear();
        this.errorSuppressLevel = 0;
    }

    protected void getPSVIItems(Vector v) {
        v.addAll(this.psviItems);
    }

    private void add(Node l, String oc, String an, Object v) {
        this.psviItems.add(new PSVIItem(oc, an, l, v));
    }

    protected void suppressErrors() {
        ++this.errorSuppressLevel;
    }

    protected void unsuppressErrors() {
        --this.errorSuppressLevel;
    }

    protected void sicAOutcome(Attr a, Element validationContext, String validity, String validationAttempted, String schemaSpecified) throws SchemaValidationException {
        this.add(a, "sic-a-outcome", "[validation context]", validationContext);
        this.add(a, "sic-a-outcome", "[validity]", validity);
        this.add(a, "sic-a-outcome", "[validation attempted]", validationAttempted);
        this.add(a, "sic-a-outcome", "[schema specified]", schemaSpecified);
    }

    protected void sicAttrDecl(Attr a, AttributeDeclaration ad) throws SchemaValidationException {
    }

    protected void sicAttrDefault(Attr a, String defaultValue) throws SchemaValidationException {
    }

    protected void sicAttrErrorCode(Attr a, String errorCode, String errorDescription) throws SchemaValidationException {
        this.add(a, "sic-attr-error-code", "[schema error code]", errorCode);
        this.add(a, "sic-attr-error-code", "[inqmy schema error code desciption]", errorDescription);
    }

    protected void sicAttrType() throws SchemaValidationException {
    }

    protected void sicCTErrorCode() throws SchemaValidationException {
    }

    protected void sicEltDecl(Element e, ElementDeclaration ed, boolean nilled) throws SchemaValidationException {
        if (ed != null) {
            this.owner.con.add(e, "sic-elt-decl", "[element declaration]", ed);
        }
        this.owner.con.add(e, "sic-elt-decl", "[nil]", new Boolean(nilled));
    }

    protected void sicEltDefault(Element e, String defaultValue) throws SchemaValidationException {
        if (defaultValue == null) {
            this.owner.con.add(e, "sic-eltDefault", "[default value]", defaultValue);
            this.owner.con.add(e, "sic-eltDefault", "[schema specified]", "schema");
        } else {
            this.owner.con.add(e, "sic-eltDefault", "[schema specified]", "infoset");
        }
    }

    protected void sicEltErrorCode(Element e, String errorCode, String errorDescription) throws SchemaValidationException {
        this.add(e, "sic-elt-error-code", "[schema error code]", errorCode);
        this.add(e, "sic-elt-error-code", "[inqmy schema error code desciption]", errorDescription);
    }

    protected void sicEltType(Element e, String norm, TypeDefinitionBase td, TypeDefinitionBase mtd) throws SchemaValidationException {
        if (norm != null) {
            this.add(e, "sic-eltType", "[schema normalized value]", norm);
        }
        if (td != null) {
            String tdn;
            this.add(e, "sic-eltType", "[type definition]", td);
            this.add(e, "sic-eltType", "[type definition type]", td.getTypeOfComponent() == 2 ? "simple" : "complex");
            String tdns = td.getTargetNamespace();
            String string = tdns = tdns == null ? "" : tdns;
            if (tdns != null) {
                this.add(e, "sic-eltType", "[type definition namespace]", tdns);
            }
            if ((tdn = td.getName()) != null) {
                this.add(e, "sic-eltType", "[type definition name]", tdn);
            }
            this.add(e, "sic-eltType", "[type definition anonymous]", new Boolean(tdns.length() == 0 && tdn == null));
        }
        if (mtd != null) {
            String mtdn;
            this.add(e, "sic-eltType", "[member type definition]", mtd);
            String mtdns = mtd.getTargetNamespace();
            String string = mtdns = mtdns == null ? "" : mtdns;
            if (mtdns != null) {
                this.add(e, "sic-eltType", "[member type definition namespace]", mtdns);
            }
            if ((mtdn = mtd.getName()) != null) {
                this.add(e, "sic-eltType", "[member type definition name]", mtdn);
            }
            this.add(e, "sic-eltType", "[type definition anonymous]", new Boolean(mtdns.length() == 0 && mtdn == null));
        }
    }

    protected void sicEOutcome(Element e, Element eContext, String validity, String validationAttempted) throws SchemaValidationException {
        if (eContext != null) {
            this.add(e, "sic-e-outcome", "[validation context]", eContext);
        }
        if (validity != null) {
            this.add(e, "sic-e-outcome", "[validity]", validity);
        }
        if (validationAttempted != null) {
            this.add(e, "sic-e-outcome", "[validation attempted]", validationAttempted);
        }
    }

    protected void sicId() throws SchemaValidationException {
    }

    protected void sicKey() throws SchemaValidationException {
    }

    protected void sicNotationUsed() throws SchemaValidationException {
    }

    protected void sicSchema() throws SchemaValidationException {
    }

    protected void sicSTErrorCode(Node node, String errorCode, String errorDescription) throws SchemaValidationException {
        this.add(node, "sic-st-error-code", "[schema error code]", errorCode);
        this.add(node, "sic-st-error-code", "[inqmy schema error code desciption]", errorDescription);
    }

    protected void errorCode(Node node, String errorCode, String description) throws SchemaValidationException {
        short t = node.getNodeType();
        if (t == 1) {
            this.sicEltErrorCode((Element)node, errorCode, description);
        } else if (t == 2) {
            this.sicAttrErrorCode((Attr)node, errorCode, description);
        }
    }

    protected void inqmyTrace(String s) {
        this.add(null, "[inqmy trace]", "[inqmy trace]", s);
    }
}

