/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.util;

public class DateTimeDurationRepresentation {
    public static final byte DATE = 1;
    public static final byte TIME = 2;
    public static final byte DATETIME = 3;
    public static final byte DURATION = 4;
    public static final byte MINUTES = 2;
    public static final byte MIN_MINUTES = 2;
    public static final byte MAX_MINUTES = 3;
    public static final byte DAYS = 0;
    public static final byte MIN_DAYS = 0;
    public static final byte MAX_DAYS = 0;
    public static final int[] MONTHS_TO_MINIMUM_DAYS = new int[]{28, 59, 89, 120, 150, 181, 212, 242, 273, 303, 334, 365, 393, 424, 454, 485, 515, 546, 577, 607, 638, 668, 699, 730, 758, 789, 819, 850, 880, 911, 942, 972, 1003, 1033, 1064, 1095, 1124, 1155, 1185, 1216, 1246, 1277, 1308, 1338, 1369, 1399, 1430, 1461};
    public static final int[] MONTHS_TO_MAXIMUM_DAYS = new int[]{31, 62, 92, 123, 153, 184, 215, 245, 276, 306, 337, 366, 397, 428, 458, 489, 519, 550, 581, 611, 642, 672, 703, 731, 762, 793, 823, 854, 884, 915, 946, 976, 1007, 1037, 1068, 1096, 1127, 1158, 1188, 1219, 1249, 1280, 1311, 1341, 1372, 1402, 1433, 1461};
    public static final int[] MONTH_DAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public int[] representation = new int[4];
    public float seconds = 0.0f;
    public byte id = 0;
    public boolean hasgmt = false;

    public DateTimeDurationRepresentation() {
        int i = 0;
        while (i < 4) {
            this.representation[i] = 0;
            ++i;
        }
    }

    public void setDateDays(int year, int month, int day) {
    }

    public void setMaxDurationDays(int years, int months, int days) {
        this.representation[0] = (years * 12 + months) / 48 * 1461 + MONTHS_TO_MAXIMUM_DAYS[(years * 12 + months) % 48] + days;
    }

    public void setMinDurationDays(int years, int months, int days) {
        this.representation[1] = (years * 12 + months) / 48 * 1461 + MONTHS_TO_MINIMUM_DAYS[(years * 12 + months) % 48] + days;
    }

    public void setMinutes(int hours, int minutes, byte whichminutes) {
        this.representation[2 + whichminutes] = hours * 60 + minutes;
    }

    public void setDays(int year, int month, int day) {
        this.representation[0] = year < 0 ? year * 365 + year / 4 - year / 400 * 3 - year % 400 / 100 : (year - 1) * 365 + year / 4 - year / 400 * 3 - (year - 1) % 400 / 100;
        int i = 1;
        while (i < month) {
            this.representation[0] = this.representation[0] + this.retrieveMonthDays(year, month);
            ++i;
        }
        this.representation[0] = this.representation[0] + day;
    }

    private int retrieveMonthDays(int year, int month) {
        if (month == 2) {
            if (year % 4 == 0) {
                if (year % 100 == 0) {
                    if (year % 400 == 0) {
                        return 29;
                    }
                    return 28;
                }
                return 29;
            }
            return 28;
        }
        return MONTH_DAYS[month - 1];
    }

    /*
     * Unable to fully structure code
     */
    private void normalize() {
        switch (this.id) {
            case 1: {
                break;
            }
            case 4: {
                if (this.representation[0] <= 0) ** GOTO lbl20
                while (this.representation[2] > 1439) {
                    this.representation[2] = this.representation[2] - 1440;
                    this.representation[1] = this.representation[1] + 1;
                    this.representation[0] = this.representation[0] + 1;
                }
                while (this.representation[2] < 0) {
                    this.representation[2] = this.representation[2] + 1440;
                    this.representation[1] = this.representation[1] - 1;
                    this.representation[0] = this.representation[0] - 1;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    this.representation[2] = this.representation[2] + 1440;
                    this.representation[1] = this.representation[1] - 1;
                    this.representation[0] = this.representation[0] - 1;
lbl20:
                    // 2 sources

                    ** while (this.representation[2] < -1439)
                }
lbl21:
                // 2 sources

                while (this.representation[2] > 0) {
                    this.representation[2] = this.representation[2] - 1440;
                    this.representation[1] = this.representation[1] + 1;
                    this.representation[0] = this.representation[0] + 1;
                }
                break;
            }
            case 3: {
                while (this.representation[2] > 1439) {
                    this.representation[2] = this.representation[2] - 1440;
                    this.representation[1] = this.representation[1] + 1;
                }
                while (this.representation[2] < 0) {
                    this.representation[2] = this.representation[2] + 1440;
                    this.representation[1] = this.representation[1] - 1;
                }
                while (this.representation[3] > 1439) {
                    this.representation[3] = this.representation[3] - 1440;
                    this.representation[1] = this.representation[1] + 1;
                }
                while (this.representation[3] < 0) {
                    this.representation[3] = this.representation[3] + 1440;
                    this.representation[1] = this.representation[1] - 1;
                }
                break;
            }
        }
    }

    public boolean isGreaterThan(DateTimeDurationRepresentation d) {
        if (this.id == d.id) {
            switch (this.id) {
                case 1: {
                    if (this.representation[0] <= d.representation[0]) break;
                    return true;
                }
                case 2: {
                    if ((!this.hasgmt || !d.hasgmt) && (this.hasgmt || d.hasgmt) || this.representation[2] <= d.representation[2]) break;
                    return true;
                }
                case 3: {
                    if (this.representation[0] > d.representation[0]) {
                        return true;
                    }
                    if (this.representation[0] != this.representation[0] || this.representation[2] <= d.representation[3]) break;
                    return true;
                }
                case 4: {
                    if (this.representation[0] > d.representation[0]) {
                        return true;
                    }
                    if (this.representation[0] != this.representation[0] || this.representation[2] <= d.representation[2]) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isLessThan(DateTimeDurationRepresentation d) {
        if (this.id == d.id) {
            switch (this.id) {
                case 1: {
                    if (this.representation[0] >= d.representation[0]) break;
                    return true;
                }
                case 2: {
                    if ((!this.hasgmt || !d.hasgmt) && (this.hasgmt || d.hasgmt) || this.representation[2] >= d.representation[2]) break;
                    return true;
                }
                case 3: {
                    if (this.representation[0] < d.representation[0]) {
                        return true;
                    }
                    if (this.representation[0] != d.representation[0] || this.representation[3] >= d.representation[2]) break;
                    return true;
                }
                case 4: {
                    if (this.representation[0] < d.representation[0]) {
                        return true;
                    }
                    if (this.representation[0] != d.representation[0] || this.representation[2] >= d.representation[2]) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isEqualTo(DateTimeDurationRepresentation d) {
        if (this.id == d.id) {
            int i = 0;
            while (i < this.representation.length) {
                if (this.representation[i] != d.representation[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

