/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.regular;

import com.inqmy.lib.schema.regular.RegularExpressionCompiler;
import com.inqmy.lib.schema.regular.RegularExpressionDecompiler;
import com.inqmy.lib.schema.regular.RegularExpressionMachine;

public final class Tester {
    public static final boolean USE_DECOMPILER = false;
    public static final String[][] TESTS = new String[][]{{"a?(a|b)c", "ac", "yes"}, {"a?(a|b)c", "aabc", "no"}, {"a?(a|b)c", "bc", "yes"}, {"a?(a|b)c", "aac", "yes"}, {"a", "a", "yes"}, {"ab", "ab", "yes"}, {"a", "b", "no"}, {"(a)", "a", "yes"}, {"(a|b|c)", "a", "yes"}, {"(a|b|c)", "b", "yes"}, {"(a|b|c)", "c", "yes"}, {"(a|b|c)", "d", "no"}, {"(a|bc)", "a", "yes"}, {"(a|bc)", "bc", "yes"}, {"(a|bc)", "b", "no"}, {"((a|b|c)|(d|e|f)|(g|h|i))", "f", "yes"}, {"a*", "a", "yes"}, {"a*", "b", "no"}, {"a*", "aaaaaaaaa", "yes"}, {"a*", "aaaaab", "no"}, {"ab*c", "abbbbbbc", "yes"}, {"ab*c", "ac", "yes"}, {"ab*c", "abc", "yes"}, {"ab*c", "bc", "no"}, {"ab?c", "ac", "yes"}, {"ab?c", "abc", "yes"}, {"ab?c", "a", "no"}, {"a(bc)?d*", "a", "yes"}, {"a(bc)?d*", "abcd", "yes"}, {"a(bc)?d*", "addddddd", "yes"}, {"a(bc)?d*", "abcbc", "no"}, {"a(bc)?d*", "abc", "yes"}, {"a(bc)?d*", "abcddddddddddddd", "yes"}, {"a{3,5}", "aa", "no"}, {"a{3,5}", "aaa", "yes"}, {"a{3,5}", "aaaa", "yes"}, {"a{3,5}", "aaaaa", "yes"}, {"a{3,5}", "aaaaaa", "no"}, {"a{3}", "aa", "no"}, {"a{3}", "aaa", "yes"}, {"a{3}", "aaaa", "no"}, {"a{3,}", "aa", "no"}, {"a{3,}", "aaa", "yes"}, {"a{3,}", "aaaa", "yes"}, {"a{3,}", "aaaaa", "yes"}, {"a{3,}", "aaaaaa", "yes"}, {"a{3,}", "aaaaaaa", "yes"}, {"a{1,2}", "", "no"}, {"a{1,2}", "a", "yes"}, {"a{1,2}", "aa", "yes"}, {"a{1,2}", "aaa", "no"}, {"a?", "", "yes"}, {"a{0,1}", "", "yes"}, {"a{50,100}", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "no"}, {"a{50,100}", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "yes"}, {"a{50,100}", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "yes"}, {"a{50,100}", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "no"}, {"(a(b|d*c)){10,20}", "abacaddddcabababacaddddcabab", "yes"}, {"a?b?c?d?", "ad", "yes"}, {"a?b?c?d?", "", "yes"}, {"a?b?c?d?", "acbd", "no"}, {"a?b?c?d?", "abcd", "yes"}, {"a?b?c?d?", "abbcd", "no"}, {"a?b?c?d?", "d", "yes"}, {"a{0,0}", "a", "no"}, {"a{0,0}", "", "yes"}, {"\\.", ".", "yes"}, {".", "a", "yes"}, {".", "b", "yes"}, {".", ".", "yes"}, {"&#65;", "A", "yes"}, {"&#x41;", "A", "yes"}, {"x&#65;y", "xAy", "yes"}, {"x?A+z*", "xAAAAAAAAA", "yes"}, {"x?&#x41;+z*", "xAAAAAAAAA", "yes"}, {"a?b+c*", "abbbbc", "yes"}, {"\\p{isCherokee}", "1", "no"}, {"\\P{isCherokee}", "1", "yes"}, {"\\p{isCherokee}", "\u13ff", "yes"}, {"a?(a|b)c\\p{isCherokee}+a?(a|b)c", "abc\u13ff\u13ffabc", "yes"}};

    public static void main(String[] args) throws Exception {
        RegularExpressionCompiler compiler = new RegularExpressionCompiler();
        RegularExpressionDecompiler decompiler = new RegularExpressionDecompiler();
        RegularExpressionMachine machine = new RegularExpressionMachine();
        int nSuccessful = 0;
        int i = 0;
        while (i < TESTS.length) {
            try {
                char[] code = compiler.compile(TESTS[i][0]);
                boolean result = machine.process(code, TESTS[i][1]);
                System.out.print("TESTS[" + i + "] : ");
                if (result == TESTS[i][2].equals("yes")) {
                    System.out.print("OK (" + TESTS[i][2] + ")");
                    ++nSuccessful;
                } else {
                    System.out.print("ERROR, should be '" + TESTS[i][2] + "'");
                }
                System.out.println("    '" + TESTS[i][1] + "' against '" + TESTS[i][0] + "'");
            }
            catch (Exception e) {
                System.out.print("TESTS[" + i + "] : ");
                System.out.print("EXCEPTION, should be '" + TESTS[i][2] + "'");
                System.out.println("    '" + TESTS[i][1] + "' against '" + TESTS[i][0] + "'");
                e.printStackTrace();
                System.out.println(" pos() = " + compiler.pos());
                System.out.println("");
            }
            ++i;
        }
        System.out.println();
        System.out.println("Total:      " + TESTS.length);
        System.out.println("Successful: " + nSuccessful + " ( =" + 100 * nSuccessful / TESTS.length + "% )");
    }
}

