/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.regular;

import com.inqmy.lib.schema.regular.InstructionSet;
import com.inqmy.lib.schema.regular.RegularExpressionException;
import com.inqmy.lib.schema.regular.Tools;
import com.inqmy.lib.schema.regular.UnicodeDatabase;

public final class RegularExpressionCompiler
implements InstructionSet {
    private char[] codeStack = new char[10];
    private char[] expression = new char[20];
    private int pExpression;
    private int expressionLength;

    public char[] compile(String s) throws RegularExpressionException {
        this.expressionLength = s.length();
        this.expression = Tools.assertArrayLength(this.expression, this.expressionLength + 1);
        s.getChars(0, this.expressionLength, this.expression, 0);
        this.expression[this.expressionLength] = '\u0000';
        this.pExpression = 0;
        int q = this.scanExpression(0);
        this.assertCodeStackLength(q);
        this.codeStack[q] = 2;
        ++q;
        return this.codeStack;
    }

    private int scanExpression(int p) throws RegularExpressionException {
        int q;
        int r = q = this.scanBranch(p);
        while (this.expression[this.pExpression] == '|') {
            ++this.pExpression;
            this.insertInCodeStack(p, q, 2);
            this.assertCodeStackLength((q += 2) + 1);
            this.codeStack[p] = 5;
            this.codeStack[p + 1] = (char)(q - p + 2);
            r = this.scanBranch(q + 2);
            this.codeStack[q] = 3;
            this.codeStack[q + 1] = (char)(r - q);
            q = r;
        }
        return r;
    }

    private int scanBranch(int p) throws RegularExpressionException {
        int q = this.scanPiece(p);
        char ch = this.expression[this.pExpression];
        while (ch != ')' && ch != '|' && ch != '\u0000') {
            q = this.scanPiece(q);
            ch = this.expression[this.pExpression];
        }
        return q;
    }

    private int scanPiece(int p) throws RegularExpressionException {
        int q = this.scanAtom(p);
        char ch = this.expression[this.pExpression];
        if (ch == '*') {
            ++this.pExpression;
            q = this.makeBlockInfinite(p, q);
            return q;
        }
        if (ch == '?') {
            ++this.pExpression;
            q = this.makeBlockOptional(p, q);
            return q;
        }
        if (ch == '+') {
            ++this.pExpression;
            int q2 = this.makeBlockDuplicate(p, q);
            q = this.makeBlockInfinite(q, q2);
            return q;
        }
        if (ch == '{') {
            ++this.pExpression;
            int x = this.scanInt();
            if (x == -1) {
                throw new RegularExpressionException(this, "Digit expected.");
            }
            ch = this.expression[this.pExpression];
            if (ch == '}') {
                ++this.pExpression;
                q = this.makeBlockQuantified(p, q, x, x);
            } else if (ch == ',') {
                ++this.pExpression;
                int y = this.scanInt();
                q = this.makeBlockQuantified(p, q, x, y);
                ch = this.expression[this.pExpression];
                if (ch != '}') {
                    throw new RegularExpressionException(this, "'}' expected.");
                }
                ++this.pExpression;
            } else {
                throw new RegularExpressionException(this, "',' or '}' expected.");
            }
            return q;
        }
        return q;
    }

    private int scanAtom(int p) throws RegularExpressionException {
        char ch = this.expression[this.pExpression];
        if (ch == '(') {
            ++this.pExpression;
            int q = this.scanExpression(p);
            if (this.expression[this.pExpression] != ')') {
                throw new RegularExpressionException(this, "')' expected but '" + this.expression[this.pExpression] + "' found at position " + this.pExpression);
            }
            ++this.pExpression;
            return q;
        }
        if (ch == '&') {
            int x;
            if (this.expression[this.pExpression + 1] != '#') {
                throw new RegularExpressionException("'#' expected after '&', but '" + this.expression[this.pExpression + 1] + "' found.");
            }
            if (this.expression[this.pExpression + 2] == 'x') {
                this.pExpression += 3;
                x = this.scanIntHex();
            } else {
                this.pExpression += 2;
                x = this.scanInt();
            }
            if (this.expression[this.pExpression] != ';') {
                throw new RegularExpressionException("';' expected to close an xml character reference, but '" + this.expression[this.pExpression] + "' found.");
            }
            int q = this.makeCodeForSingleCharacter(p, (char)x);
            return q;
        }
        if (ch == '.') {
            int q = this.makeCodeForAnyCharacter(p);
            return q;
        }
        if (ch == '\\') {
            ++this.pExpression;
            int q = this.scanCharClassEsc(p);
            return q;
        }
        return this.makeCodeForSingleCharacter(p, ch);
    }

    private int scanCharClassEsc(int p) throws RegularExpressionException {
        char ch = this.expression[this.pExpression];
        if (ch == 'p') {
            ++this.pExpression;
            String propertyName = this.scanPropertyName();
            return this.makeCodeForProperty(p, propertyName, true);
        }
        if (ch == 'P') {
            ++this.pExpression;
            String propertyName = this.scanPropertyName();
            return this.makeCodeForProperty(p, propertyName, false);
        }
        int index = "nrt\\|.-^?*+{}()[]c".indexOf(ch);
        if (index == -1) {
            throw new RegularExpressionException(this, "Invalid escape character, '\\" + ch + "'.");
        }
        ch = "\n\r\t\\|.-^?*+{}()[]c".charAt(index);
        return this.makeCodeForSingleCharacter(p, ch);
    }

    private int makeCodeForAnyCharacter(int p) throws RegularExpressionException {
        this.assertCodeStackLength(p + 3);
        this.codeStack[p + 0] = 4;
        this.codeStack[p + 1] = 3;
        this.codeStack[p + 2] = '\u0001';
        ++this.pExpression;
        return p + 3;
    }

    private int makeCodeForSingleCharacter(int p, char ch) throws RegularExpressionException {
        this.assertCodeStackLength(p + 6);
        this.codeStack[p] = 7;
        this.codeStack[p + 1] = ch;
        this.codeStack[p + 2] = 5;
        this.codeStack[p + 3] = 4;
        this.codeStack[p + 4] = 3;
        this.codeStack[p + 5] = '\u0001';
        ++this.pExpression;
        return p + 6;
    }

    private int makeCodeForCharacterRange(int p, char ch0, char ch1, boolean inside) throws RegularExpressionException {
        this.assertCodeStackLength(p + 9);
        this.codeStack[p] = inside ? 13 : 12;
        this.codeStack[p + 1] = ch0;
        this.codeStack[p + 2] = ch1;
        this.codeStack[p + 3] = 6;
        this.codeStack[p + 4] = 4;
        this.codeStack[p + 5] = 3;
        this.codeStack[p + 6] = '\u0001';
        ++this.pExpression;
        return p + 7;
    }

    private int makeCodeForProperty(int p, String property, boolean inside) throws RegularExpressionException {
        if (property.startsWith("is")) {
            property = property.substring(2);
            int i = 0;
            while (i < UnicodeDatabase.N_BLOCKS) {
                if (property.equals(UnicodeDatabase.BLOCK_NAME[i])) {
                    return this.makeCodeForCharacterRange(p, (char)UnicodeDatabase.BLOCK_START[i], (char)UnicodeDatabase.BLOCK_END[i], inside);
                }
                ++i;
            }
            throw new RegularExpressionException("Unicode block not recognized, '" + property + "'.");
        }
        throw new RegularExpressionException("Unicode block not recognized, '" + property + "'.");
    }

    private int makeBlockInfinite(int a, int b) throws RegularExpressionException {
        this.insertInCodeStack(a, b, 2);
        this.codeStack[a] = 5;
        this.codeStack[a + 1] = (char)(b - a + 4);
        this.assertCodeStackLength(b + 4);
        this.codeStack[b + 2] = 3;
        this.codeStack[b + 3] = (char)(a - b - 2);
        return b + 4;
    }

    private int makeBlockOptional(int a, int b) throws RegularExpressionException {
        this.insertInCodeStack(a, b, 2);
        this.codeStack[a] = 5;
        this.codeStack[a + 1] = (char)(b + 2 - a);
        return b + 2;
    }

    private int makeBlockQuantified(int a, int b, int x, int y) throws RegularExpressionException {
        int r;
        this.assert0(y == -1 || x <= y);
        if (y == 0) {
            return a;
        }
        int bMinusA = b - a;
        if (y == -1) {
            r = a + x * bMinusA + 2;
            this.assertCodeStackLength(r);
            int q = b;
            int i = 1;
            while (i < x) {
                System.arraycopy(this.codeStack, a, this.codeStack, q, bMinusA);
                q += bMinusA;
                ++i;
            }
            this.codeStack[q] = 5;
            this.codeStack[q + 1] = (char)(a - b);
            this.assert0(r == q + 2);
        } else {
            int i;
            r = a + y * bMinusA + (y - x) * 2;
            this.assertCodeStackLength(r);
            int q = a;
            if (x > 0) {
                q = b;
                i = 1;
                while (i < x) {
                    System.arraycopy(this.codeStack, a, this.codeStack, q, bMinusA);
                    q += bMinusA;
                    ++i;
                }
            }
            i = x;
            while (i < y) {
                System.arraycopy(this.codeStack, a, this.codeStack, q + 2, bMinusA);
                this.codeStack[q] = 5;
                this.codeStack[q + 1] = (char)(r - q);
                q += bMinusA;
                q += 2;
                ++i;
            }
        }
        return r;
    }

    private int makeBlockDuplicate(int a, int b) throws RegularExpressionException {
        this.insertInCodeStack(a, b, b - a);
        return 2 * b - a;
    }

    private void insertInCodeStack(int a, int b, int k) throws RegularExpressionException {
        this.codeStack = Tools.assertArrayLength(this.codeStack, b + k);
        System.arraycopy(this.codeStack, a, this.codeStack, a + k, b - a);
    }

    private void assertCodeStackLength(int a) throws RegularExpressionException {
        this.codeStack = Tools.assertArrayLength(this.codeStack, a);
    }

    private int scanInt() {
        char ch = this.expression[this.pExpression];
        if (ch < '0' || ch > '9') {
            return -1;
        }
        int r = 0;
        do {
            r *= 10;
            r += ch - 48;
            ++this.pExpression;
        } while ((ch = this.expression[this.pExpression]) >= '0' && ch <= '9');
        return r;
    }

    private int scanIntHex() {
        char ch = this.expression[this.pExpression];
        if (!(ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f')) {
            return -1;
        }
        int r = 0;
        do {
            r <<= 4;
            r += ch >= '0' && ch <= '9' ? ch - 48 : (ch >= 'A' && ch <= 'F' ? ch - 65 + 10 : ch - 97 + 10);
            ++this.pExpression;
        } while ((ch = this.expression[this.pExpression]) >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f');
        return r;
    }

    public String pos() {
        try {
            return "(Position=" + this.pExpression + ", expression='" + new String(this.expression, 0, this.pExpression) + " << " + this.expression[this.pExpression] + " >> " + new String(this.expression, this.pExpression + 1, this.expressionLength) + "')";
        }
        catch (StringIndexOutOfBoundsException e) {
            return "(Position=" + this.pExpression + ", expression='" + new String(this.expression, 0, this.expressionLength) + "')";
        }
    }

    private void assert0(boolean b) {
        if (!b) {
            throw new RuntimeException("Assertion failed.");
        }
    }

    private String scanPropertyName() throws RegularExpressionException {
        if (this.expression[this.pExpression] != '{') {
            throw new RegularExpressionException("'{' expected after '\\p' or '\\P'.");
        }
        ++this.pExpression;
        int p0 = this.pExpression;
        char ch;
        while ((ch = this.expression[this.pExpression]) != '}') {
            if (ch == '\u0000') {
                throw new RegularExpressionException("Opening brace '{' not closed.");
            }
            ++this.pExpression;
        }
        return new String(this.expression, p0, this.pExpression - p0);
    }
}

