/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.gui.filechooser;

import com.inqmy.lib.schema.gui.filechooser.XFileChooser;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

final class FileSystemViewTreeModel
implements TreeModel {
    public static final Object ROOT = new Object();
    private XFileChooser owner;
    private FileSystemView fileSystemView;
    private Vector treeModelListeners = new Vector();
    private Hashtable cache = new Hashtable();
    private Hashtable parentCache = new Hashtable();
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            File f1 = (File)o1;
            File f2 = (File)o2;
            boolean d1 = f1.isDirectory();
            boolean d2 = f2.isDirectory();
            if (d1 && !d2) {
                return -1;
            }
            if (!d1 && d2) {
                return 1;
            }
            return f1.compareTo(f2);
        }
    };

    public FileSystemViewTreeModel(XFileChooser owner, FileSystemView fsv) {
        this.owner = owner;
        this.fileSystemView = fsv;
    }

    private File[] getChildren(Object parent) {
        File[] r;
        Object x = this.cache.get(parent);
        if (x != null) {
            return (File[])x;
        }
        if (parent == ROOT) {
            r = this.fileSystemView.getRoots();
        } else {
            r = this.fileSystemView.getFiles((File)parent, false);
            r = this.owner.extractAcceptableFiles(r, true);
            Arrays.sort(r, COMPARATOR);
        }
        this.cache.put(parent, r);
        return r;
    }

    void clearCache() {
        this.cache.clear();
        this.parentCache.clear();
    }

    void removeFromCache(Object x) {
        this.cache.remove(x);
        this.parentCache.remove(x);
    }

    public Object getRoot() {
        return ROOT;
    }

    public Object getChild(Object parent, int index) {
        return this.getChildren(parent)[index];
    }

    public int getChildCount(Object parent) {
        return this.getChildren(parent).length;
    }

    public boolean isLeaf(Object node) {
        return node != ROOT && !((File)node).isDirectory();
    }

    public int getIndexOfChild(Object parent, Object child) {
        File[] children = this.getChildren(parent);
        int i = 0;
        while (i < children.length) {
            if (children[i] == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        this.fireTreeStructureChanged(new TreeModelEvent(ROOT, path));
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        int len = this.treeModelListeners.size();
        int i = 0;
        while (i < len) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeStructureChanged(e);
            ++i;
        }
    }

    private File[] extractAcceptable(File[] a, FileFilter filter) {
        if (a == null) {
            return new File[0];
        }
        int n = 0;
        int i = 0;
        while (i < a.length) {
            if (this.isAcceptableForListing(a[i], filter)) {
                ++n;
            }
            ++i;
        }
        File[] r = new File[n];
        n = 0;
        int i2 = 0;
        while (i2 < a.length) {
            if (this.isAcceptableForListing(a[i2], filter)) {
                r[n++] = a[i2];
            }
            ++i2;
        }
        return r;
    }

    private boolean isAcceptableForListing(File file, FileFilter filter) {
        if (file.getParentFile() == null) {
            return true;
        }
        if (file.isDirectory()) {
            return true;
        }
        if (filter == null) {
            return true;
        }
        return filter.accept(file);
    }
}

