/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.generator;

import com.inqmy.lib.schema.Schema;
import com.inqmy.lib.schema.SchemaException;
import com.inqmy.lib.schema.builtin.BuiltInManager;
import com.inqmy.lib.schema.util.StackInt;
import com.inqmy.lib.schema.util.Tools;
import com.inqmy.lib.xml.parser.helpers.CharArray;

public final class TreeWalker {
    private static final String MESSAGE_NONE_POINTER = "Internal schema processing exception, NONE-pointer";
    private static final String MESSAGE_QNAME_EXPECTED = "Internal schema processing exception, pointer to a QNAME expected";
    private static final String MESSAGE_STRING_EXPECTED = "Internal schema processing exception, pointer to a STRING expected";
    private static final String MESSAGE_ELEMENT_OR_ATTRIBUTE_EXPECTED = "Internal schema processing exception, pointer to an ELEMENT or an ATTRIBUTE expected";
    private static final String MESSAGE_TYPE_EXPECTED = "Internal schema processing exception, pointer to a TYPE expected";
    private Schema owner;
    private char[] code;
    private int pSoapArray = -1;

    public TreeWalker(Schema s) {
        this.owner = s;
    }

    public void update() {
        this.code = this.owner.getCode();
        this.pSoapArray = this.findTopLevelType("http://schemas.xmlsoap.org/soap/encoding/", "Array");
        if (this.pSoapArray <= 1) {
            this.pSoapArray = -1;
        }
    }

    public String getString(int p) {
        if (this.code[p] != '\u0002') {
            throw new SchemaException(MESSAGE_STRING_EXPECTED);
        }
        int q = p + 1;
        while (this.code[q++] != '\u0000') {
        }
        return new String(this.code, p + 1, q - p - 2);
    }

    public String getQName(int p) {
        return Tools.formatQName(this.getURI(p), this.getLocalName(p));
    }

    public String getURI(int p) {
        if (this.code[p] != '\u0003') {
            throw new SchemaException(MESSAGE_QNAME_EXPECTED);
        }
        return this.getString(this.code[p + 1]);
    }

    public String getLocalName(int p) {
        if (this.code[p] != '\u0003') {
            throw new SchemaException(MESSAGE_QNAME_EXPECTED);
        }
        return this.getString(this.code[p + 2]);
    }

    public int getProperty(int p, char mark) {
        if ((p = this.find(p, mark)) == -1) {
            return -1;
        }
        return this.code[p + 1];
    }

    public int getPTRTo(int p, char header) {
        ++p;
        while (this.code[p] != '\u0001') {
            if (this.code[p] == '\u00c8' && this.code[this.code[p + 1]] == header) {
                return this.code[p + 1];
            }
            p += 2;
        }
        return -1;
    }

    public void getPTRsTo(int p, char header, StackInt stack) {
        ++p;
        while (this.code[p] != '\u0001') {
            if (this.code[p] == '\u00c8' && this.code[this.code[p + 1]] == header) {
                stack.push(this.code[p + 1]);
            }
            p += 2;
        }
    }

    public void getDeepPTRsTo(int p, char header, StackInt stack) {
        ++p;
        while (this.code[p] != '\u0001') {
            if (this.code[p] == '\u00c8' && this.code[this.code[p + 1]] == header) {
                stack.push(this.code[p + 1]);
            }
            p += 2;
        }
    }

    private int find(int p, int mark) {
        ++p;
        while (this.code[p] != '\u0001') {
            if (this.code[p] == mark) {
                return p;
            }
            p += 2;
        }
        return -1;
    }

    private static boolean equalsNullTerminated(char[] a, int aStart, char[] b, int bStart) {
        while (a[aStart] == b[bStart]) {
            if (a[aStart] == '\u0000') {
                return true;
            }
            ++aStart;
            ++bStart;
        }
        return false;
    }

    private static boolean equalsNullTerminated(String a, char[] b, int bStart) {
        int la = a.length();
        int i = 0;
        while (i < la) {
            if (a.charAt(i) != b[bStart++]) {
                return false;
            }
            ++i;
        }
        return b[bStart] == '\u0000';
    }

    public boolean isSchemaQualified(int p) {
        return TreeWalker.isSchemaQualified(this.getString(p));
    }

    public static boolean isSchemaQualified(String uri) {
        return uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/2000/10/XMLSchema") || uri.equals("http://www.w3.org/1999/XMLSchema");
    }

    public static boolean isSchemaQualified(CharArray uri) {
        return uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/2000/10/XMLSchema") || uri.equals("http://www.w3.org/1999/XMLSchema");
    }

    private int findSchemaWithTarget(String uri) {
        int x = this.code[2] + '\u0001';
        while (this.code[x] != '\u0001') {
            if (TreeWalker.equalsNullTerminated(uri, this.code, this.code[x] + '\u0001')) {
                return this.code[x + 1];
            }
            x += 2;
        }
        return -1;
    }

    private int findSchemaWithTarget(int uri) {
        int x = this.code[2] + '\u0001';
        while (this.code[x] != '\u0001') {
            if (this.code[x] == uri) {
                return this.code[x + 1];
            }
            x += 2;
        }
        return -1;
    }

    public int findTopLevelElementOrAttribute(int qname) {
        if (this.code[qname] != '\u0003') {
            throw new SchemaException(MESSAGE_QNAME_EXPECTED);
        }
        char uri = this.code[qname + 1];
        char local = this.code[qname + 2];
        int sch = this.findSchemaWithTarget(uri);
        if (sch == -1) {
            return -1;
        }
        int y = sch + 1;
        while (this.code[y] != '\u0001') {
            int r;
            char p;
            if (this.code[y] == '\u00c8' && (this.code[p = this.code[y + 1]] == '\u000b' || this.code[p] == '\f') && (r = this.getProperty(p, '\u00cb')) != -1 && local == r) {
                return p;
            }
            y += 2;
        }
        return -1;
    }

    public int findTopLevelElementOrAttribute(String uri, String local) {
        int sch = this.findSchemaWithTarget(uri);
        if (sch == -1) {
            return -1;
        }
        int y = sch + 1;
        while (this.code[y] != '\u0001') {
            int r;
            char p;
            if (this.code[y] == '\u00c8' && (this.code[p = this.code[y + 1]] == '\u000b' || this.code[p] == '\f') && (r = this.getProperty(p, '\u00cb')) != -1 && local.equals(this.getString(r))) {
                return p;
            }
            y += 2;
        }
        return -1;
    }

    public int findTopLevelType(int qname) {
        if (this.code[qname] != '\u0003') {
            throw new SchemaException(MESSAGE_QNAME_EXPECTED);
        }
        char uri = this.code[qname + 1];
        char local = this.code[qname + 2];
        if (this.isSchemaQualified(uri)) {
            return -BuiltInManager.getId(this.getString(local));
        }
        int sch = this.findSchemaWithTarget(uri);
        if (sch == -1) {
            return 1;
        }
        int y = sch + 1;
        while (this.code[y] != '\u0001') {
            int r;
            char p;
            if (this.code[y] == '\u00c8' && (this.code[p = this.code[y + 1]] == '\u000e' || this.code[p] == '\u000f') && (r = this.getProperty(p, '\u00cb')) != -1 && local == r) {
                return p;
            }
            y += 2;
        }
        return 1;
    }

    public int findTopLevelType(String uri, String local) {
        if (TreeWalker.isSchemaQualified(uri)) {
            return -BuiltInManager.getId(local);
        }
        int sch = this.findSchemaWithTarget(uri);
        if (sch == -1) {
            return 1;
        }
        int y = sch + 1;
        while (this.code[y] != '\u0001') {
            int r;
            char p;
            if (this.code[y] == '\u00c8' && (this.code[p = this.code[y + 1]] == '\u000e' || this.code[p] == '\u000f') && (r = this.getProperty(p, '\u00cb')) != -1 && local.equals(this.getString(r))) {
                return p;
            }
            y += 2;
        }
        return 1;
    }

    public int findTopLevelTypeWithContext(int qname, int context) {
        if (this.code[this.code[qname + 1] + '\u0001'] == '\u0000') {
            return this.findTopLevelType(this.getTargetNamespaceOf(context), this.getLocalName(qname));
        }
        return this.findTopLevelType(qname);
    }

    public int getTypeOf(int e) {
        int e0 = e;
        if (this.code[e] != '\u000b' && this.code[e] != '\f') {
            throw new SchemaException(MESSAGE_ELEMENT_OR_ATTRIBUTE_EXPECTED);
        }
        int ref = this.getProperty(e, '\u00d5');
        if (ref != -1) {
            int e2 = this.findTopLevelElementOrAttribute(ref);
            if (e2 != -1) {
                if (this.code[e] != this.code[e2]) {
                    throw new SchemaException("Incompatible ref from @" + e + " to @" + e2);
                }
                e = e2;
            } else {
                throw new SchemaException("Unsatisfied ref from @" + e + " to " + this.getQName(ref));
            }
        }
        int t = this.getProperty(e, '\u00cc');
        int ct = this.getPTRTo(e, '\u000f');
        int st = this.getPTRTo(e, '\u000e');
        if (t != -1) {
            int r = this.findTopLevelTypeWithContext(t, e);
            if (r == 1) {
                throw new SchemaException("Unsatisfied type attribute from @" + e + " to " + this.getQName(t));
            }
            return r;
        }
        if (ct != -1) {
            return ct;
        }
        if (st != -1) {
            return st;
        }
        return 1;
    }

    public int getBIDOf(int t) {
        if (t <= 0) {
            return t;
        }
        if (t == 1) {
            return 1;
        }
        int b;
        while ((b = this.getBaseOf(t)) != 1) {
            if (b <= 0) {
                return b;
            }
            t = b;
        }
        return 1;
    }

    public int getBaseOf(int t) {
        if (this.code[t] == '\u000f') {
            int cc = this.getPTRTo(t, '\u0011');
            int sc = this.getPTRTo(t, '\u0010');
            if (cc != -1) {
                int ex = this.getPTRTo(cc, '5');
                int re = this.getPTRTo(cc, '4');
                if (ex != -1) {
                    int b = this.getProperty(ex, '\u00cf');
                    if (b == -1) {
                        throw new SchemaException("Extension without a base @" + ex);
                    }
                    return this.findTopLevelType(b);
                }
                if (re != -1) {
                    int b = this.getProperty(re, '\u00cf');
                    if (b == -1) {
                        throw new SchemaException("Restriction without a base @" + re);
                    }
                    return this.findTopLevelType(b);
                }
                throw new SchemaException("Complex content without extension/restriction @" + cc);
            }
            if (sc != -1) {
                int ex = this.getPTRTo(sc, '5');
                int re = this.getPTRTo(sc, '4');
                if (ex != -1) {
                    int b = this.getProperty(ex, '\u00cf');
                    if (b == -1) {
                        throw new SchemaException("Extension without a base @" + ex);
                    }
                    return this.findTopLevelType(b);
                }
                if (re != -1) {
                    int b = this.getProperty(re, '\u00cf');
                    if (b == -1) {
                        int innerSt = this.getPTRTo(re, '\u000e');
                        if (innerSt != -1) {
                            return innerSt;
                        }
                        throw new SchemaException("Restriction without a base @" + re);
                    }
                    return this.findTopLevelType(b);
                }
                throw new SchemaException("Complex content without extension/restriction @" + cc);
            }
            return 1;
        }
        if (this.code[t] == '\u000e') {
            int re = this.getPTRTo(t, '4');
            int li = this.getPTRTo(t, '3');
            int un = this.getPTRTo(t, '!');
            if (re != -1) {
                int b = this.getProperty(re, '\u00cf');
                if (b == -1) {
                    int innerSt = this.getPTRTo(re, '\u000e');
                    if (innerSt != -1) {
                        return innerSt;
                    }
                    throw new SchemaException("Restriction without a base @" + re);
                }
                return this.findTopLevelType(b);
            }
            if (li != -1) {
                return 1;
            }
            return un == -1 ? 1 : 1;
        }
        throw new SchemaException(MESSAGE_TYPE_EXPECTED);
    }

    public String getNameOfType(int t) {
        if (t <= 0) {
            return "com.inqmy.lib.schema.builtin.XS_" + BuiltInManager.getName(-t);
        }
        if (t == 1) {
            return "java.lang.Object/*unknown*/";
        }
        if (this.code[t] != '\u000e' && this.code[t] != '\u000f') {
            throw new SchemaException(MESSAGE_TYPE_EXPECTED);
        }
        if (this.isSoapArray(t)) {
            return this.soapArrayDeclarationToJava(t);
        }
        String target = this.getTargetNamespaceOf(t);
        int name = this.getProperty(t, '\u00cb');
        if (name == -1) {
            int outerName;
            int p = this.getProperty(t, '\u0104');
            if (p != -1 && (this.code[p] == '\u000b' || this.code[p] == '\f') && (outerName = this.getProperty(p, '\u00cb')) != -1) {
                return this.withPackage(target, this.owner.getMapper().toClassIdentifier(this.getString(outerName)));
            }
            return this.withPackage(target, "T_" + t);
        }
        return this.withPackage(target, this.owner.getMapper().toClassIdentifier(this.getString(name)));
    }

    protected final String getPackageOf(int t) {
        if (this.owner.map == null) {
            return "";
        }
        String target = this.getTargetNamespaceOf(t);
        target = target != null ? target : "";
        String p = (String)this.owner.map.get(target);
        if (p == null || p.length() == 0) {
            p = (String)this.owner.map.get("*");
            if (p == null || p.length() == 0) {
                return "";
            }
            return p;
        }
        return p;
    }

    protected final String getPackageOf(String target) {
        if (this.owner.map == null) {
            return "";
        }
        String p = (String)this.owner.map.get(target = target != null ? target : "");
        if (p == null || p.length() == 0) {
            p = (String)this.owner.map.get("*");
            if (p == null || p.length() == 0) {
                return "";
            }
            return p;
        }
        return p;
    }

    public final String withPackage(String target, String s) {
        String prefix = "";
        if (this.owner.unique.contains(s)) {
            prefix = this.owner.prefix;
        }
        if (this.owner.map == null) {
            return prefix + s;
        }
        String p = (String)this.owner.map.get(target = target != null ? target : "");
        if (p == null || p.length() == 0) {
            p = (String)this.owner.map.get("*");
            if (p == null || p.length() == 0) {
                return prefix + s;
            }
            return p + '.' + prefix + s;
        }
        return p + '.' + prefix + s;
    }

    public int getItemTypeOfList(int t) {
        if (this.code[t] != '\u000e') {
            throw new SchemaException(MESSAGE_TYPE_EXPECTED);
        }
        int l = this.getPTRTo(t, '3');
        if (l == -1) {
            throw new SchemaException("Pointer to a simple type derived by list expected. @" + t);
        }
        int itemTypeQName = this.getProperty(l, '\u00d9');
        if (itemTypeQName == -1) {
            int itemType = this.getPTRTo(l, '\u000e');
            return itemType == -1 ? 1 : itemType;
        }
        return this.findTopLevelType(itemTypeQName);
    }

    public boolean isFinal(int t) {
        if (t <= 1) {
            return false;
        }
        return this.getProperty(t, '\u00fc') == 1;
    }

    public boolean isSoapArray(int t) {
        if (t > 1 && this.code[t] != '\u000e' && this.code[t] != '\u000f') {
            throw new SchemaException(MESSAGE_TYPE_EXPECTED);
        }
        while (t > 1) {
            if (this.code[t] == '\u000e') {
                return false;
            }
            if (t == this.pSoapArray) {
                return true;
            }
            t = this.getBaseOf(t);
        }
        return false;
    }

    public int getOwnerSchemaOf(int x) {
        while (this.code[x] != '\n') {
            if ((x = this.getProperty(x, '\u0104')) > 1) continue;
            return -1;
        }
        return x;
    }

    public String getTargetNamespaceOf(int x) {
        int sch = this.getOwnerSchemaOf(x);
        if (sch == -1) {
            return "";
        }
        int target = this.getProperty(sch, '\u00d4');
        return target != -1 ? this.getString(target) : "";
    }

    public String soapArrayDeclarationToJava(int t) {
        if (t > 1 && this.code[t] != '\u000e' && this.code[t] != '\u000f') {
            throw new SchemaException(MESSAGE_TYPE_EXPECTED);
        }
        if (t == this.pSoapArray) {
            return "java.lang.Object[]/*a*/";
        }
        int cc = this.getPTRTo(t, '\u0011');
        if (cc == -1) {
            return "java.lang.Object[]/*b*/";
        }
        int re = this.getPTRTo(cc, '4');
        if (re == -1) {
            return "java.lang.Object[]/*c*/";
        }
        int y = re + 1;
        while (this.code[y] != '\u0001') {
            int ref;
            char a;
            if (this.code[y] == '\u00c8' && this.code[a = this.code[y + 1]] == '\f' && (ref = this.getProperty(a, '\u00d5')) != -1 && TreeWalker.equalsNullTerminated("http://schemas.xmlsoap.org/soap/encoding/", this.code, this.code[ref + 1] + '\u0001') && TreeWalker.equalsNullTerminated("arrayType", this.code, this.code[ref + 2] + '\u0001')) {
                int atq = this.getProperty(a, '\u00fe');
                int atd = this.getProperty(a, '\u00ff');
                if (atq == -1 || atd == -1) {
                    return "java.lang.Object[]/*d*/";
                }
                StringBuffer buffer = new StringBuffer();
                int z = 0;
                while (z < atd) {
                    buffer.append("[]");
                    ++z;
                }
                String dimensions = buffer.toString();
                int it = this.findTopLevelTypeWithContext(atq, t);
                return this.compose(it, dimensions);
            }
            y += 2;
        }
        int seq = this.getPTRTo(re, ' ');
        if (seq == -1) {
            return "java.lang.Object[]/*e*/";
        }
        int el = this.getPTRTo(seq, '\u000b');
        if (el == -1) {
            return "java.lang.Object[]/*f*/";
        }
        int elType = this.getTypeOf(el);
        return this.compose(elType, "[]");
    }

    private String compose(int it, String dimensions) {
        if (it == 1) {
            return "java.lang.Object/*g*/" + dimensions;
        }
        if (it <= 0) {
            return BuiltInManager.getJavaType(it) + dimensions;
        }
        return this.getNameOfType(it) + dimensions;
    }
}

