/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.generator;

import com.inqmy.lib.schema.SchemaException;
import com.inqmy.lib.schema.regular.RegularExpression;
import com.inqmy.lib.schema.util.DateTimeConverter;
import com.inqmy.lib.schema.util.DateTimeDurationRepresentation;
import com.inqmy.lib.xml.util.BASE64Decoder;
import com.inqmy.lib.xml.util.BASE64Encoder;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Locale;

public abstract class Base
implements Serializable {
    protected static final String[] _ISO_LANGUAGES = Locale.getISOLanguages();

    public abstract boolean isSimple();

    protected final void _check_duration(String s) throws SchemaException {
        this._parse_Duration(s, new DateTimeDurationRepresentation());
    }

    protected final void _check_dateTime(Calendar calendar) {
    }

    protected final void _check_time(String s) {
        this._parse_Time(s, new DateTimeDurationRepresentation());
    }

    protected final void _check_date(String s) {
        this._parse_Date(s, new DateTimeDurationRepresentation());
    }

    protected final void _check_gYearMonth(String s) {
    }

    protected final void _check_gYear(String s) {
    }

    protected final void _check_gMonthDay(String s) {
    }

    protected final void _check_gDay(String s) {
    }

    protected final void _check_gMonth(String s) {
    }

    protected final void _check_base64Binary(byte[] abyte0) {
    }

    protected final void _check_hexBinary(byte[] abyte0) {
    }

    protected final void _check_anyURI(String s) {
    }

    protected final void _check_QName(String s) {
    }

    protected final void _check_NOTATION(String s) {
    }

    protected final void _check_normalizedString(String s) {
    }

    protected final void _check_token(String s) {
    }

    protected final void _check_language(String s) {
        int i = 0;
        while (i < _ISO_LANGUAGES.length) {
            if (s.equals(_ISO_LANGUAGES[i])) {
                return;
            }
            ++i;
        }
        throw new SchemaException("");
    }

    protected final void _check_Name(String s) {
    }

    protected final void _check_NMTOKEN(String s) {
    }

    protected final void _check_NCName(String s) {
    }

    protected final void _check_NMTOKENS(String s) {
    }

    protected final void _check_ID(String s) {
    }

    protected final void _check_IDREF(String s) {
    }

    protected final void _check_ENTITY(String s) {
    }

    protected final void _check_IDREFS(String s) {
    }

    protected final void _check_ENTITIES(String s) {
    }

    protected final void _check_decimal(BigDecimal bigdecimal) {
    }

    protected final void _check_integer(BigInteger biginteger) {
    }

    protected final void _check_nonPositiveInteger(long l) {
    }

    protected final void _check_long(long l) {
    }

    protected final void _check_nonNegativeInteger(long l) {
    }

    protected final void _check_negativeInteger(long l) {
    }

    protected final void _check_int(int i) {
    }

    protected final void _check_unsignedLong(long l) {
    }

    protected final void _check_positiveInteger(long l) {
    }

    protected final void _check_short(short word0) {
    }

    protected final void _check_unsignedInt(int i) {
    }

    protected final void _check_byte(byte byte0) {
    }

    protected final void _check_unsignedShort(short word0) {
    }

    protected final void _check_unsignedByte(byte byte0) {
    }

    protected final void _facet_length(long l, int i) {
        this._facet_length(Long.toString(l), i);
    }

    protected final void _facet_length(byte[] abyte0, int i) {
        if (abyte0.length != i) {
            throw new SchemaException("Facet failed.");
        }
    }

    protected final void _facet_length(String s, int i) {
        if (s.length() != i) {
            throw new SchemaException("Facet failed.");
        }
    }

    protected final void _facet_minLength(long l, int i) {
        this._facet_length(Long.toString(l), i);
    }

    protected final void _facet_minLength(byte[] abyte0, int i) {
        if (abyte0.length < i) {
            throw new SchemaException("Facet failed.");
        }
    }

    protected final void _facet_minLength(String s, int i) {
        if (s.length() < i) {
            throw new SchemaException("Facet failed.");
        }
    }

    protected final void _facet_maxLength(long l, int i) {
        this._facet_length(Long.toString(l), i);
    }

    protected final void _facet_maxLength(byte[] abyte0, int i) {
        if (abyte0.length > i) {
            throw new SchemaException("Facet failed.");
        }
    }

    protected final void _facet_maxLength(String s, int i) {
        if (s.length() > i) {
            throw new SchemaException("Facet failed.");
        }
    }

    protected final boolean _facet_pattern(long l, String s) {
        return this._facet_pattern(Long.toString(l), s);
    }

    protected final boolean _facet_pattern(Calendar calendar, String s) {
        return this._facet_pattern(this._toString_Calendar(calendar, 2), s);
    }

    protected final boolean _facet_pattern(String s, String s1) {
        RegularExpression regularexpression = new RegularExpression(s1);
        return regularexpression.matches(s);
    }

    protected final boolean _facet_enumeration(long l, String s) {
        return this._facet_enumeration(Long.toString(l), s);
    }

    protected final boolean _facet_enumeration(String s, String s1) {
        return s.equals(s1);
    }

    protected final void _facet_whitespace(int i, String s) {
    }

    protected final void _facet_whitespace(long l, String s) {
    }

    protected final void _facet_whitespace(String s, String s1) {
    }

    protected final String _ws_replace(String s) {
        return s.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ');
    }

    protected final String _ws_collapse(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        int i = s.length();
        boolean flag = true;
        int j = 0;
        while (j < i) {
            boolean flag1;
            char c = s.charAt(j);
            boolean bl = flag1 = c == ' ' || c == '\t' || c == '\n' || c == '\r';
            if (flag1) {
                if (!flag) {
                    stringbuffer.append(' ');
                    flag = true;
                }
            } else {
                stringbuffer.append(c);
                flag = false;
            }
            ++j;
        }
        if (flag) {
            stringbuffer.setLength(stringbuffer.length() - 1);
        }
        return stringbuffer.toString();
    }

    protected final void _facet_maxInclusive(long l, long l1) {
        if (l > l1) {
            throw new SchemaException("Facet failed.");
        }
    }

    protected final void _facet_maxExclusive(long l, long l1) {
        if (l >= l1) {
            throw new SchemaException("Facet failed.");
        }
    }

    protected final void _facet_minExclusive(long l, long l1) {
        if (l <= l1) {
            throw new SchemaException("Facet failed.");
        }
    }

    protected final void _facet_minInclusive(long l, long l1) {
        if (l < l1) {
            throw new SchemaException("Facet failed.");
        }
    }

    protected final void _facet_totalDigits(long l, int i) {
    }

    protected final void _facet_fractionDigits(long l, int i) {
    }

    protected final String[] _parseList(String s) {
        int i = 0;
        boolean flag = false;
        int j = s.length();
        int k = 0;
        while (k < j) {
            boolean flag1;
            char c = s.charAt(k);
            boolean bl = flag1 = c == ' ' || c == '\t' || c == '\n' || c == '\r';
            if (flag1 && flag) {
                flag = false;
            } else if (!flag1 && !flag) {
                ++i;
                flag = true;
            }
            ++k;
        }
        String[] as = new String[i];
        i = 0;
        int l = 0;
        flag = false;
        int i1 = 0;
        while (i1 < j) {
            boolean flag2;
            char c1 = s.charAt(i1);
            boolean bl = flag2 = c1 == ' ' || c1 == '\t' || c1 == '\n' || c1 == '\r';
            if (flag2 && flag) {
                as[i - 1] = s.substring(l, i1);
                flag = false;
            } else if (!flag2 && !flag) {
                l = i1;
                ++i;
                flag = true;
            }
            ++i1;
        }
        if (flag) {
            as[i - 1] = s.substring(l);
        }
        return as;
    }

    protected final BigDecimal _parse_BigDecimal(String s) {
        return new BigDecimal(s);
    }

    protected final BigInteger _parse_BigInteger(String s) {
        return new BigInteger(s);
    }

    protected final boolean _parse_boolean(String s) {
        if (s == null || s.equals("0") || s.equals("false")) {
            return false;
        }
        if (s.equals("1") || s.equals("true")) {
            return true;
        }
        throw new SchemaException("Boolean should be '0', '1', 'false', or 'true'.");
    }

    protected final long _parse_long(String s) {
        long l;
        if (s == null || s.length() == 0) {
            return 0L;
        }
        try {
            l = Long.parseLong(s);
        }
        catch (Exception e) {
            throw new SchemaException("Incorrect long value !");
        }
        return l;
    }

    protected final int _parse_int(String s) {
        return (int)this._parse_long(s);
    }

    protected final short _parse_short(String s) {
        return (short)this._parse_long(s);
    }

    protected final byte _parse_byte(String s) {
        return (byte)this._parse_long(s);
    }

    protected final String _parse_String(String s) {
        return s;
    }

    protected final byte[] _parse_byteArray(String s) {
        if (s == null) {
            return new byte[0];
        }
        return BASE64Decoder.decode(s.getBytes());
    }

    protected final float _parse_float(String s) {
        if (s == null) {
            return 0.0f;
        }
        return Float.parseFloat(s);
    }

    protected final double _parse_double(String s) {
        if (s == null) {
            return 0.0;
        }
        return Double.parseDouble(s);
    }

    protected final Object _parse_Object(String s) {
        return s;
    }

    protected final Calendar _parse_Calendar(String s) {
        return DateTimeConverter.parseDateTime(s);
    }

    protected final String _toString_BigDecimal(BigDecimal bigdecimal, int i) {
        return bigdecimal.toString();
    }

    protected final String _toString_BigInteger(BigInteger biginteger, int i) {
        return biginteger.toString();
    }

    protected final String _toString_long(long l, int i) {
        return Long.toString(l);
    }

    protected final String _toString_int(int i, int j) {
        return Integer.toString(i);
    }

    protected final String _toString_short(short word0, int i) {
        return Short.toString(word0);
    }

    protected final String _toString_byte(byte byte0, int i) {
        return Byte.toString(byte0);
    }

    protected final String _toString_String(String s, int i) {
        return s;
    }

    protected final String _toString_float(float f, int i) {
        return Float.toString(f);
    }

    protected final String _toString_double(double d, int i) {
        return Double.toString(d);
    }

    protected final String _toString_Object(Object obj, int i) {
        return String.valueOf(obj);
    }

    protected final String _toString_byteArray(byte[] abyte0, int i) {
        return new String(BASE64Encoder.encode(abyte0));
    }

    protected final String _toString_boolean(boolean flag, int i) {
        return flag ? "true" : "false";
    }

    protected final String _toString_Calendar(Calendar calendar, int i) {
        return DateTimeConverter.getRelative(calendar);
    }

    protected final Object _wrap(long l) {
        return new Long(l);
    }

    protected final Object _wrap(int i) {
        return new Integer(i);
    }

    protected final Object _wrap(short word0) {
        return new Short(word0);
    }

    protected final Object _wrap(byte byte0) {
        return new Byte(byte0);
    }

    protected final Object _wrap(boolean flag) {
        return flag ? Boolean.TRUE : Boolean.FALSE;
    }

    protected final Object _wrap(Object obj) {
        return obj;
    }

    protected final long _unwrap_long(Object obj) {
        return (Long)obj;
    }

    protected final int _unwrap_int(Object obj) {
        return (Integer)obj;
    }

    protected final short _unwrap_short(Object obj) {
        return (Short)obj;
    }

    protected final byte _unwrap_byte(Object obj) {
        return (Byte)obj;
    }

    protected final String _unwrap_String(Object obj) {
        return (String)obj;
    }

    protected final byte[] _unwrap_byteArray(Object obj) {
        return (byte[])obj;
    }

    protected final boolean _unwrap_boolean(Object obj) {
        return (Boolean)obj;
    }

    private int searchCharArray(char[] ac, char c, int i, int j) {
        int k = i;
        while (k < j) {
            if (ac[k] == c) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    protected void _parse_Date(String s, DateTimeDurationRepresentation datetimedurationrepresentation) {
        int i1;
        int l;
        int k;
        int i;
        int j;
        char[] ac = s.toCharArray();
        int j1 = this.searchCharArray(ac, '-', (j = 0) + 1, i = ac.length);
        if (j1 != -1) {
            try {
                k = new Integer(new String(ac, j, j1));
                if (k == 0) {
                    throw new SchemaException("Invalid year.");
                }
                if (ac[j1] != '-') {
                    throw new SchemaException("Invlid date");
                }
                l = new Integer(new String(ac, j1 + 1, 2));
                if (ac[j1 + 3] != '-') {
                    throw new SchemaException("Invlid date");
                }
                i1 = new Integer(new String(ac, j1 + 4, 2));
            }
            catch (SchemaException schemaexception) {
                throw schemaexception;
            }
            catch (Exception exception) {
                throw new SchemaException("Invlid date");
            }
        } else {
            throw new SchemaException("Invlid date");
        }
        datetimedurationrepresentation.setDays(k, l, i1);
        datetimedurationrepresentation.id = 1;
    }

    protected void _parse_Time(String s, DateTimeDurationRepresentation datetimedurationrepresentation) {
        int l;
        int k;
        char[] ac = s.toCharArray();
        int i = ac.length;
        int j = 0;
        int i1 = 0;
        int j1 = 0;
        try {
            k = new Integer(new String(ac, j, 2));
        }
        catch (Exception exception) {
            throw new SchemaException("Invlid time");
        }
        if (ac[j + 2] != ':') {
            throw new SchemaException("Invlid time");
        }
        try {
            l = new Integer(new String(ac, j + 3, 2));
        }
        catch (Exception exception1) {
            throw new SchemaException("Invlid time");
        }
        if (ac[j + 5] != ':') {
            throw new SchemaException("Invlid time");
        }
        int k1 = this.searchCharArray(ac, 'Z', j + 6, i);
        if (k1 == -1) {
            k1 = this.searchCharArray(ac, '+', j + 6, i);
        }
        if (k1 == -1) {
            k1 = this.searchCharArray(ac, '-', j + 6, i);
        }
        if (k1 == -1) {
            k1 = i;
        } else {
            datetimedurationrepresentation.hasgmt = true;
        }
        try {
            datetimedurationrepresentation.seconds = new Float(new String(ac, j + 6, k1 - j - 6)).floatValue();
        }
        catch (Exception exception2) {
            throw new SchemaException("Invlid time");
        }
        if (datetimedurationrepresentation.hasgmt) {
            if (ac[k1] == 'Z') {
                i1 = 0;
                j1 = 0;
            } else {
                i1 = new Integer(new String(ac, k1, 3));
                if (ac[k1 + 3] != ':') {
                    throw new SchemaException("Invlid time");
                }
                j1 = new Integer(new String(ac, k1 + 4, 2));
            }
            if (i1 < 0) {
                j1 = -j1;
            }
        }
        datetimedurationrepresentation.setMinutes(k + i1, l + j1, (byte)2);
        datetimedurationrepresentation.id = (byte)2;
    }

    protected Calendar _parse_dateTime(String s) {
        return null;
    }

    protected void _parse_Duration(String s, DateTimeDurationRepresentation datetimedurationrepresentation) {
        int i2;
        int k1;
        char[] ac = s.toCharArray();
        int i = ac.length;
        int j = 0;
        boolean flag = false;
        boolean flag1 = true;
        boolean flag2 = true;
        int k = 0;
        int l = 0;
        int i1 = 0;
        int j1 = this.searchCharArray(ac, 'T', j, i);
        if (j1 == -1) {
            j1 = i;
            flag1 = false;
        }
        if ((k1 = this.searchCharArray(ac, 'P', j, j + 2)) != j && k1 != j + 1 && ac[j] != '-') {
            throw new SchemaException("Invalid duration");
        }
        k1 = 1;
        if (ac[j] == '-') {
            flag2 = false;
        }
        if ((i2 = this.searchCharArray(ac, 'Y', k1, j1)) != -1) {
            flag = true;
            try {
                k = new Integer(new String(ac, k1, i2 - k1));
                k1 = i2 + 1;
            }
            catch (Exception exception) {
                throw new SchemaException("Invalid duration");
            }
        }
        if ((i2 = this.searchCharArray(ac, 'M', k1, j1)) != -1) {
            flag = true;
            try {
                l = new Integer(new String(ac, k1, i2 - k1));
                k1 = i2 + 1;
            }
            catch (Exception exception1) {
                throw new SchemaException("Invalid duration");
            }
        }
        if ((i2 = this.searchCharArray(ac, 'D', k1, j1)) != -1) {
            flag = true;
            try {
                i1 = new Integer(new String(ac, k1, i2 - k1));
            }
            catch (Exception exception2) {
                throw new SchemaException("Invalid duration");
            }
        }
        if (!flag2) {
            l = -l;
            i1 = -i1;
        }
        datetimedurationrepresentation.setMaxDurationDays(k, l, i1);
        datetimedurationrepresentation.setMinDurationDays(k, l, i1);
        if (flag1) {
            int l1 = j1 + 1;
            int j2 = this.searchCharArray(ac, 'H', l1, i);
            if (j2 != -1) {
                flag = true;
                try {
                    k = new Integer(new String(ac, l1, j2 - l1));
                    l1 = j2 + 1;
                }
                catch (Exception exception3) {
                    throw new SchemaException("Invalid duration");
                }
            }
            if ((j2 = this.searchCharArray(ac, 'M', l1, i)) != -1) {
                flag = true;
                try {
                    l = new Integer(new String(ac, l1, j2 - l1));
                    l1 = j2 + 1;
                }
                catch (Exception exception4) {
                    throw new SchemaException("Invalid duration");
                }
            }
            if ((j2 = this.searchCharArray(ac, 'S', l1, i)) != -1) {
                flag = true;
                try {
                    datetimedurationrepresentation.seconds = flag2 ? new Float(new String(ac, l1, j2 - l1)).floatValue() : -new Float(new String(ac, l1, j2 - l1)).floatValue();
                }
                catch (Exception exception5) {
                    throw new SchemaException("Invalid duration");
                }
            }
            if (!flag2) {
                k = -k;
                l = -l;
            }
            datetimedurationrepresentation.setMinutes(k, l, (byte)2);
        }
        datetimedurationrepresentation.id = (byte)4;
        if (!flag) {
            throw new SchemaException("Invalid duration");
        }
    }

    protected boolean _is_Duration_Greater_Than(String s, String s1) {
        DateTimeDurationRepresentation datetimedurationrepresentation = new DateTimeDurationRepresentation();
        DateTimeDurationRepresentation datetimedurationrepresentation1 = new DateTimeDurationRepresentation();
        this._parse_Duration(s, datetimedurationrepresentation);
        this._parse_Duration(s1, datetimedurationrepresentation1);
        return datetimedurationrepresentation.isGreaterThan(datetimedurationrepresentation1);
    }

    protected boolean _is_Duration_Less_Than(String s, String s1) {
        DateTimeDurationRepresentation datetimedurationrepresentation = new DateTimeDurationRepresentation();
        DateTimeDurationRepresentation datetimedurationrepresentation1 = new DateTimeDurationRepresentation();
        this._parse_Duration(s, datetimedurationrepresentation);
        this._parse_Duration(s1, datetimedurationrepresentation1);
        return datetimedurationrepresentation.isLessThan(datetimedurationrepresentation1);
    }

    protected boolean _is_Date_Greater_Than(String s, String s1) {
        DateTimeDurationRepresentation datetimedurationrepresentation = new DateTimeDurationRepresentation();
        DateTimeDurationRepresentation datetimedurationrepresentation1 = new DateTimeDurationRepresentation();
        this._parse_Date(s, datetimedurationrepresentation);
        this._parse_Date(s1, datetimedurationrepresentation1);
        return datetimedurationrepresentation.isGreaterThan(datetimedurationrepresentation1);
    }

    protected boolean _is_Date_Less_Than(String s, String s1) {
        DateTimeDurationRepresentation datetimedurationrepresentation = new DateTimeDurationRepresentation();
        DateTimeDurationRepresentation datetimedurationrepresentation1 = new DateTimeDurationRepresentation();
        this._parse_Date(s, datetimedurationrepresentation);
        this._parse_Date(s1, datetimedurationrepresentation1);
        return datetimedurationrepresentation.isLessThan(datetimedurationrepresentation1);
    }

    protected boolean _is_Date_Equal_To(String s, String s1) {
        DateTimeDurationRepresentation datetimedurationrepresentation = new DateTimeDurationRepresentation();
        DateTimeDurationRepresentation datetimedurationrepresentation1 = new DateTimeDurationRepresentation();
        this._parse_Date(s, datetimedurationrepresentation);
        this._parse_Date(s1, datetimedurationrepresentation1);
        return datetimedurationrepresentation.isEqualTo(datetimedurationrepresentation1);
    }

    protected boolean _is_Time_Greater_Than(String s, String s1) {
        DateTimeDurationRepresentation datetimedurationrepresentation = new DateTimeDurationRepresentation();
        DateTimeDurationRepresentation datetimedurationrepresentation1 = new DateTimeDurationRepresentation();
        this._parse_Time(s, datetimedurationrepresentation);
        this._parse_Time(s1, datetimedurationrepresentation1);
        return datetimedurationrepresentation.isGreaterThan(datetimedurationrepresentation1);
    }

    protected boolean _is_Time_Less_Than(String s, String s1) {
        DateTimeDurationRepresentation datetimedurationrepresentation = new DateTimeDurationRepresentation();
        DateTimeDurationRepresentation datetimedurationrepresentation1 = new DateTimeDurationRepresentation();
        this._parse_Time(s, datetimedurationrepresentation);
        this._parse_Time(s1, datetimedurationrepresentation1);
        return datetimedurationrepresentation.isLessThan(datetimedurationrepresentation1);
    }

    protected boolean _is_Time_Equal_To(String s, String s1) {
        DateTimeDurationRepresentation datetimedurationrepresentation = new DateTimeDurationRepresentation();
        DateTimeDurationRepresentation datetimedurationrepresentation1 = new DateTimeDurationRepresentation();
        this._parse_Time(s, datetimedurationrepresentation);
        this._parse_Time(s1, datetimedurationrepresentation1);
        return datetimedurationrepresentation.isEqualTo(datetimedurationrepresentation1);
    }

    protected double[] _ensureLength(double[] ad, int i) {
        if (ad.length < i) {
            double[] ad1 = ad;
            ad = new double[2 * i];
            System.arraycopy(ad1, 0, ad, 0, ad1.length);
        }
        return ad;
    }

    protected float[] _ensureLength(float[] ad, int i) {
        if (ad.length < i) {
            float[] ad1 = ad;
            ad = new float[2 * i];
            System.arraycopy(ad1, 0, ad, 0, ad1.length);
        }
        return ad;
    }

    protected byte[] _ensureLength(byte[] abyte0, int i) {
        if (abyte0.length < i) {
            byte[] abyte1 = abyte0;
            abyte0 = new byte[2 * i];
            System.arraycopy(abyte1, 0, abyte0, 0, abyte1.length);
        }
        return abyte0;
    }

    protected short[] _ensureLength(short[] aword0, int i) {
        if (aword0.length < i) {
            short[] aword1 = aword0;
            aword0 = new short[2 * i];
            System.arraycopy(aword1, 0, aword0, 0, aword1.length);
        }
        return aword0;
    }

    protected int[] _ensureLength(int[] ai, int i) {
        if (ai.length < i) {
            int[] ai1 = ai;
            ai = new int[2 * i];
            System.arraycopy(ai1, 0, ai, 0, ai1.length);
        }
        return ai;
    }

    protected long[] _ensureLength(long[] al, int i) {
        if (al.length < i) {
            long[] al1 = al;
            al = new long[2 * i];
            System.arraycopy(al1, 0, al, 0, al1.length);
        }
        return al;
    }

    protected String[] _ensureLength(String[] as, int i) {
        if (as.length < i) {
            String[] as1 = as;
            as = new String[2 * i];
            System.arraycopy(as1, 0, as, 0, as1.length);
        }
        return as;
    }

    protected byte[][] _ensureLength(byte[][] abyte0, int i) {
        if (((byte[][])abyte0).length < i) {
            byte[][] abyte1 = abyte0;
            abyte0 = new byte[2 * i][];
            System.arraycopy(abyte1, 0, abyte0, 0, abyte1.length);
        }
        return abyte0;
    }

    protected Object[] _ensureLength(Object[] aobj, int i) {
        if (aobj.length < i) {
            Object[] aobj1 = aobj;
            aobj = (Object[])Array.newInstance(aobj.getClass().getComponentType(), 2 * i);
            System.arraycopy(aobj1, 0, aobj, 0, aobj1.length);
        }
        return aobj;
    }

    protected boolean[] _ensureLength(boolean[] abyte0, int i) {
        if (abyte0.length < i) {
            boolean[] abyte1 = abyte0;
            abyte0 = new boolean[2 * i];
            System.arraycopy(abyte1, 0, abyte0, 0, abyte1.length);
        }
        return abyte0;
    }

    protected Calendar[] _ensureLength(Calendar[] abyte0, int i) {
        if (abyte0.length < i) {
            Calendar[] abyte1 = abyte0;
            abyte0 = new Calendar[2 * i];
            System.arraycopy(abyte1, 0, abyte0, 0, abyte1.length);
        }
        return abyte0;
    }

    protected BigDecimal[] _ensureLength(BigDecimal[] abyte0, int i) {
        if (abyte0.length < i) {
            BigDecimal[] abyte1 = abyte0;
            abyte0 = new BigDecimal[2 * i];
            System.arraycopy(abyte1, 0, abyte0, 0, abyte1.length);
        }
        return abyte0;
    }

    protected BigInteger[] _ensureLength(BigInteger[] abyte0, int i) {
        if (abyte0.length < i) {
            BigInteger[] abyte1 = abyte0;
            abyte0 = new BigInteger[2 * i];
            System.arraycopy(abyte1, 0, abyte0, 0, abyte1.length);
        }
        return abyte0;
    }
}

