/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.components.impl0;

import com.inqmy.lib.schema.components.Base;
import com.inqmy.lib.schema.components.SchemaComponentException;
import com.inqmy.lib.schema.components.impl0.BaseImpl;
import com.inqmy.lib.schema.components.impl0.LoaderImpl;
import com.inqmy.lib.xml.dom.DOM;
import com.inqmy.lib.xml.dom.QNameResolver;
import org.w3c.dom.Element;

final class Ref {
    protected static final int R_OK = 1;
    protected static final int R_NOT_FOUND = 2;
    protected static final int R_CONTOUR = 3;
    private int toWhat;
    private String uri;
    private String local;
    private String prop;
    private BaseImpl from;
    private Element element;
    private int status = 1;

    protected Ref(BaseImpl from, String qname, Element e, int toWhat, String prop) throws SchemaComponentException {
        this.element = e;
        if (from == null || qname == null || e == null) {
            throw new IllegalArgumentException();
        }
        this.from = from;
        this.uri = DOM.qnameToURI(qname, e);
        if (this.uri == null) {
            throw new SchemaComponentException("QName '" + qname + "' cannot be resolved from the scope of " + DOM.toXPath(e) + ". (Component: " + from.getNameOfComponent() + ", property of component: {" + prop + "})");
        }
        this.local = QNameResolver.qnameToLocalName(qname);
        this.toWhat = toWhat;
        this.prop = prop;
    }

    protected int resolve(LoaderImpl loader) throws SchemaComponentException {
        if (this.status == 3) {
            return 1;
        }
        if (this.status == 2) {
            return 3;
        }
        Base r = this.from.getOwnerSchema().getTopLevelComponent(this.uri, this.local, this.toWhat);
        if (r == null) {
            return 2;
        }
        this.status = 2;
        this.from.accept(r, this.toWhat, this.prop, loader);
        this.status = 3;
        return 1;
    }

    public String toString() {
        return "Ref(" + Base.NAMES_OF_COMPONENTS[this.toWhat] + " '{" + this.uri + "}:" + this.local + "})";
    }

    public BaseImpl getFrom() {
        return this.from;
    }

    public int getToWhat() {
        return this.toWhat;
    }

    public String getUri() {
        return this.uri;
    }

    public String getLocal() {
        return this.local;
    }

    public String getProp() {
        return this.prop;
    }

    public Element getElement() {
        return this.element;
    }

    public int getStatus() {
        return this.status;
    }
}

