/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.components.impl0;

import com.inqmy.lib.schema.components.impl0.FundamentalFacetsBaseImpl;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class FundamentalFacetsNumericImpl
extends FundamentalFacetsBaseImpl {
    private boolean finite;
    private Object inclusiveUpperBound;
    private Object inclusiveLowerBound;
    private Object exclusiveUpperBound;
    private Object exclusiveLowerBound;
    private boolean bounded;
    private int parseTo;
    public static final int PARSE_TO_BIG_DECIMAL = 1;
    public static final int PARSE_TO_BIG_INTEGER = 2;
    public static final int PARSE_TO_DOUBLE = 3;
    public static final int PARSE_TO_FLOAT = 4;
    public static final int PARSE_TO_LONG = 5;

    public FundamentalFacetsNumericImpl(boolean finite, Object inclusiveUpperBound, Object inclusiveLowerBound, Object exclusiveUpperBound, Object exclusiveLowerBound, int parseTo) {
        this.finite = finite;
        this.inclusiveUpperBound = inclusiveUpperBound;
        this.inclusiveLowerBound = inclusiveLowerBound;
        this.exclusiveUpperBound = exclusiveUpperBound;
        this.exclusiveLowerBound = exclusiveLowerBound;
        this.parseTo = parseTo;
        this.bounded = !(inclusiveLowerBound == null && exclusiveLowerBound == null || inclusiveUpperBound == null && exclusiveUpperBound == null);
    }

    public boolean isOrdered() {
        return true;
    }

    public boolean isBounded() {
        return this.bounded;
    }

    public boolean isCardinalityFinite() {
        return this.finite;
    }

    public boolean isCardinalityCountablyInfinite() {
        return !this.finite;
    }

    public boolean isNumeric() {
        return true;
    }

    public Object parse(String s) {
        Number r;
        if (s == null) {
            return null;
        }
        try {
            switch (this.parseTo) {
                case 1: {
                    r = new BigDecimal(s);
                    break;
                }
                case 2: {
                    r = new BigInteger(s);
                    break;
                }
                case 3: {
                    if (s.equals("NaN")) {
                        r = new Double(Double.NaN);
                        break;
                    }
                    if (s.equals("INF") || s.equals("+INF")) {
                        r = new Double(Double.POSITIVE_INFINITY);
                        break;
                    }
                    if (s.equals("-INF")) {
                        r = new Double(Double.NEGATIVE_INFINITY);
                        break;
                    }
                    r = new Double(s);
                    break;
                }
                case 4: {
                    if (s.equals("NaN")) {
                        r = new Float(Float.NaN);
                        break;
                    }
                    if (s.equals("INF") || s.equals("+INF")) {
                        r = new Float(Float.POSITIVE_INFINITY);
                        break;
                    }
                    if (s.equals("-INF")) {
                        r = new Float(Float.NEGATIVE_INFINITY);
                        break;
                    }
                    r = new Float(s);
                    break;
                }
                case 5: {
                    r = new Long(s);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        if (this.inclusiveLowerBound != null && this.less(r, this.inclusiveLowerBound)) {
            return null;
        }
        if (this.exclusiveLowerBound != null && !this.less(this.exclusiveLowerBound, r)) {
            return null;
        }
        if (this.inclusiveUpperBound != null && this.less(this.inclusiveUpperBound, r)) {
            return null;
        }
        if (this.exclusiveUpperBound != null && !this.less(r, this.exclusiveUpperBound)) {
            return null;
        }
        return r;
    }

    public String canonical(Object o) {
        String r = o.toString();
        if (r.equals("Infinity")) {
            r = "INF";
        } else if (r.equals("-Infinity")) {
            r = "-INF";
        }
        return r;
    }

    public boolean equal(Object a, Object b) {
        if (a == null || b == null) {
            return false;
        }
        String sa = a.toString();
        String sb = b.toString();
        if (sa.equals("NaN") || sa.equals("NaN")) {
            return false;
        }
        if (sa.equals("Infinity")) {
            return sb.equals("Infinity");
        }
        if (sa.equals("-Infinity")) {
            return sb.equals("-Infinity");
        }
        BigDecimal bda = new BigDecimal(sa);
        BigDecimal bdb = new BigDecimal(sb);
        return bda.equals(bdb);
    }

    public boolean less(Object a, Object b) {
        if (a == null || b == null) {
            return false;
        }
        String sa = a.toString();
        String sb = b.toString();
        if (sa.equals("NaN") || sa.equals("NaN")) {
            return false;
        }
        boolean isAPositiveInfinity = sa.equals("Infinity");
        boolean isANegativeInfinity = sa.equals("-Infinity");
        boolean isBPositiveInfinity = sb.equals("Infinity");
        boolean isBNegativeInfinity = sb.equals("-Infinity");
        if (isANegativeInfinity && isBNegativeInfinity) {
            return true;
        }
        if (isAPositiveInfinity && isBPositiveInfinity) {
            return true;
        }
        if (isANegativeInfinity) {
            return true;
        }
        if (isBPositiveInfinity) {
            return true;
        }
        if (isAPositiveInfinity) {
            return false;
        }
        if (isBNegativeInfinity) {
            return false;
        }
        BigDecimal bda = new BigDecimal(sa);
        BigDecimal bdb = new BigDecimal(sb);
        return bda.compareTo(bdb) < 0;
    }

    public Object getInclusiveUpperBound() {
        return this.inclusiveUpperBound;
    }

    public Object getExclusiveUpperBound() {
        return this.exclusiveUpperBound;
    }

    public Object getInclusiveLowerBound() {
        return this.inclusiveLowerBound;
    }

    public Object getExclusiveLowerBound() {
        return this.exclusiveLowerBound;
    }
}

