/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema;

import com.inqmy.lib.schema.SchemaException;
import com.inqmy.lib.schema.builtin.BuiltInManager;
import com.inqmy.lib.schema.generator.ErrorHandler;
import com.inqmy.lib.schema.generator.ErrorHandlerImpl0;
import com.inqmy.lib.schema.generator.Generator;
import com.inqmy.lib.schema.generator.SchemaCompiler;
import com.inqmy.lib.schema.generator.SchemaDecompiler;
import com.inqmy.lib.schema.generator.TreeWalker;
import com.inqmy.lib.schema.util.Tools;
import com.inqmy.lib.xml.names.XMLNameMapper;
import com.inqmy.lib.xml.parser.DocHandler;
import com.inqmy.lib.xml.parser.ParserException;
import com.inqmy.lib.xml.parser.XMLParser;
import com.inqmy.lib.xml.parser.handlers.NormalizeDocHandler;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Hashtable;

public final class Schema {
    private char[] code = new char[1000];
    private int nCode;
    private int[] strPtrs = new int[300];
    private int nStrPtrs;
    private XMLNameMapper mapper = null;
    private XMLParser parser = null;
    private BuiltInManager manager = null;
    private SchemaCompiler compiler = null;
    private SchemaDecompiler decompiler = null;
    private Generator generator = null;
    private TreeWalker walker = null;
    private ErrorHandler errorHandler = new ErrorHandlerImpl0();
    private CharArray ca0 = new CharArray();
    private String schemaNamespaceUsed;
    public Hashtable map = new Hashtable();
    public String prefix = "";
    public HashSet unique = new HashSet();
    private char NONE = (char)65535;

    public Schema() {
        this.compiler = new SchemaCompiler(this);
        this.decompiler = new SchemaDecompiler();
        this.generator = new Generator(this);
        try {
            this.parser = new XMLParser();
            this.parser.setNamespaces(true);
            this.parser.setNamespacePrefixes(false);
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        this.manager = new BuiltInManager();
        this.walker = new TreeWalker(this);
        this.mapper = new XMLNameMapper();
        this.clear();
    }

    public void clear() {
        this.nCode = 0;
        this.nStrPtrs = 0;
        this.schemaNamespaceUsed = null;
    }

    public SchemaCompiler getInputHandler() {
        return this.compiler;
    }

    public void loadCompiled(InputStream in) throws SchemaException {
        try {
            int x;
            this.nCode = 0;
            while ((x = in.read()) != -1) {
                int y = in.read();
                if (y == -1) {
                    throw new SchemaException("Illegal parity of loaded schema.");
                }
                this.code[this.nCode] = (char)((short)x << 8 | y);
                ++this.nCode;
            }
        }
        catch (SchemaException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new SchemaException(e1);
        }
        if (this.code[0] != '\uf0b1' || this.code[1] != '\ua666') {
            throw new SchemaException("Illegal magic number, probably this is not a compiled schema.");
        }
    }

    public void loadRaw(InputStream in) throws SchemaException {
        try {
            NormalizeDocHandler ndh = new NormalizeDocHandler();
            ndh.setCompactHandler(this.compiler);
            this.compiler.startRoot();
            this.parser.parse(in, (DocHandler)ndh);
            this.compiler.endRoot();
        }
        catch (Exception e) {
            throw new SchemaException(e);
        }
    }

    public void loadRaw(InputStream[] in) throws SchemaException {
        try {
            NormalizeDocHandler ndh = new NormalizeDocHandler();
            ndh.setCompactHandler(this.compiler);
            this.compiler.startRoot();
            int i = 0;
            while (i < in.length) {
                this.parser.parse(in[i], (DocHandler)ndh);
                ++i;
            }
            this.compiler.endRoot();
        }
        catch (Exception e) {
            throw new SchemaException(e);
        }
    }

    public void saveCompiled(OutputStream out) throws SchemaException {
        try {
            int i = 0;
            while (i < this.nCode) {
                byte x = (byte)(this.code[i] >> 8);
                byte y = (byte)this.code[i];
                out.write(x);
                out.write(y);
                ++i;
            }
            out.flush();
        }
        catch (Exception e) {
            throw new SchemaException(e);
        }
    }

    public void appendToCode(char[] a, int start, int end) throws SchemaException {
        this.assertCodeLength(this.nCode + end - start + 1);
        System.arraycopy(a, start, this.code, this.nCode, end - start);
        this.nCode += end - start;
    }

    public void appendToCode(char ch) throws SchemaException {
        this.assertCodeLength(this.nCode + 1);
        this.code[this.nCode] = ch;
        ++this.nCode;
    }

    public int getCodeSize() throws SchemaException {
        return this.nCode;
    }

    public void clearCode() throws SchemaException {
        this.nCode = 0;
        this.nStrPtrs = 0;
    }

    public boolean findStringInCode(CharArray a) throws SchemaException {
        int i = 0;
        while (i < this.nStrPtrs) {
            if (a.equals(this.code, this.strPtrs[i] + 1)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int addStringToCode(CharArray a) throws SchemaException {
        int i = 0;
        while (i < this.nStrPtrs) {
            if (a.equals(this.code, this.strPtrs[i] + 1)) {
                return this.strPtrs[i];
            }
            ++i;
        }
        int aSize = a.getSize();
        this.assertCodeLength(this.nCode + aSize + 2);
        this.code[this.nCode] = 2;
        this.code[this.nCode + 1 + aSize] = '\u0000';
        a.getChars(this.code, this.nCode + 1);
        int r = this.nCode;
        this.nCode += aSize + 2;
        if (this.nStrPtrs >= this.strPtrs.length) {
            int[] old = this.strPtrs;
            this.strPtrs = new int[old.length * 2];
            System.arraycopy(old, 0, this.strPtrs, 0, old.length);
        }
        this.strPtrs[this.nStrPtrs] = r;
        ++this.nStrPtrs;
        return r;
    }

    public int addQName(CharArray uri, CharArray localName) throws SchemaException {
        int u = this.addStringToCode(uri);
        int l = this.addStringToCode(localName);
        this.assertCodeLength(this.nCode + 4);
        this.code[this.nCode] = 3;
        this.code[this.nCode + 1] = (char)u;
        this.code[this.nCode + 2] = (char)l;
        this.code[this.nCode + 3] = '\u0001';
        this.nCode += 4;
        return this.nCode - 4;
    }

    private void assertCodeLength(int l) throws SchemaException {
        if (this.code.length < l) {
            char[] codeOld = this.code;
            this.code = new char[this.code.length * 2];
            System.arraycopy(codeOld, 0, this.code, 0, codeOld.length);
        }
    }

    public char[] getCode() throws SchemaException {
        return this.code;
    }

    public void decompile(OutputStream out) throws SchemaException {
        this.updateAll();
        this.decompiler.decompile(this, out);
    }

    public void decompile() throws SchemaException {
        this.decompile(System.out);
    }

    public ErrorHandler getErrorHandler() throws SchemaException {
        return this.errorHandler;
    }

    private void rec(File dir, int p) throws SchemaException {
        switch (this.code[p]) {
            case '\u000e': {
                this.generator.generate(p, dir);
                break;
            }
            case '\u000f': {
                this.generator.generate(p, dir);
                break;
            }
        }
        int x = p + 1;
        while (this.code[x] != '\u0001') {
            if (this.code[x] == '\u00c8') {
                this.rec(dir, this.code[x + 1]);
            }
            x += 2;
        }
    }

    public void generateAll(File dir, String packageName) throws SchemaException {
        if (this.map == null) {
            this.map = new Hashtable();
        }
        packageName = packageName == null ? "" : packageName;
        this.map.put("*", packageName);
        if (packageName.length() == 0) {
            this.map.put("http://schemas.xmlsoap.org/soap/encoding/", "soapenc");
        } else {
            this.map.put("http://schemas.xmlsoap.org/soap/encoding/", packageName + ".soapenc");
        }
        this.generateAll(dir);
    }

    public void generateAll(File dir) throws SchemaException {
        dir.mkdirs();
        this.generator.clearTypeMappingRegistry();
        int i = this.code[2] + '\u0001';
        while (this.code[i] != '\u0001') {
            this.rec(dir, this.code[i + 1]);
            i += 2;
        }
    }

    public BuiltInManager getManager() {
        return this.manager;
    }

    public String getClassOfType(int t) throws SchemaException {
        if (t <= 0) {
            return "com.inqmy.lib.schema.builtin.XS_" + BuiltInManager.getName(-t);
        }
        if (this.code[t] == '\u000f' || this.code[t] == '\u000e') {
            return this.walker.getNameOfType(t);
        }
        throw new SchemaException("Neither built-in, nor SIMPLE_TYPE, nor COMPLEX_TYPE.");
    }

    public boolean isSimple(int t) throws SchemaException {
        if (t <= 0) {
            return true;
        }
        if (this.code[t] == '\u000e') {
            return true;
        }
        if (this.code[t] == '\u000f') {
            return false;
        }
        throw new SchemaException("Neither built-in, nor SIMPLE_TYPE, nor COMPLEX_TYPE.");
    }

    public String getJavaPrimitive(int t) throws SchemaException {
        if (t <= 0) {
            return BuiltInManager.getJavaType(-t);
        }
        if (this.code[t] == '\u000f') {
            throw new SchemaException("Not a simple type.");
        }
        return BuiltInManager.getJavaType(-this.walker.getBIDOf(t));
    }

    public int getType(String u, String l) throws SchemaException {
        int t = this.walker.findTopLevelType(u, l);
        if (t == 1) {
            throw new SchemaException("Top level type " + Tools.formatQName(u, l) + " not found.");
        }
        return t;
    }

    public int getElementType(String u, String l) throws SchemaException {
        int e = this.walker.findTopLevelElementOrAttribute(u, l);
        if (e == -1) {
            throw new SchemaException("Top-level element " + Tools.formatQName(u, l) + " not found.");
        }
        if (this.code[e] == '\f') {
            throw new SchemaException("Not an element, but an attribute");
        }
        int t = this.walker.getTypeOf(e);
        if (t == 1) {
            throw new SchemaException("Type of element " + Tools.formatQName(u, l) + " not found.");
        }
        return t;
    }

    public boolean isSoapArray(int t) throws SchemaException {
        return this.walker.isSoapArray(t);
    }

    public void updateAll() throws SchemaException {
        this.compiler.update();
        this.generator.update();
        this.parser.setNamespaces(true);
        this.parser.setNamespacePrefixes(false);
        this.walker.update();
    }

    public XMLParser getParser() {
        return this.parser;
    }

    public TreeWalker getWalker() {
        return this.walker;
    }

    public XMLNameMapper getMapper() {
        return this.mapper;
    }

    public void setSchemaNamespaceUsed(String snu) {
        this.schemaNamespaceUsed = snu;
    }

    public String getSchemaNamespaceUsed() {
        return this.schemaNamespaceUsed;
    }

    public boolean setGeneratorOption(String name, boolean value) throws SchemaException {
        return this.generator.setOption(name, value);
    }

    public void generateTypeMappingRegistry(PrintStream out) throws SchemaException {
        this.generator.generateTypeMappingRegistry(out);
    }

    public void generateTypeMappingRegistry(PrintWriter out) throws SchemaException {
        this.generator.generateTypeMappingRegistry(out);
    }

    public Hashtable getComplexTypeInfo() {
        return this.generator.getComplexFieldInfo();
    }
}

