/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.jaxp;

import com.inqmy.lib.jaxp.AssociationFindingDocHandler;
import com.inqmy.lib.jaxp.DocHandlerResult;
import com.inqmy.lib.jaxp.EmptyErrorListener;
import com.inqmy.lib.jaxp.TemplatesHandlerImpl;
import com.inqmy.lib.jaxp.TemplatesImpl;
import com.inqmy.lib.jaxp.TransformerHandlerImpl;
import com.inqmy.lib.jaxp.TransformerImpl;
import com.inqmy.lib.xml.parser.ParserException;
import com.inqmy.lib.xml.parser.SAXFilter;
import java.util.HashSet;
import java.util.Hashtable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.XMLFilter;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    private static final HashSet SUPPORTED_FEATURES = new HashSet();
    private Hashtable attributes = new Hashtable();
    private URIResolver uriResolver = null;
    private ErrorListener errorListener = new EmptyErrorListener();
    public static final String EXT_CLASSLOADER = "http://sap.com/java/xslt/ext-classloader";

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        TemplatesImpl tImpl = new TemplatesImpl(source, this.uriResolver);
        tImpl.setExtensionClassLoader((ClassLoader)this.getAttribute(EXT_CLASSLOADER));
        return tImpl;
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        TemplatesImpl tImpl = new TemplatesImpl(source, this.uriResolver);
        tImpl.setExtensionClassLoader((ClassLoader)this.getAttribute(EXT_CLASSLOADER));
        return tImpl.newTransformer();
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        TransformerImpl t = new TransformerImpl(null, null, this.uriResolver);
        return t;
    }

    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        AssociationFindingDocHandler handler = new AssociationFindingDocHandler();
        DocHandlerResult temp = new DocHandlerResult(handler.init(media, title, charset));
        try {
            this.newTransformer().transform(source, temp);
        }
        catch (Exception _) {
            return handler.getAssociation();
        }
        return null;
    }

    public boolean getFeature(String s) {
        return SUPPORTED_FEATURES.contains(s);
    }

    public Object getAttribute(String s) throws IllegalArgumentException {
        return this.attributes.get(s);
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setURIResolver(URIResolver r) {
        this.uriResolver = r;
    }

    public void setAttribute(String s, Object obj) throws IllegalArgumentException {
        if (s == null || obj == null) {
            throw new IllegalArgumentException();
        }
        this.attributes.put(s, obj);
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (errorListener == null) {
            throw new IllegalArgumentException();
        }
        this.errorListener = errorListener;
    }

    public TransformerHandler newTransformerHandler(Source src) throws TransformerConfigurationException {
        return new TransformerHandlerImpl(TransformerFactory.newInstance().newTemplates(src));
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        return new TransformerHandlerImpl(templates);
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        return new TransformerHandlerImpl();
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new TemplatesHandlerImpl();
    }

    public XMLFilter newXMLFilter(Source src) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(src);
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        try {
            return new SAXFilter(templates);
        }
        catch (ParserException e) {
            throw new TransformerConfigurationException("Cannot create XMLFilter: " + e, e);
        }
    }

    static {
        SUPPORTED_FEATURES.add("http://javax.xml.transform.sax.SAXSource/feature");
        SUPPORTED_FEATURES.add("http://javax.xml.transform.sax.SAXResult/feature");
        SUPPORTED_FEATURES.add("http://javax.xml.transform.dom.DOMSource/feature");
        SUPPORTED_FEATURES.add("http://javax.xml.transform.dom.DOMResult/feature");
        SUPPORTED_FEATURES.add("http://javax.xml.transform.stream.StreamSource/feature");
        SUPPORTED_FEATURES.add("http://javax.xml.transform.stream.StreamResult/feature");
        SUPPORTED_FEATURES.add("http://javax.xml.transform.sax.SAXTransformerFactory/feature");
        SUPPORTED_FEATURES.add("http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter");
    }
}

