/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.jaxp;

import com.inqmy.lib.jaxp.InstanceManager;
import com.inqmy.lib.jaxp.TransformerImpl;
import com.inqmy.lib.xml.parser.DOMParser;
import com.inqmy.lib.xml.parser.SAXParser;
import com.inqmy.lib.xml.util.SAXToDOMHandler;
import com.inqmy.lib.xsl.xslt.XSLException;
import com.inqmy.lib.xsl.xslt.XSLOutputNode;
import com.inqmy.lib.xsl.xslt.XSLStylesheet;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class TemplatesImpl
implements Templates {
    static ResourceBundle res = ResourceBundle.getBundle("com.inqmy.lib.jaxp.Res");
    private XSLStylesheet sheet;
    private Properties outputProperties;
    private DOMSource stylesheetDomSource;
    private URIResolver stylesheetUriResolver;
    private ClassLoader extensionClassLoader;

    protected void setExtensionClassLoader(ClassLoader extensionClassLoader) {
        this.extensionClassLoader = extensionClassLoader;
    }

    protected TemplatesImpl(Source source, URIResolver uriResolver) throws TransformerConfigurationException {
        block15: {
            this.outputProperties = new Properties(TransformerImpl.DEFAULT_OUTPUT_PROPERTIES);
            this.stylesheetDomSource = null;
            this.stylesheetUriResolver = null;
            this.extensionClassLoader = null;
            if (source == null) {
                throw new IllegalArgumentException(res.getString("XSL_Source_is_null_"));
            }
            try {
                this.stylesheetUriResolver = uriResolver;
                if (source instanceof DOMSource) {
                    this.stylesheetDomSource = new DOMSource(((DOMSource)source).getNode(), source.getSystemId());
                    break block15;
                }
                if (source instanceof SAXSource) {
                    InputSource inputSource;
                    SAXSource s = (SAXSource)source;
                    XMLReader xmlReader = s.getXMLReader();
                    if (xmlReader == null) {
                        xmlReader = new SAXParser();
                    }
                    if ((inputSource = s.getInputSource()) == null) {
                        throw new TransformerException(res.getString("SAXSource_whose"));
                    }
                    SAXToDOMHandler handler = new SAXToDOMHandler();
                    xmlReader.setContentHandler(handler);
                    xmlReader.setDTDHandler(handler);
                    xmlReader.setEntityResolver(handler);
                    xmlReader.setErrorHandler(handler);
                    xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
                    xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                    xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
                    xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                    xmlReader.parse(inputSource);
                    this.stylesheetDomSource = new DOMSource(handler.getRoot(), s.getSystemId());
                    break block15;
                }
                if (source instanceof StreamSource) {
                    InputSource inputSource;
                    InputStream inputStream = ((StreamSource)source).getInputStream();
                    Reader reader = ((StreamSource)source).getReader();
                    String id = ((StreamSource)source).getSystemId();
                    boolean hasId = false;
                    if (inputStream != null) {
                        inputSource = new InputSource(inputStream);
                    } else if (reader != null) {
                        inputSource = new InputSource(reader);
                    } else if (id != null) {
                        inputSource = new InputSource(id);
                        hasId = true;
                    } else {
                        throw new TransformerException(res.getString("StreamSource_whose"));
                    }
                    DOMParser domParser = new DOMParser();
                    domParser.setFeature("http://inqmy.org/dom/features/trim-white-spaces", false);
                    domParser.setFeature("http://xml.org/sax/features/namespaces", true);
                    domParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                    Document document = domParser.parse(inputSource);
                    this.stylesheetDomSource = new DOMSource(document, source.getSystemId());
                    break block15;
                }
                throw new TransformerException(res.getString("Only_output_to"));
            }
            catch (XSLException e) {
                e.printStackTrace();
                throw new TransformerConfigurationException("Could not load stylesheet. " + e, e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TransformerConfigurationException("Could not load stylesheet. " + e, e);
            }
        }
    }

    public synchronized Transformer newTransformer() throws TransformerConfigurationException {
        try {
            try {
                this.sheet = InstanceManager.getXSLStylesheet();
                this.sheet.setExtClassLoader(this.extensionClassLoader);
                this.sheet.init(this.stylesheetDomSource, this.stylesheetUriResolver, 0);
                this.setOutputProperties(this.sheet.getOutputProperties());
                if (!this.sheet.isIndentAllowed()) {
                    this.outputProperties.setProperty("indent", "no");
                }
                TransformerImpl transformerImpl = new TransformerImpl(this.sheet, this.getOutputProperties(), this.stylesheetUriResolver);
                Object var3_3 = null;
                this.sheet = null;
                return transformerImpl;
            }
            catch (XSLException e) {
                e.printStackTrace();
                throw new TransformerConfigurationException("Could not load stylesheet." + e, e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.sheet = null;
            throw throwable;
        }
    }

    public synchronized Properties getOutputProperties() {
        NodeList nl;
        if (this.stylesheetDomSource != null && this.sheet == null && (nl = ((Document)this.stylesheetDomSource.getNode()).getElementsByTagNameNS("http://www.w3.org/1999/XSL/Transform", "output")).getLength() > 0 && !"".equals(((Element)nl.item(0)).getAttribute("method"))) {
            this.setNonNullOutputProperty("method", ((Element)nl.item(0)).getAttribute("method"));
        }
        return (Properties)((Hashtable)this.outputProperties).clone();
    }

    private void setOutputProperties(XSLOutputNode o) {
        ((Hashtable)this.outputProperties).clear();
        if (o == null) {
            return;
        }
        this.setNonNullOutputProperty("cdata-section-elements", o.getCdataSectionElements());
        this.setNonNullOutputProperty("doctype-public", o.getDoctypePublic());
        this.setNonNullOutputProperty("doctype-system", o.getDoctypeSystem());
        this.setNonNullOutputProperty("encoding", o.getEncoding());
        this.setNonNullOutputProperty("indent", o.getIndent());
        this.setNonNullOutputProperty("media-type", o.getMediaType());
        this.setNonNullOutputProperty("method", o.getMethod());
        this.setNonNullOutputProperty("omit-xml-declaration", o.getOmitXmlDeclaration());
        this.setNonNullOutputProperty("standalone", o.getStandalone());
        this.setNonNullOutputProperty("version", o.getVersion());
    }

    private void setNonNullOutputProperty(String key, String value) {
        if (value != null) {
            this.outputProperties.setProperty(key, value);
        }
    }
}

