/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.jaxp;

import com.inqmy.lib.jaxp.DocumentBuilderFactoryImpl;
import com.inqmy.lib.schema.SchemaException;
import com.inqmy.lib.schema.validator.SchemaValidator;
import com.inqmy.lib.xml.dom.DOMImplementationImpl;
import com.inqmy.lib.xml.dom.DocumentImpl;
import com.inqmy.lib.xml.parser.DOMParser;
import java.io.IOException;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DocumentBuilderImpl
extends DocumentBuilder {
    private DOMParser domParser = null;
    private ErrorHandler errorHandler = new DefaultHandler();
    private boolean bValidation = false;
    private Object schemaLocationProperty = null;
    private boolean bSchemaAware = false;
    private EntityResolver entRes = null;

    protected DocumentBuilderImpl(DocumentBuilderFactoryImpl factory) throws ParserConfigurationException {
        try {
            this.domParser = new DOMParser();
            this.bValidation = factory.isValidating();
            try {
                this.domParser.setFeature("http://inqmy.org/dom/features/trim-white-spaces", factory.isIgnoringElementContentWhitespace());
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            try {
                this.domParser.setFeature("http://xml.org/sax/features/namespaces", factory.isNamespaceAware());
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            try {
                this.domParser.setIgnoringComments(factory.isIgnoringComments());
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            try {
                this.domParser.setFeature("http://inqmy.com/dom/exanding-references", factory.isExpandEntityReferences());
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            Enumeration e = factory.attributes.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                Object v = factory.attributes.get(k);
                if (k.equals("http://www.inqmy.com/schema") || k.equals("http://sap.com/xml/schema-source")) {
                    this.schemaLocationProperty = v;
                    continue;
                }
                if (k.equals("http://sap.com/xml/schema-awareness") && v.equals(Boolean.TRUE)) {
                    this.bSchemaAware = true;
                    continue;
                }
                if (k.equals("http://sap.com/xml/schema-awareness") && v.equals(Boolean.FALSE)) {
                    this.bSchemaAware = false;
                    continue;
                }
                this.domParser.setProperty(k, v);
            }
        }
        catch (ParserConfigurationException pce) {
            throw pce;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ParserConfigurationException();
        }
    }

    public boolean isNamespaceAware() {
        try {
            return this.domParser.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setEntityResolver(EntityResolver er) {
        this.entRes = er;
        this.domParser.setEntityResolver(er);
    }

    public Document newDocument() {
        return new DocumentImpl();
    }

    public DOMImplementation getDOMImplementation() {
        return new DOMImplementationImpl();
    }

    public void setErrorHandler(ErrorHandler eh) {
        if (eh == null) {
            throw new IllegalArgumentException();
        }
        this.domParser.setErrorHandler(eh);
    }

    public boolean isValidating() {
        try {
            return this.domParser.getFeature("http://xml.org/sax/features/validation");
        }
        catch (Exception e) {
            return false;
        }
    }

    public Document parse(InputSource is) throws IOException, SAXException, IllegalArgumentException {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.domParser.setFeature("http://xml.org/sax/features/validation", this.bValidation);
            Document r = this.domParser.parse(is);
            this.domParser.setDocument(null);
            if (this.schemaLocationProperty != null || this.bSchemaAware) {
                this.attemptSchemaValidation(r);
            }
            return r;
        }
        catch (IOException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void attemptSchemaValidation(Document xml) throws SAXException {
        SchemaValidator v = new SchemaValidator();
        if (this.entRes != null) {
            v.setEntityResolver(this.entRes);
        }
        try {
            boolean b;
            if (this.schemaLocationProperty != null) {
                if (this.schemaLocationProperty instanceof String) {
                    b = v.validate(new DOMSource(xml), new StreamSource((String)this.schemaLocationProperty));
                } else {
                    if (!(this.schemaLocationProperty instanceof Source)) throw new SAXException("The value of the schema location property can be a java.lang.String, or javax.xml.transform.Source");
                    b = v.validate(new DOMSource(xml), (Source)this.schemaLocationProperty);
                }
            } else {
                b = v.validate(xml);
            }
            if (b) return;
            throw new SAXException("Schema validation failed: " + v.getDescriptionOfTheFirstError());
        }
        catch (SchemaException e) {
            throw new SAXException(e);
        }
    }
}

