/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.concurrent.Semaphore;

public final class WaiterPreferenceSemaphore
extends Semaphore {
    protected long waitsCount = 0L;

    public WaiterPreferenceSemaphore(long initial) {
        super(initial);
    }

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        WaiterPreferenceSemaphore waiterPreferenceSemaphore = this;
        synchronized (waiterPreferenceSemaphore) {
            if (this.permitsCount > this.waitsCount) {
                --this.permitsCount;
                return;
            }
            ++this.waitsCount;
            try {
                do {
                    this.wait();
                } while (this.permitsCount <= 0L);
                --this.waitsCount;
                --this.permitsCount;
                return;
            }
            catch (InterruptedException ex) {
                --this.waitsCount;
                this.notify();
                throw ex;
            }
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        WaiterPreferenceSemaphore waiterPreferenceSemaphore = this;
        synchronized (waiterPreferenceSemaphore) {
            if (this.permitsCount > this.waitsCount) {
                --this.permitsCount;
                boolean bl = true;
                return bl;
            }
            if (msecs <= 0L) {
                boolean bl = false;
                return bl;
            }
            ++this.waitsCount;
            long startTime = System.currentTimeMillis();
            long waitTime = msecs;
            try {
                do {
                    this.wait(waitTime);
                    if (this.permitsCount <= 0L) continue;
                    --this.waitsCount;
                    --this.permitsCount;
                    boolean bl = true;
                    return bl;
                } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
                --this.waitsCount;
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException ex) {
                --this.waitsCount;
                this.notify();
                throw ex;
            }
        }
    }

    public synchronized void release() {
        ++this.permitsCount;
        this.notify();
    }

    public synchronized void release(long n) {
        this.permitsCount += n;
        long i = 0L;
        while (i < n) {
            this.notify();
            ++i;
        }
    }
}

