/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.concurrent.BoundedChannel;
import com.sap.engine.lib.util.concurrent.Semaphore;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class SemaphoreControlledChannel
implements BoundedChannel {
    protected final Semaphore putGuardSync;
    protected final Semaphore takeGuardSync;
    protected int capacityNumber;

    public SemaphoreControlledChannel(int capacity) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacityNumber = capacity;
        this.putGuardSync = new Semaphore(capacity);
        this.takeGuardSync = new Semaphore(0L);
    }

    public SemaphoreControlledChannel(int capacity, Class semaphoreClass) throws IllegalArgumentException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacityNumber = capacity;
        Class[] intarg = new Class[]{Integer.TYPE};
        Constructor ctor = semaphoreClass.getDeclaredConstructor(intarg);
        Object[] cap = new Integer[]{new Integer(capacity)};
        this.putGuardSync = (Semaphore)ctor.newInstance(cap);
        Object[] zero = new Integer[]{new Integer(0)};
        this.takeGuardSync = (Semaphore)ctor.newInstance(zero);
    }

    public int capacity() {
        return this.capacityNumber;
    }

    public int size() {
        return (int)this.takeGuardSync.permits();
    }

    protected abstract void insert(Object var1);

    protected abstract Object extract();

    public void put(Object x) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.putGuardSync.acquire();
        try {
            this.insert(x);
            this.takeGuardSync.release();
        }
        catch (ClassCastException ex) {
            this.putGuardSync.release();
            throw ex;
        }
    }

    public boolean offer(Object x, long msecs) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.putGuardSync.attempt(msecs)) {
            return false;
        }
        try {
            this.insert(x);
            this.takeGuardSync.release();
            return true;
        }
        catch (ClassCastException ex) {
            this.putGuardSync.release();
            throw ex;
        }
    }

    public Object take() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.takeGuardSync.acquire();
        try {
            Object x = this.extract();
            this.putGuardSync.release();
            return x;
        }
        catch (ClassCastException ex) {
            this.takeGuardSync.release();
            throw ex;
        }
    }

    public Object poll(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.takeGuardSync.attempt(msecs)) {
            return null;
        }
        try {
            Object x = this.extract();
            this.putGuardSync.release();
            return x;
        }
        catch (ClassCastException ex) {
            this.takeGuardSync.release();
            throw ex;
        }
    }

    public abstract Object peek();
}

