/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.concurrent.Sync;

public class Semaphore
implements Sync {
    protected long permitsCount;

    public Semaphore(long initialPermits) {
        this.permitsCount = initialPermits;
    }

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                while (this.permitsCount <= 0L) {
                    this.wait();
                }
                --this.permitsCount;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.permitsCount > 0L) {
                --this.permitsCount;
                boolean bl = true;
                return bl;
            }
            if (msecs <= 0L) {
                boolean bl = false;
                return bl;
            }
            try {
                long startTime = System.currentTimeMillis();
                long waitTime = msecs;
                do {
                    this.wait(waitTime);
                    if (this.permitsCount <= 0L) continue;
                    --this.permitsCount;
                    boolean bl = true;
                    return bl;
                } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public synchronized void release() {
        ++this.permitsCount;
        this.notify();
    }

    public synchronized void release(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Negative argument");
        }
        this.permitsCount += n;
        long i = 0L;
        while (i < n) {
            this.notify();
            ++i;
        }
    }

    public synchronized long permits() {
        return this.permitsCount;
    }
}

