/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.concurrent.Sync;

public class ReentrantLock
implements Sync {
    protected Thread ownerThread = null;
    protected long holdsCount = 0L;

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Thread caller = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (caller == this.ownerThread) {
                ++this.holdsCount;
            } else {
                try {
                    while (this.ownerThread != null) {
                        this.wait();
                    }
                    this.ownerThread = caller;
                    this.holdsCount = 1L;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Thread caller = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (caller == this.ownerThread) {
                ++this.holdsCount;
                boolean bl = true;
                return bl;
            }
            if (this.ownerThread == null) {
                this.ownerThread = caller;
                this.holdsCount = 1L;
                boolean bl = true;
                return bl;
            }
            if (msecs <= 0L) {
                boolean bl = false;
                return bl;
            }
            long waitTime = msecs;
            long start = System.currentTimeMillis();
            try {
                do {
                    this.wait(waitTime);
                    if (caller == this.ownerThread) {
                        ++this.holdsCount;
                        boolean bl = true;
                        return bl;
                    }
                    if (this.ownerThread != null) continue;
                    this.ownerThread = caller;
                    this.holdsCount = 1L;
                    boolean bl = true;
                    return bl;
                } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public synchronized void release() {
        if (Thread.currentThread() != this.ownerThread) {
            throw new Error("Illegal Lock usage");
        }
        if (--this.holdsCount == 0L) {
            this.ownerThread = null;
            this.notify();
        }
    }

    public synchronized void release(long n) {
        if (Thread.currentThread() != this.ownerThread || n > this.holdsCount) {
            throw new Error("Illegal Lock usage");
        }
        this.holdsCount -= n;
        if (this.holdsCount == 0L) {
            this.ownerThread = null;
            this.notify();
        }
    }

    public synchronized long holds() {
        if (Thread.currentThread() != this.ownerThread) {
            return 0L;
        }
        return this.holdsCount;
    }
}

