/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.concurrent.Channel;
import com.sap.engine.lib.util.concurrent.LinkedNode;

public class LinkedQueue
implements Channel {
    protected LinkedNode headNode;
    protected final Object putLockObject = new Object();
    protected LinkedNode lastNode = this.headNode = new LinkedNode(null);
    protected int waitingForTake_ = 0;

    protected void insert(Object x) {
        Object object = this.putLockObject;
        synchronized (object) {
            LinkedNode p = new LinkedNode(x);
            LinkedNode linkedNode = this.lastNode;
            synchronized (linkedNode) {
                this.lastNode.next = p;
                this.lastNode = p;
            }
            if (this.waitingForTake_ > 0) {
                this.putLockObject.notify();
            }
        }
    }

    protected synchronized Object extract() {
        LinkedNode linkedNode = this.headNode;
        synchronized (linkedNode) {
            Object x = null;
            LinkedNode first = this.headNode.next;
            if (first != null) {
                x = first.value;
                first.value = null;
                this.headNode = first;
            }
            Object object = x;
            return object;
        }
    }

    public void put(Object x) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.insert(x);
    }

    public boolean offer(Object x, long msecs) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.insert(x);
        return true;
    }

    public Object take() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.putLockObject;
        synchronized (object) {
            try {
                ++this.waitingForTake_;
                while (true) {
                    if ((x = this.extract()) != null) {
                        --this.waitingForTake_;
                        Object object2 = x;
                        return object2;
                    }
                    this.putLockObject.wait();
                }
            }
            catch (InterruptedException ex) {
                --this.waitingForTake_;
                this.putLockObject.notify();
                throw ex;
            }
        }
    }

    public Object peek() {
        LinkedNode linkedNode = this.headNode;
        synchronized (linkedNode) {
            LinkedNode first = this.headNode.next;
            if (first != null) {
                Object object = first.value;
                return object;
            }
            Object var3_4 = null;
            return var3_4;
        }
    }

    public boolean isEmpty() {
        LinkedNode linkedNode = this.headNode;
        synchronized (linkedNode) {
            boolean bl = this.headNode.next == null;
            return bl;
        }
    }

    public Object poll(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.putLockObject;
        synchronized (object) {
            try {
                long waitTime = msecs;
                long start = msecs <= 0L ? 0L : System.currentTimeMillis();
                ++this.waitingForTake_;
                while (true) {
                    if ((x = this.extract()) != null || waitTime <= 0L) {
                        --this.waitingForTake_;
                        Object object2 = x;
                        return object2;
                    }
                    this.putLockObject.wait(waitTime);
                    waitTime = msecs - (System.currentTimeMillis() - start);
                }
            }
            catch (InterruptedException ex) {
                --this.waitingForTake_;
                this.putLockObject.notify();
                throw ex;
            }
        }
    }
}

