/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.concurrent.Sync;

public class LayeredSync
implements Sync {
    protected final Sync outerSync;
    protected final Sync innerSync;

    public LayeredSync(Sync outer, Sync inner) {
        this.outerSync = outer;
        this.innerSync = inner;
    }

    public void acquire() throws InterruptedException {
        this.outerSync.acquire();
        try {
            this.innerSync.acquire();
        }
        catch (InterruptedException ex) {
            this.outerSync.release();
            throw ex;
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        long start = msecs <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = msecs;
        if (this.outerSync.attempt(waitTime)) {
            try {
                if (msecs > 0L) {
                    waitTime = msecs - (System.currentTimeMillis() - start);
                }
                if (this.innerSync.attempt(waitTime)) {
                    return true;
                }
                this.outerSync.release();
                return false;
            }
            catch (InterruptedException ex) {
                this.outerSync.release();
                throw ex;
            }
        }
        return false;
    }

    public void release() {
        this.innerSync.release();
        this.outerSync.release();
    }
}

