/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.cache.pool.soft;

import com.sap.engine.lib.util.PoolInstanceCreator;
import com.sap.engine.lib.util.PoolObjectWithCreator;
import com.sap.engine.lib.util.cache.pool.soft.Pool;
import com.sap.engine.lib.util.cache.pool.soft.PoolItem;
import java.lang.ref.ReferenceQueue;

public class SoftPool
implements Runnable {
    protected static ReferenceQueue queue = new ReferenceQueue();
    private static Pool weakPool = new Pool();
    private PoolInstanceCreator objFactory = null;
    private Thread thread = null;
    private boolean interrupted = false;
    private int count = 0;
    private PoolObjectWithCreator stable = null;
    private int stableSize = 0;

    public SoftPool(int _stableSize, PoolInstanceCreator _objFactory) {
        this.stableSize = _stableSize;
        this.objFactory = _objFactory;
        this.stable = new PoolObjectWithCreator(this.objFactory);
    }

    public Object get() {
        if (this.count == 0) {
            boolean flag = true;
            while (flag && this.count <= this.stableSize) {
                PoolItem item = weakPool.get();
                if (item == null) break;
                Object result = item.get();
                this.stable.releaseObject(result);
                flag = weakPool.remove(item);
                ++this.count;
            }
            if (this.count == 0) {
                return this.objFactory.newInstance();
            }
        }
        return this.stable.getObject();
    }

    public void put(Object obj) {
        if (this.count >= this.stableSize) {
            weakPool.put(new PoolItem(obj));
        }
        this.stable.releaseObject(obj);
        ++this.count;
    }

    public void stop() {
        this.interrupted = true;
        this.stable.freeMemory();
        this.thread.interrupt();
    }

    public void run() {
        this.thread = Thread.currentThread();
        Thread.currentThread().setName("SAP J2EE Engine|SoftPool GarbageCollector Daemon");
        while (true) {
            if (this.interrupted) break;
            try {
                PoolItem removed = (PoolItem)queue.remove();
                weakPool.remove(removed);
                --this.count;
            }
            catch (InterruptedException inEx) {
                this.interrupted = true;
            }
        }
        this.stable.freeMemory();
        weakPool = null;
    }
}

