/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.cache;

import com.sap.engine.lib.util.cache.CacheGroup;
import com.sap.engine.lib.util.cache.CacheGroupException;
import com.sap.engine.lib.util.cache.CacheListener;
import com.sap.engine.lib.util.cache.CacheQueue;
import com.sap.engine.lib.util.cache.CacheQueueItem;
import com.sap.engine.lib.util.cache.CacheQueueLRU;
import com.sap.engine.lib.util.cache.SoftValue;
import com.sap.engine.lib.util.cache.SoftValueHashMap;
import com.sap.engine.lib.util.cache.StableCacheObject;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Cache {
    private Map cache = new Hashtable();
    private CacheQueue cacheLRU = new CacheQueueLRU();
    private SoftValueHashMap softCache = null;
    private CacheGroup group = null;
    private boolean withoutWeakPart = false;

    public Cache() {
        this(new CacheQueueLRU());
        this.withoutWeakPart = true;
    }

    public Cache(int min, int max) {
        this(new CacheQueueLRU(min, max));
        this.withoutWeakPart = true;
    }

    public Cache(CacheGroup _group) {
        this(new CacheQueueLRU());
        this.group = _group;
        this.softCache = new SoftValueHashMap(this.group);
    }

    public Cache(int min, int max, CacheGroup _group) {
        this(new CacheQueueLRU(min, max));
        this.group = _group;
        this.softCache = new SoftValueHashMap(this.group);
    }

    private Cache(CacheQueue cacheLRU) {
        this.cacheLRU = cacheLRU;
    }

    public synchronized Object lookupCache(Object key) {
        CacheQueueItem cItem = (CacheQueueItem)this.cache.get(key);
        if (cItem != null) {
            this.cacheLRU.update(cItem);
            return cItem.value;
        }
        return null;
    }

    public synchronized void addCache(Object _key, Object _value) {
        if (!this.withoutWeakPart && this.group.stopFlag) {
            throw new CacheGroupException();
        }
        CacheQueueItem qi = new CacheQueueItem();
        qi.value = _value;
        qi.key = _key;
        qi.cacheType = (short)2;
        if (this.cache.containsKey(_key)) {
            this.remove(_key);
            this.cacheLRU.add(qi);
            this.cache.put(_key, qi);
            return;
        }
        CacheQueue cacheQueue = this.cacheLRU;
        synchronized (cacheQueue) {
            CacheQueueItem removed = this.cacheLRU.add(qi);
            this.cache.put(_key, qi);
            if (removed != null) {
                this.cache.remove(removed.key);
                if (this.withoutWeakPart) {
                    ((StableCacheObject)removed.value).cacheFinalization();
                } else if (removed.value != null) {
                    this.softCache.put(removed.key, removed.value, false);
                }
                removed = null;
            }
        }
    }

    public void addToWeakCache(Object _key, Object _value) {
        if (this.withoutWeakPart) {
            throw new RuntimeException("This instance of Cache does not have weak part. The operation is not alowed");
        }
        if (this.group.stopFlag) {
            throw new CacheGroupException();
        }
        this.softCache.put(_key, _value, true);
    }

    public synchronized Object getByKey(Object _key) {
        if (!this.withoutWeakPart && this.group.stopFlag) {
            throw new CacheGroupException();
        }
        if (this.cache.containsKey(_key)) {
            CacheQueueItem cItem = (CacheQueueItem)this.cache.get(_key);
            this.cacheLRU.update(cItem);
            return cItem.value;
        }
        if (!this.withoutWeakPart && this.softCache != null && this.softCache.containsKey(_key)) {
            SoftValue result = (SoftValue)this.softCache.get(_key);
            if (!result.alwaysInWeak) {
                Object value = result.get();
                if (value != null) {
                    this.addCache(_key, result.get());
                }
                this.softCache.remove(_key);
            }
            return result.get();
        }
        return null;
    }

    public synchronized boolean remove(Object _key) {
        if (!this.withoutWeakPart && this.group.stopFlag) {
            throw new CacheGroupException();
        }
        CacheQueueItem qi = null;
        boolean result = false;
        if (this.cache.containsKey(_key)) {
            qi = (CacheQueueItem)this.cache.remove(_key);
            this.cacheLRU.remove(qi);
            qi = null;
            result = true;
        } else if (!this.withoutWeakPart && this.softCache.containsKey(_key)) {
            this.softCache.remove(_key);
            return true;
        }
        return result;
    }

    public int allSize() {
        if (!this.withoutWeakPart) {
            return this.cache.size() + this.softCache.size();
        }
        return this.cache.size();
    }

    public int stableSize() {
        return this.cache.size();
    }

    public synchronized Iterator stableKeyIterator() {
        return this.cache.keySet().iterator();
    }

    public synchronized Iterator weakKeyIterator() {
        if (!this.withoutWeakPart) {
            return this.softCache.keySet().iterator();
        }
        return ((AbstractList)new Vector()).iterator();
    }

    public synchronized Set stableKeySet() {
        return this.cache.keySet();
    }

    public Set weakKeySet() {
        if (!this.withoutWeakPart) {
            return this.softCache.keySet();
        }
        return new HashSet();
    }

    public synchronized Iterator keyIterator() {
        return new Iterator(){
            Iterator i1;
            Iterator i2;
            {
                this.i1 = Cache.this.stableKeyIterator();
                this.i2 = Cache.this.weakKeyIterator();
            }

            public boolean hasNext() {
                if (this.i1.hasNext()) {
                    return true;
                }
                return this.i2.hasNext();
            }

            public Object next() {
                if (this.i1.hasNext()) {
                    return this.i1.next();
                }
                if (this.i2.hasNext()) {
                    return this.i2.next();
                }
                return null;
            }

            public void remove() {
            }
        };
    }

    public synchronized Iterator stableValueIterator() {
        return this.cache.values().iterator();
    }

    public synchronized Iterator weakValueIterator() {
        if (!this.withoutWeakPart) {
            return this.softCache.values().iterator();
        }
        return ((AbstractList)new Vector()).iterator();
    }

    public synchronized Iterator valueIterator() {
        return new Iterator(){
            Iterator i1;
            Iterator i2;
            {
                this.i1 = Cache.this.stableValueIterator();
                this.i2 = Cache.this.weakValueIterator();
            }

            public boolean hasNext() {
                if (this.i1.hasNext()) {
                    return true;
                }
                return this.i2.hasNext();
            }

            public Object next() {
                if (this.i1.hasNext()) {
                    return ((CacheQueueItem)this.i1.next()).value;
                }
                if (this.i2.hasNext()) {
                    return ((SoftValue)this.i2.next()).get();
                }
                return null;
            }

            public void remove() {
            }
        };
    }

    public void registerCacheListener(CacheListener cacheListener) {
        if (this.softCache.cacheListener != null) {
            throw new RuntimeException("SAP J2EE EENGINE|CACHE CONFIGURATION MANAGER| This cache has already been registered a listener");
        }
        this.softCache.registerListener(cacheListener);
    }
}

