/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.base;

import com.sap.engine.lib.util.base.BaseStack;
import com.sap.engine.lib.util.base.NextItem;

public class BaseWaitStack
extends BaseStack {
    private transient int waitPop = 0;
    private transient int waitPush = 0;

    public BaseWaitStack() {
        this(0);
    }

    public BaseWaitStack(int limit) {
        super(limit);
    }

    public synchronized boolean push(NextItem item) {
        boolean result;
        while (!(result = this.addFirstItem(item))) {
            Object var5_3;
            ++this.waitPop;
            try {
                try {
                    this.wait();
                }
                catch (InterruptedException _) {
                    var5_3 = null;
                    --this.waitPop;
                    break;
                }
                var5_3 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                var5_3 = null;
                --this.waitPop;
                throw throwable;
            }
        }
        if (this.waitPush > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized boolean push(NextItem item, long timeout) throws InterruptedException {
        boolean result = this.addFirstItem(item);
        if (!result) {
            ++this.waitPop;
            try {
                this.wait(timeout);
                Object var6_4 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                --this.waitPop;
                throw throwable;
            }
            result = this.addFirstItem(item);
        }
        if (this.waitPush > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized NextItem pop() {
        NextItem result;
        while ((result = this.removeFirstItem()) == null) {
            Object var4_2;
            ++this.waitPush;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var4_2 = null;
                    --this.waitPush;
                    break;
                }
                var4_2 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waitPush;
                throw throwable;
            }
        }
        if (this.waitPop > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized NextItem pop(long timeout) throws InterruptedException {
        NextItem result = this.removeFirstItem();
        if (result == null) {
            ++this.waitPush;
            try {
                this.wait(timeout);
                Object var5_3 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                --this.waitPush;
                throw throwable;
            }
            result = this.removeFirstItem();
        }
        if (this.waitPop > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized NextItem top() {
        NextItem result;
        while ((result = this.getFirstItem()) == null) {
            Object var4_2;
            ++this.waitPush;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var4_2 = null;
                    --this.waitPush;
                    break;
                }
                var4_2 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waitPush;
                throw throwable;
            }
        }
        return result;
    }

    public synchronized NextItem top(long timeout) throws InterruptedException {
        NextItem result = this.getFirstItem();
        if (result == null) {
            ++this.waitPush;
            try {
                this.wait(timeout);
                Object var5_2 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                Object var5_3 = null;
                --this.waitPush;
                throw throwable;
            }
            return this.getFirstItem();
        }
        return result;
    }
}

